/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rider.framework.OriginKind;
import com.jetbrains.rider.framework.impl.Range;
import com.jetbrains.rider.framework.impl.RdTextBuffer;
import com.jetbrains.rider.framework.impl.RdTextReplace;
import com.jetbrains.rider.framework.impl.TextBufferVersion;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016J \u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0006\u0010\u0019\u001a\u00020\u000fR\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/resharper/daemon/DocumentRangeShifter;", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "textBuffer", "Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/impl/RdTextBuffer;)V", "history", "Ljava/util/LinkedHashMap;", "Lcom/jetbrains/rider/framework/impl/TextBufferVersion;", "Lcom/jetbrains/rider/framework/impl/RdTextReplace;", "latestKnownSlaveVersion", "getTextBuffer", "()Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "clearHistoryBefore", "", "bufferVersion", "shiftRange", "Lcom/jetbrains/rider/framework/impl/Range;", "initialRangeVersion", "range", "isVerifiable", "", "shiftRangeInternal", "initialVersion", "shrinkHistory", "Companion", "rider"})
public final class DocumentRangeShifter {
    private final LinkedHashMap<TextBufferVersion, RdTextReplace> history;
    private TextBufferVersion latestKnownSlaveVersion;
    @NotNull
    private final RdTextBuffer textBuffer;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    public final void shrinkHistory() {
        Logger $receiver$iv = Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Clearing change history before " + this.latestKnownSlaveVersion;
            logger.trace(string2);
        }
        this.clearHistoryBefore(this.latestKnownSlaveVersion);
    }

    private final void clearHistoryBefore(TextBufferVersion bufferVersion) {
        TextBufferVersion key;
        Iterator<TextBufferVersion> iterator2 = this.history.keySet().iterator();
        while (iterator2.hasNext() && (key = iterator2.next()).compareTo(bufferVersion) < 0) {
            iterator2.remove();
        }
    }

    @NotNull
    public final Range shiftRange(@NotNull TextBufferVersion initialRangeVersion, @NotNull Range range, boolean isVerifiable) {
        Intrinsics.checkParameterIsNotNull((Object)initialRangeVersion, (String)"initialRangeVersion");
        Intrinsics.checkParameterIsNotNull((Object)range, (String)"range");
        if (Intrinsics.areEqual((Object)this.textBuffer.getBufferVersion(), (Object)initialRangeVersion)) {
            return range;
        }
        boolean bl = range.isNormalized();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Range: " + range + " is not normalized";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        if (!this.history.containsKey(initialRangeVersion)) {
            Companion.getLogger().error("Change " + initialRangeVersion + " cannot be found in history. ");
            return Range.Companion.getInvalidRange();
        }
        if (this.latestKnownSlaveVersion.compareTo(initialRangeVersion) < 0) {
            this.latestKnownSlaveVersion = initialRangeVersion;
        }
        return this.shiftRangeInternal(initialRangeVersion, range, isVerifiable);
    }

    private final Range shiftRangeInternal(TextBufferVersion initialVersion, Range range, boolean isVerifiable) {
        int resultStart = range.getStart();
        int resultEnd = range.getEnd();
        Map map2 = this.history;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            TextBufferVersion version = (TextBufferVersion)entry2.getKey();
            entry2 = entry;
            RdTextReplace change = (RdTextReplace)entry2.getValue();
            if (version.compareTo(initialVersion) <= 0) continue;
            String string2 = change.getOldValue();
            int oldLength = string2 != null ? string2.length() : 0;
            int newLength = change.getNewValue().length();
            int start2 = change.getStart();
            int end = start2 + oldLength;
            int delta = newLength - oldLength;
            if (resultEnd <= start2) continue;
            if (resultStart >= end) {
                resultStart += delta;
                resultEnd += delta;
                continue;
            }
            if (resultStart <= start2 && end <= resultEnd && !isVerifiable) {
                resultEnd += delta;
                continue;
            }
            return Range.Companion.getInvalidRange();
        }
        return new Range(resultStart, resultEnd);
    }

    @NotNull
    public final RdTextBuffer getTextBuffer() {
        return this.textBuffer;
    }

    public DocumentRangeShifter(@NotNull Lifetime lifetime, @NotNull RdTextBuffer textBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)textBuffer, (String)"textBuffer");
        this.textBuffer = textBuffer;
        this.history = new LinkedHashMap(20, 0.75f, false);
        this.latestKnownSlaveVersion = this.textBuffer.getBufferVersion();
        boolean bl = this.textBuffer.isMaster();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "DocumentRangeShifter works only on the master side";
            throw (Throwable)((Object)new AssertionError((Object)string2));
        }
        this.history.put(this.textBuffer.getBufferVersion(), new RdTextReplace(0, "", "", OriginKind.Local, 0, null));
        this.textBuffer.getHistoryChanged().advise(lifetime, (Function1<RdTextReplace, Unit>)((Function1)new Function1<RdTextReplace, Unit>(){

            public final void invoke(@NotNull RdTextReplace it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Map map2 = history;
                TextBufferVersion textBufferVersion = this.getTextBuffer().getBufferVersion();
                RdTextReplace rdTextReplace = it;
                map2.put(textBufferVersion, rdTextReplace);
                Logger $receiver$iv = Companion.getLogger();
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string2 = "Adding change " + it + " to version " + this.getTextBuffer().getBufferVersion();
                    logger.trace(string2);
                }
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DocumentRangeShifter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DocumentRangeShifter.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/daemon/DocumentRangeShifter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

