/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.containers.hash.LinkedHashMap;
import com.jetbrains.resharper.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.resharper.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.rider.model.FoldingHighlighterModel;
import com.jetbrains.rider.model.HighlighterModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 A2\u00020\u0001:\u0001AB\u0005\u00a2\u0006\u0002\u0010\u0002J\u001d\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\u00052\u0006\u0010&\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b'J\u0015\u0010(\u001a\u00020$2\u0006\u0010)\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b*J\r\u0010+\u001a\u00020$H\u0000\u00a2\u0006\u0002\b,J\u0013\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00060.H\u0000\u00a2\u0006\u0002\b/J\u0013\u00100\u001a\b\u0012\u0004\u0012\u00020\u00160.H\u0000\u00a2\u0006\u0002\b1J\u0018\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u0010&\u001a\u00020\u0006H\u0086\u0002\u00a2\u0006\u0002\u00103J\u0013\u00102\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u0005H\u0086\u0002J\u0006\u00104\u001a\u000205J\u0015\u00106\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b7J\u0015\u00108\u001a\u00020$2\u0006\u0010&\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b9J\u001f\u0010:\u001a\u0004\u0018\u00010\u00062\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b>J\u0017\u0010?\u001a\u0004\u0018\u00010\u00062\u0006\u0010%\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\b@R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00050\u0011j\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0005`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0013\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0011j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006`\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u00160\u0015j\b\u0012\u0004\u0012\u00020\u0016`\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000bR\u001e\u0010\u001a\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u001bj\b\u0012\u0004\u0012\u00020\u0006`\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00160\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060 8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006B"}, d2={"Lcom/jetbrains/resharper/daemon/HighlighterStorage;", "", "()V", "all", "Ljava/util/SortedMap;", "", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "getAll", "()Ljava/util/SortedMap;", "count", "getCount", "()I", "hasQueuedForDeletion", "", "getHasQueuedForDeletion", "()Z", "highlightersBackMap", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "highlightersMap", "invalidHighlighters", "Ljava/util/HashSet;", "Lcom/jetbrains/rider/model/HighlighterModel;", "Lkotlin/collections/HashSet;", "invalidHighlightersCount", "getInvalidHighlightersCount", "queuedForDeletion", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "queuedForRegistration", "Lcom/intellij/util/containers/hash/LinkedHashMap;", "registeredHighlighters", "", "getRegisteredHighlighters", "()Ljava/util/Collection;", "addHighlighter", "", "id", "highlighter", "addHighlighter$rider", "addInvalidHighlighter", "model", "addInvalidHighlighter$rider", "clear", "clear$rider", "flushNotDeleted", "", "flushNotDeleted$rider", "flushNotRegistered", "flushNotRegistered$rider", "get", "(Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;)Ljava/lang/Integer;", "printInfo", "", "queueDeletion", "queueDeletion$rider", "queueRegistration", "queueRegistration$rider", "recycle", "corrected", "Lcom/intellij/openapi/util/TextRange;", "riderHighlighter", "recycle$rider", "remove", "remove$rider", "Companion", "rider"})
public final class HighlighterStorage {
    private final HashMap<Integer, RangeHighlighterEx> highlightersMap;
    private final HashMap<RangeHighlighterEx, Integer> highlightersBackMap;
    private final HashSet<HighlighterModel> invalidHighlighters;
    private final LinkedHashMap<Integer, HighlighterModel> queuedForRegistration;
    private final ArrayList<RangeHighlighterEx> queuedForDeletion;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final Collection<RangeHighlighterEx> getRegisteredHighlighters() {
        Collection<RangeHighlighterEx> collection = this.highlightersMap.values();
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"highlightersMap.values");
        return collection;
    }

    @NotNull
    public final SortedMap<Integer, RangeHighlighterEx> getAll() {
        return MapsKt.toSortedMap((Map)this.highlightersMap);
    }

    public final int getInvalidHighlightersCount() {
        return this.invalidHighlighters.size();
    }

    public final int getCount() {
        return this.highlightersMap.size() + this.getInvalidHighlightersCount();
    }

    @Nullable
    public final RangeHighlighterEx get(int id) {
        return this.highlightersMap.get(id);
    }

    @Nullable
    public final Integer get(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        return this.highlightersBackMap.get(highlighter2);
    }

    @NotNull
    public final List<HighlighterModel> flushNotRegistered$rider() {
        List queued = CollectionsKt.toList((Iterable)this.queuedForRegistration.values());
        this.queuedForRegistration.clear();
        return queued;
    }

    @NotNull
    public final List<RangeHighlighterEx> flushNotDeleted$rider() {
        List queued = CollectionsKt.toList((Iterable)this.queuedForDeletion);
        this.queuedForDeletion.clear();
        return queued;
    }

    public final void queueRegistration$rider(@NotNull HighlighterModel highlighter2) {
        Object object;
        Object object2;
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        Logger $receiver$iv = HighlighterStorage.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            object2 = highlighter2;
            object = new StringBuilder().append("Deferred registration for ");
            System.out.print(object2);
            String string2 = ((StringBuilder)object).append(Unit.INSTANCE).toString();
            logger.trace(string2);
        }
        Map map2 = (Map)this.queuedForRegistration;
        object2 = highlighter2.getId();
        object = highlighter2;
        map2.put(object2, object);
    }

    public final void queueDeletion$rider(@NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        Logger $receiver$iv = HighlighterStorage.Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            RangeHighlighterEx rangeHighlighterEx = highlighter2;
            StringBuilder stringBuilder = new StringBuilder().append("Deferred deletion from markup for ");
            System.out.print(rangeHighlighterEx);
            String string2 = stringBuilder.append(Unit.INSTANCE).toString();
            logger.trace(string2);
        }
        this.queuedForDeletion.add(highlighter2);
    }

    @Nullable
    public final RangeHighlighterEx recycle$rider(@NotNull TextRange corrected, @NotNull HighlighterModel riderHighlighter) {
        Intrinsics.checkParameterIsNotNull((Object)corrected, (String)"corrected");
        Intrinsics.checkParameterIsNotNull((Object)riderHighlighter, (String)"riderHighlighter");
        RangeHighlighterEx recycled = null;
        for (RangeHighlighterEx h2 : this.queuedForDeletion) {
            if (h2.getStartOffset() != corrected.getStartOffset() || h2.getEndOffset() != corrected.getEndOffset() || !HighlightersUtilKt.standsFor(h2, riderHighlighter)) continue;
            if (riderHighlighter instanceof FoldingHighlighterModel) {
                FoldingInfo info;
                if (FoldingInfoKt.getFoldingInfo(h2) == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.areEqual((Object)((FoldingHighlighterModel)riderHighlighter).getPlaceholderText(), (Object)info.getPlaceholderText()) ^ true) continue;
            }
            recycled = h2;
            Logger $receiver$iv = HighlighterStorage.Companion.getLogger();
            if (!$receiver$iv.isTraceEnabled()) break;
            Logger logger = $receiver$iv;
            String string2 = "Successfully recycled highlighter for (" + h2.getStartOffset() + "," + h2.getEndOffset() + "), " + HighlightersUtilKt.getRiderHighlighterType(h2);
            logger.trace(string2);
            break;
        }
        if (recycled != null) {
            this.queuedForDeletion.remove(recycled);
        }
        return recycled;
    }

    public final void addInvalidHighlighter$rider(@NotNull HighlighterModel model2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        this.invalidHighlighters.add(model2);
    }

    public final void addHighlighter$rider(int id, @NotNull RangeHighlighterEx highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        Map map2 = this.highlightersMap;
        Integer n2 = id;
        RangeHighlighterEx rangeHighlighterEx = highlighter2;
        map2.put(n2, rangeHighlighterEx);
        map2 = this.highlightersBackMap;
        n2 = id;
        map2.put(highlighter2, n2);
    }

    @Nullable
    public final RangeHighlighterEx remove$rider(int id) {
        if (this.queuedForRegistration.remove((Object)id) != null) {
            return null;
        }
        RangeHighlighterEx highlighter2 = this.highlightersMap.get(id);
        if (highlighter2 == null) {
            if (!CollectionsKt.removeAll((Iterable)this.invalidHighlighters, (Function1)((Function1)new Function1<HighlighterModel, Boolean>(id){
                final /* synthetic */ int $id;

                public final boolean invoke(@NotNull HighlighterModel it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return it.getId() == this.$id;
                }
                {
                    this.$id = n2;
                    super(1);
                }
            }))) {
                HighlighterStorage.Companion.getLogger().warn("Deleting non-existing highlighter " + id);
            }
            return null;
        }
        this.highlightersMap.remove(id);
        this.highlightersBackMap.remove(highlighter2);
        return highlighter2;
    }

    public final void clear$rider() {
        HighlighterStorage.Companion.getLogger().debug("Clearing the whole highlighter storage. " + this.printInfo());
        this.highlightersMap.clear();
        this.highlightersBackMap.clear();
        this.invalidHighlighters.clear();
        this.queuedForRegistration.clear();
        this.queuedForDeletion.clear();
    }

    @NotNull
    public final String printInfo() {
        return "All=" + this.getCount() + "\n" + ("Registered=" + this.highlightersMap.size() + "\n") + ("Invalid=" + this.getInvalidHighlightersCount() + "\n") + ("NotRegistered=" + this.queuedForRegistration.size() + "\n") + ("NotDeleted=" + this.queuedForDeletion.size());
    }

    public final boolean getHasQueuedForDeletion() {
        Collection collection = this.queuedForDeletion;
        return !collection.isEmpty();
    }

    public HighlighterStorage() {
        HighlighterStorage highlighterStorage = this;
        Cloneable cloneable = new HashMap();
        highlighterStorage.highlightersMap = cloneable;
        highlighterStorage = this;
        cloneable = new HashMap();
        highlighterStorage.highlightersBackMap = cloneable;
        highlighterStorage = this;
        cloneable = new HashSet();
        highlighterStorage.invalidHighlighters = cloneable;
        this.queuedForRegistration = new LinkedHashMap(30);
        highlighterStorage = this;
        cloneable = new ArrayList();
        highlighterStorage.queuedForDeletion = cloneable;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(HighlighterStorage.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        HighlighterStorage.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/daemon/HighlighterStorage$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

