/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.daemon.DocumentRangeShifter;
import com.jetbrains.resharper.daemon.HighlighterRegistrationHost;
import com.jetbrains.rider.framework.impl.Range;
import com.jetbrains.rider.framework.impl.RdTextBuffer;
import com.jetbrains.rider.framework.impl.TextBufferVersion;
import com.jetbrains.rider.model.DocumentVersion;
import com.jetbrains.rider.model.HighlighterModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0006\u0010\u0017\u001a\u00020\u0018J\u001a\u0010\u0019\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/resharper/daemon/RiderHighlighterRangeRepairer;", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "textBuffer", "Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "document", "Lcom/intellij/openapi/editor/Document;", "registrationHost", "Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/rider/framework/impl/RdTextBuffer;Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;)V", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "shifter", "Lcom/jetbrains/resharper/daemon/DocumentRangeShifter;", "checkHighlighterText", "", "h", "Lcom/jetbrains/rider/model/HighlighterModel;", "correctedRange", "Lcom/intellij/openapi/util/TextRange;", "repair", "repairInternal", "shrinkHistory", "", "validate", "Companion", "rider"})
public final class RiderHighlighterRangeRepairer {
    private final DocumentRangeShifter shifter;
    @NotNull
    private final Lifetime lifetime;
    private final Document document;
    private final HighlighterRegistrationHost registrationHost;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @Nullable
    public final TextRange repair(@NotNull HighlighterModel h2) {
        Intrinsics.checkParameterIsNotNull((Object)h2, (String)"h");
        TextRange correctedRange = this.repairInternal(h2);
        if (!this.validate(correctedRange, h2)) {
            return null;
        }
        return correctedRange;
    }

    private final TextRange repairInternal(HighlighterModel h2) {
        boolean isVerifiable;
        Range initialRange;
        DocumentVersion v2 = h2.getDocumentVersion();
        TextBufferVersion initialVersion = new TextBufferVersion(v2.getMaster(), v2.getSlave());
        Range range = this.shifter.shiftRange(initialVersion, initialRange = new Range(h2.getStart(), h2.getEnd()), isVerifiable = this.registrationHost.isVerifiable(h2.getRegistryKey()));
        if (Intrinsics.areEqual((Object)range, (Object)Range.Companion.getInvalidRange())) {
            return null;
        }
        return TextRange.create((int)range.getStart(), (int)range.getEnd());
    }

    private final boolean validate(TextRange correctedRange, HighlighterModel h2) {
        if (correctedRange == null) {
            Companion.getLogger().debug("Received invalid highlighter. Unrolling id=" + h2.getId() + " (" + h2.getStart() + "," + h2.getEnd() + ")");
            return false;
        }
        if (correctedRange.getStartOffset() < 0 || correctedRange.getEndOffset() > this.document.getTextLength()) {
            Companion.getLogger().error("Corrected range:" + correctedRange + " for " + ("highlighter:{id:" + h2.getId() + ",key:" + h2.getRegistryKey() + ",text:" + "\"" + h2.getTextToHighlight() + "\"" + "} ") + ("is shifted out of the document (0," + this.document.getTextLength() + ")"));
            return false;
        }
        return !this.registrationHost.isVerifiable(h2.getRegistryKey()) || this.checkHighlighterText(h2, correctedRange);
    }

    /*
     * WARNING - void declaration
     */
    private final boolean checkHighlighterText(HighlighterModel h2, TextRange correctedRange) {
        String highlighterText = h2.getTextToHighlight();
        CharSequence charSequence = highlighterText;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return true;
        }
        boolean isInsideDocument = correctedRange.getEndOffset() <= this.document.getTextLength();
        String ideaDocumentText = isInsideDocument ? this.document.getText(correctedRange) : null;
        boolean isCorrect = Intrinsics.areEqual((Object)highlighterText, (Object)ideaDocumentText);
        if (!isCorrect) {
            void hs;
            void hm;
            void ds;
            void dm;
            DocumentVersion documentVersion;
            TextBufferVersion textBufferVersion = this.shifter.getTextBuffer().getBufferVersion();
            int n2 = textBufferVersion.component1();
            int n3 = textBufferVersion.component2();
            textBufferVersion = null;
            DocumentVersion $receiver = documentVersion = h2.getDocumentVersion();
            Pair pair = TuplesKt.to((Object)$receiver.getMaster(), (Object)$receiver.getSlave());
            int n4 = ((Number)pair.component1()).intValue();
            int n5 = ((Number)pair.component2()).intValue();
            pair = null;
            Companion.getLogger().error("Highlighter id=" + h2.getId() + " (" + h2.getStart() + "," + h2.getEnd() + ") is applied to the wrong text." + "\n" + " " + ("Versions: document=(" + (int)dm + "," + (int)ds + ") highlighter=(" + (int)hm + "," + (int)hs + ")" + "\n") + ("Text: " + "\n" + "backend=  " + "\"" + highlighterText + "\"" + "\n" + " frontend= " + "\"" + ideaDocumentText + "\""));
        }
        return isCorrect;
    }

    public final void shrinkHistory() {
        this.shifter.shrinkHistory();
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public RiderHighlighterRangeRepairer(@NotNull Lifetime lifetime, @NotNull RdTextBuffer textBuffer, @NotNull Document document, @NotNull HighlighterRegistrationHost registrationHost2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)textBuffer, (String)"textBuffer");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)registrationHost2, (String)"registrationHost");
        this.lifetime = lifetime;
        this.document = document;
        this.registrationHost = registrationHost2;
        this.shifter = new DocumentRangeShifter(this.lifetime, textBuffer);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderHighlighterRangeRepairer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderHighlighterRangeRepairer.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/daemon/RiderHighlighterRangeRepairer$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

