/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.jetbrains.resharper.daemon.HighlighterRegistrationHost;
import com.jetbrains.resharper.daemon.IRiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.RiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategy;
import com.jetbrains.rider.model.RdMarkupModel;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/daemon/RiderMarkupAdapterFactory;", "", "registrationHost", "Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "(Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;)V", "create", "Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;", "rdMarkup", "Lcom/jetbrains/rider/model/RdMarkupModel;", "ideaMarkup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "initializationStrategies", "", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategy;", "Companion", "rider"})
public class RiderMarkupAdapterFactory {
    private final HighlighterRegistrationHost registrationHost;
    private static final Logger logger;
    @NotNull
    private static final LanguageExtension<RiderMarkupAdapterFactory> extensions;
    public static final Companion Companion;

    @NotNull
    public IRiderDocumentMarkupAdapter create(@NotNull RdMarkupModel rdMarkup, @NotNull MarkupModelEx ideaMarkup, @NotNull List<? extends RiderHighlighterInitializationStrategy> initializationStrategies) {
        Intrinsics.checkParameterIsNotNull((Object)rdMarkup, (String)"rdMarkup");
        Intrinsics.checkParameterIsNotNull((Object)ideaMarkup, (String)"ideaMarkup");
        Intrinsics.checkParameterIsNotNull(initializationStrategies, (String)"initializationStrategies");
        return new RiderDocumentMarkupAdapter(rdMarkup, ideaMarkup, this.registrationHost, initializationStrategies);
    }

    public RiderMarkupAdapterFactory(@NotNull HighlighterRegistrationHost registrationHost2) {
        Intrinsics.checkParameterIsNotNull((Object)registrationHost2, (String)"registrationHost");
        this.registrationHost = registrationHost2;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderMarkupAdapterFactory.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderMarkupAdapterFactory.logger = logger;
        extensions = new LanguageExtension("com.intellij.backend.markup.adapterFactory");
    }

    @NotNull
    public static final LanguageExtension<RiderMarkupAdapterFactory> getExtensions() {
        return Companion.getExtensions();
    }

    @JvmStatic
    @Nullable
    public static final RiderMarkupAdapterFactory forLanguage(@NotNull Language language) {
        Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
        return Companion.forLanguage(language);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000e\u001a\u00020\u000fH\u0007R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/daemon/RiderMarkupAdapterFactory$Companion;", "", "()V", "extensions", "Lcom/intellij/lang/LanguageExtension;", "Lcom/jetbrains/resharper/daemon/RiderMarkupAdapterFactory;", "extensions$annotations", "getExtensions", "()Lcom/intellij/lang/LanguageExtension;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "forLanguage", "language", "Lcom/intellij/lang/Language;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        private static /* synthetic */ void extensions$annotations() {
        }

        @NotNull
        public final LanguageExtension<RiderMarkupAdapterFactory> getExtensions() {
            return extensions;
        }

        @JvmStatic
        @Nullable
        public final RiderMarkupAdapterFactory forLanguage(@NotNull Language language) {
            Intrinsics.checkParameterIsNotNull((Object)language, (String)"language");
            List forKey = this.getExtensions().forKey((Object)language);
            if (forKey.size() > 1) {
                this.getLogger().error("More than one RiderMarkupAdapterFactory is registered for " + language + ". Omitting support");
                return null;
            }
            return (RiderMarkupAdapterFactory)CollectionsKt.firstOrNull((List)forKey);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

