/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.resharper.daemon.HighlighterRegistrationHost;
import com.jetbrains.resharper.daemon.MarkupSuppressionKind;
import com.jetbrains.resharper.daemon.RiderMarkupSuppressor$WhenMappings;
import com.jetbrains.resharper.internal.flags.RiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlags;
import com.jetbrains.resharper.util.idea.LoggerKt;
import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.reactive.ViewableExKt;
import com.jetbrains.rider.util.reactive.ViewableSet;
import java.awt.Color;
import javax.naming.OperationNotSupportedException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ$\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fJ\"\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00130\u001aJ\u0010\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0016\u0010 \u001a\u00020\u00132\u0006\u0010!\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/jetbrains/resharper/daemon/RiderMarkupSuppressor;", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "registrationHost", "Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "riderInternalFlags", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;)V", "deletionSuppress", "Lcom/jetbrains/rider/util/reactive/IReadonlyProperty;", "", "deletionSuppressionPolicies", "Lcom/jetbrains/rider/util/reactive/ViewableSet;", "fullSuppress", "Lcom/jetbrains/rider/util/reactive/IProperty;", "fullSuppressionPolicies", "shouldUseHighlighterReusing", "addSuppressionRule", "", "ruleLifetime", "kind", "Lcom/jetbrains/resharper/daemon/MarkupSuppressionKind;", "provider", "released", "action", "Lkotlin/Function1;", "shouldQueueForReuse", "registryKey", "", "shouldSuppressAddition", "shouldSuppressDeletion", "suppress", "lf", "Companion", "rider"})
public final class RiderMarkupSuppressor {
    private final boolean shouldUseHighlighterReusing = false;
    private final ViewableSet<Object> fullSuppressionPolicies;
    private final ViewableSet<Object> deletionSuppressionPolicies;
    private final IProperty<Boolean> fullSuppress;
    private final IReadonlyProperty<Boolean> deletionSuppress;
    private final Lifetime lifetime;
    private final HighlighterRegistrationHost registrationHost;
    @NotNull
    private static final String HIGHLIGHTER_REUSING_KEY = "rider.highlighters.reusing";
    @NotNull
    private static final String description = "Helps to reduce highlighter blinking by deferring deletion up to the end of the Daemon work";
    @NotNull
    private static final RiderInternalFlag<Boolean> flag;
    private static final Logger logger;
    public static final Companion Companion;

    public final boolean shouldSuppressAddition(int registryKey) {
        if (PropertyExKt.getHasTrueValue((IReadonlyProperty<Boolean>)this.fullSuppress)) {
            return true;
        }
        return !this.registrationHost.isVerifiable(registryKey);
    }

    public final boolean shouldSuppressDeletion(int registryKey) {
        if (PropertyExKt.getHasTrueValue((IReadonlyProperty<Boolean>)this.fullSuppress)) {
            return true;
        }
        if (this.shouldQueueForReuse(registryKey)) {
            return true;
        }
        return !this.registrationHost.isVerifiable(registryKey);
    }

    public final void released(@NotNull Lifetime lifetime, @NotNull Function1<? super Lifetime, Unit> action2) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        PropertyExKt.whenFalse(this.deletionSuppress, lifetime, action2);
    }

    public final void addSuppressionRule(@NotNull Lifetime ruleLifetime, @NotNull MarkupSuppressionKind kind, @NotNull IProperty<Boolean> provider) {
        Intrinsics.checkParameterIsNotNull((Object)ruleLifetime, (String)"ruleLifetime");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        Intrinsics.checkParameterIsNotNull(provider, (String)"provider");
        LifetimeExKt.assertIsAlive(this.lifetime);
        provider.view(LifetimeExKt.intersect(ruleLifetime, this.lifetime), (Function2<Lifetime, Boolean, Unit>)((Function2)new Function2<Lifetime, Boolean, Unit>(this, kind){
            final /* synthetic */ RiderMarkupSuppressor this$0;
            final /* synthetic */ MarkupSuppressionKind $kind;

            public final void invoke(@NotNull Lifetime lt, boolean v2) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                if (v2) {
                    this.this$0.suppress(lt, this.$kind);
                }
            }
            {
                this.this$0 = riderMarkupSuppressor;
                this.$kind = markupSuppressionKind;
                super(2);
            }
        }));
    }

    public final void suppress(@NotNull Lifetime lf, @NotNull MarkupSuppressionKind kind) {
        Intrinsics.checkParameterIsNotNull((Object)lf, (String)"lf");
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        LifetimeExKt.assertIsAlive(this.lifetime);
        Lifetime intersection = LifetimeExKt.intersect(lf, this.lifetime);
        LoggerKt.traceBracket(RiderMarkupSuppressor.Companion.getLogger(), intersection, "started suppression: " + (Object)((Object)kind), "stopped suppression " + (Object)((Object)kind));
        switch (RiderMarkupSuppressor$WhenMappings.$EnumSwitchMapping$0[kind.ordinal()]) {
            case 1: {
                CollectionExKt.addUnique(this.deletionSuppressionPolicies, intersection, new Object());
                break;
            }
            case 2: {
                CollectionExKt.addUnique(this.fullSuppressionPolicies, intersection, new Object());
                break;
            }
            default: {
                String string2 = "Unknown SuppressionKind";
                throw (Throwable)new IllegalStateException(string2.toString());
            }
        }
    }

    private final boolean shouldQueueForReuse(int registryKey) {
        if (this.shouldUseHighlighterReusing) {
            return PropertyExKt.getHasTrueValue(this.deletionSuppress) && this.registrationHost.isRecyclable(registryKey);
        }
        return false;
    }

    public RiderMarkupSuppressor(@NotNull Lifetime lifetime, @NotNull HighlighterRegistrationHost registrationHost2, @NotNull RiderInternalFlags riderInternalFlags) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)registrationHost2, (String)"registrationHost");
        Intrinsics.checkParameterIsNotNull((Object)riderInternalFlags, (String)"riderInternalFlags");
        this.lifetime = lifetime;
        this.registrationHost = registrationHost2;
        this.fullSuppressionPolicies = new ViewableSet();
        this.deletionSuppressionPolicies = new ViewableSet();
        this.fullSuppress = ViewableExKt.createIsNotEmpty(this.fullSuppressionPolicies, this.lifetime);
        this.deletionSuppress = PropertyExKt.or((IReadonlyProperty<Boolean>)ViewableExKt.createIsNotEmpty(this.deletionSuppressionPolicies, this.lifetime), this.lifetime, (IReadonlyProperty<Boolean>)this.fullSuppress);
        RiderMarkupSuppressor.Companion.getLogger().debug("Creating markup suppressor");
        this.released(this.lifetime, (Function1<? super Lifetime, Unit>)((Function1)1.INSTANCE));
    }

    /*
     * WARNING - void declaration
     */
    static {
        RiderInternalFlag<void> riderInternalFlag;
        void desc$iv;
        void key$iv;
        void defaultValue$iv;
        Companion = new Companion(null);
        HIGHLIGHTER_REUSING_KEY = HIGHLIGHTER_REUSING_KEY;
        description = description;
        RiderInternalFlag.Companion companion = RiderInternalFlag.Companion;
        String string2 = Companion.getHIGHLIGHTER_REUSING_KEY();
        Boolean bl = true;
        String string3 = Companion.getDescription();
        boolean isRestartRequired$iv = true;
        void var5_5 = defaultValue$iv;
        if (var5_5 instanceof Boolean) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, (String)desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Boolean);
        } else if (var5_5 instanceof String) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, (String)desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.String);
        } else if (var5_5 instanceof Integer) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, (String)desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Int);
        } else if (var5_5 instanceof Color) {
            riderInternalFlag = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, (String)desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Color);
        } else {
            throw (Throwable)new OperationNotSupportedException("Error in RiderInternalFlag registration (" + (String)key$iv + ")");
        }
        flag = riderInternalFlag;
        Logger logger = Logger.getInstance(RiderMarkupSuppressor.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderMarkupSuppressor.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/daemon/RiderMarkupSuppressor$Companion;", "", "()V", "HIGHLIGHTER_REUSING_KEY", "", "getHIGHLIGHTER_REUSING_KEY", "()Ljava/lang/String;", "description", "getDescription", "flag", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlag;", "", "getFlag", "()Lcom/jetbrains/resharper/internal/flags/RiderInternalFlag;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final String getHIGHLIGHTER_REUSING_KEY() {
            return HIGHLIGHTER_REUSING_KEY;
        }

        @NotNull
        public final String getDescription() {
            return description;
        }

        @NotNull
        public final RiderInternalFlag<Boolean> getFlag() {
            return flag;
        }

        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

