/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.components;

import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsListener;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/resharper/daemon/components/DynamicallyRegisteredHighlighterColorUpdaterHost;", "Lcom/intellij/openapi/editor/colors/EditorColorsListener;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "editorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/intellij/openapi/editor/colors/EditorColorsManager;)V", "getEditorColorsManager", "()Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "getEditorManager", "()Lcom/intellij/openapi/fileEditor/FileEditorManager;", "getProject", "()Lcom/intellij/openapi/project/Project;", "globalSchemeChange", "", "newScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "rider"})
public final class DynamicallyRegisteredHighlighterColorUpdaterHost
extends AbstractProjectComponent
implements EditorColorsListener {
    @NotNull
    private final Project project;
    @NotNull
    private final FileEditorManager editorManager;
    @NotNull
    private final EditorColorsManager editorColorsManager;

    /*
     * WARNING - void declaration
     */
    public void globalSchemeChange(@Nullable EditorColorsScheme newScheme) {
        void $receiver$iv$iv;
        Object $receiver$iv;
        EditorColorsScheme editorColorsScheme = newScheme;
        if (editorColorsScheme == null) {
            EditorColorsScheme editorColorsScheme2 = this.editorColorsManager.getGlobalScheme();
            editorColorsScheme = editorColorsScheme2;
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme2, (String)"editorColorsManager.globalScheme");
        }
        EditorColorsScheme scheme2 = editorColorsScheme;
        HashSet<MarkupModelEx> markups = new HashSet<MarkupModelEx>();
        Object object = $receiver$iv = (Object[])this.editorManager.getAllEditors();
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv$iv).length; ++i2) {
            TextEditor textEditor;
            void element$iv$iv$iv = $receiver$iv$iv$iv[i2];
            void element$iv$iv = element$iv$iv$iv;
            FileEditor it = (FileEditor)element$iv$iv;
            FileEditor fileEditor = it;
            if (!(fileEditor instanceof TextEditor)) {
                fileEditor = null;
            }
            if ((TextEditor)fileEditor == null) continue;
            TextEditor it$iv$iv = textEditor;
            destination$iv$iv.add(it$iv$iv);
        }
        $receiver$iv = (List)destination$iv$iv;
        object = $receiver$iv.iterator();
        while (object.hasNext()) {
            Object element$iv = object.next();
            TextEditor it = (TextEditor)element$iv;
            Document document = it.getEditor().getDocument();
            MarkupModel markupModel = DocumentMarkupModel.forDocument(document, this.project, false);
            if (markupModel == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
            }
            MarkupModelEx markup = (MarkupModelEx)markupModel;
            markups.add(markup);
        }
        ApplicationKt.getApplication().assertIsDispatchThread();
        for (MarkupModelEx markup : markups) {
            RangeHighlighter[] rangeHighlighterArray = markup.getAllHighlighters();
            for (int i3 = 0; i3 < rangeHighlighterArray.length; ++i3) {
                RangeHighlighter h2 = rangeHighlighterArray[i3];
                if (!(HighlightersUtilKt.getTryGetRegistryKey(h2) instanceof Integer)) continue;
                RangeHighlighter rangeHighlighter = h2;
                if (rangeHighlighter == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeHighlighterEx");
                }
                markup.changeAttributesInBatch((RangeHighlighterEx)rangeHighlighter, (Consumer<RangeHighlighterEx>)((Consumer)new Consumer<RangeHighlighterEx>(h2, scheme2){
                    final /* synthetic */ RangeHighlighter $h;
                    final /* synthetic */ EditorColorsScheme $scheme;

                    public final void consume(RangeHighlighterEx h1) {
                        HighlightInfoType highlightInfoType = HighlightersUtilKt.getHighlightInfoType(this.$h);
                        TextAttributesKey key = highlightInfoType != null ? highlightInfoType.getAttributesKey() : null;
                        TextAttributes textAttributes = this.$scheme.getAttributes(key);
                        if (textAttributes == null) {
                            return;
                        }
                        TextAttributes attributes = textAttributes;
                        h1.setTextAttributes(attributes);
                    }
                    {
                        this.$h = rangeHighlighter;
                        this.$scheme = editorColorsScheme;
                    }
                }));
            }
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FileEditorManager getEditorManager() {
        return this.editorManager;
    }

    @NotNull
    public final EditorColorsManager getEditorColorsManager() {
        return this.editorColorsManager;
    }

    public DynamicallyRegisteredHighlighterColorUpdaterHost(@NotNull Project project2, @NotNull FileEditorManager editorManager, @NotNull EditorColorsManager editorColorsManager) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editorManager, (String)"editorManager");
        Intrinsics.checkParameterIsNotNull((Object)editorColorsManager, (String)"editorColorsManager");
        super(project2);
        this.project = project2;
        this.editorManager = editorManager;
        this.editorColorsManager = editorColorsManager;
        this.project.getMessageBus().connect().subscribe(EditorColorsManager.TOPIC, (Object)this);
    }
}

