/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.components;

import com.intellij.codeInsight.daemon.impl.DaemonListeners;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.resharper.daemon.DocumentMarkupContributor;
import com.jetbrains.resharper.daemon.HighlighterRegistrationHost;
import com.jetbrains.resharper.daemon.IRiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.MarkupSuppressionKind;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategy;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategyProvider;
import com.jetbrains.resharper.daemon.RiderHighlighterRangeRepairer;
import com.jetbrains.resharper.daemon.RiderMarkupAdapterFactory;
import com.jetbrains.resharper.daemon.RiderMarkupSuppressor;
import com.jetbrains.resharper.daemon.components.RiderMarkupHostKt;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.document.DocumentHost;
import com.jetbrains.resharper.editors.RiderTrafficLightRenderer;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.internal.flags.RiderInternalFlags;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.resharper.util.idea.LoggerKt;
import com.jetbrains.rider.framework.impl.RdTextBuffer;
import com.jetbrains.rider.model.DaemonStateEnum;
import com.jetbrains.rider.model.EditableEntity;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.ErrorStripeIndicatorStateEnum;
import com.jetbrains.rider.model.HighlighterIdList;
import com.jetbrains.rider.model.HighlighterList;
import com.jetbrains.rider.model.RdEmptyMarkupModel;
import com.jetbrains.rider.model.RdMarkupModel;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.model.TextControlModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 62\u00020\u0001:\u00016B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ(\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020'H\u0002J\u001e\u0010(\u001a\u00020)2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010&\u001a\u00020'2\u0006\u0010*\u001a\u00020+J \u0010,\u001a\u00020-2\u0006\u0010#\u001a\u00020\u000e2\u0006\u0010.\u001a\u00020/2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u00100\u001a\u0002012\u0006\u00102\u001a\u0002032\u0006\u00104\u001a\u000205H\u0002R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010\u0019\u001a0\u0012\f\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b \u001c*\u0017\u0012\u000e\b\u0001\u0012\n \u001c*\u0004\u0018\u00010\u001b0\u001b0\u001a\u00a2\u0006\u0002\b\u001d0\u001a\u00a2\u0006\u0002\b\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/jetbrains/resharper/daemon/components/RiderMarkupHost;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "registrationHost", "Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "riderInternalFlags", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;", "psiDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/editors/TextControlHost;Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;Lcom/intellij/psi/PsiDocumentManager;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "documentHost", "Lcom/jetbrains/resharper/document/DocumentHost;", "getDocumentHost", "()Lcom/jetbrains/resharper/document/DocumentHost;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getRegistrationHost", "()Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "strategyProviders", "", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategyProvider;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "[Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategyProvider;", "createMarkupAdapter", "Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;", "adapterFactory", "Lcom/jetbrains/resharper/daemon/RiderMarkupAdapterFactory;", "lifetime", "markupModel", "Lcom/jetbrains/rider/model/RdMarkupModel;", "document", "Lcom/intellij/openapi/editor/Document;", "createRangeRepairer", "Lcom/jetbrains/resharper/daemon/RiderHighlighterRangeRepairer;", "textBuffer", "Lcom/jetbrains/rider/framework/impl/RdTextBuffer;", "createSuppressor", "Lcom/jetbrains/resharper/daemon/RiderMarkupSuppressor;", "filename", "", "createTrafficLightRenderer", "Lcom/jetbrains/resharper/editors/RiderTrafficLightRenderer;", "editor", "Lcom/intellij/openapi/editor/Editor;", "textControlModel", "Lcom/jetbrains/rider/model/TextControlModel;", "Companion", "rider"})
public final class RiderMarkupHost
implements ILifetimedComponent {
    @NotNull
    private final DocumentHost documentHost;
    private final RiderHighlighterInitializationStrategyProvider[] strategyProviders;
    @NotNull
    private final Project project;
    private final TextControlHost textControlHost;
    @NotNull
    private final HighlighterRegistrationHost registrationHost;
    private final RiderInternalFlags riderInternalFlags;
    private final PsiDocumentManager psiDocumentManager;
    private static final Logger logger;
    @NotNull
    private static final Key<Map<Document, DocumentMarkupContributor>> markupContributorKey;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final DocumentHost getDocumentHost() {
        return this.documentHost;
    }

    private final RiderTrafficLightRenderer createTrafficLightRenderer(Editor editor, TextControlModel textControlModel) {
        IProperty<ErrorStripeIndicatorStateEnum> backendIndicator = textControlModel.getIndicatorState();
        PsiFile psiFile = this.psiDocumentManager.getPsiFile(editor.getDocument());
        if (psiFile == null) {
            Intrinsics.throwNpe();
        }
        PsiFile psiFile2 = psiFile;
        Document document = editor.getDocument();
        Intrinsics.checkExpressionValueIsNotNull((Object)document, (String)"editor.document");
        PsiFile psiFile3 = psiFile2;
        Intrinsics.checkExpressionValueIsNotNull((Object)psiFile3, (String)"psiFile");
        return new RiderTrafficLightRenderer(this.project, document, psiFile3, backendIndicator);
    }

    /*
     * WARNING - void declaration
     */
    private final IRiderDocumentMarkupAdapter createMarkupAdapter(RiderMarkupAdapterFactory adapterFactory, Lifetime lifetime, RdMarkupModel markupModel, Document document) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        MarkupModel markupModel2 = DocumentMarkupModel.forDocument(document, this.project, true);
        if (markupModel2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.MarkupModelEx");
        }
        MarkupModelEx ideaMarkup = (MarkupModelEx)markupModel2;
        Object[] objectArray = $receiver$iv = (Object[])this.strategyProviders;
        Collection destination$iv$iv = new ArrayList($receiver$iv.length);
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv).length; ++i2) {
            void it;
            void item$iv$iv = $receiver$iv$iv[i2];
            RiderHighlighterInitializationStrategyProvider riderHighlighterInitializationStrategyProvider = (RiderHighlighterInitializationStrategyProvider)item$iv$iv;
            Collection collection = destination$iv$iv;
            RiderHighlighterInitializationStrategy riderHighlighterInitializationStrategy = it.createStrategy(lifetime, markupModel, document);
            collection.add(riderHighlighterInitializationStrategy);
        }
        List initializationStrategies = (List)destination$iv$iv;
        return adapterFactory.create(markupModel, ideaMarkup, initializationStrategies);
    }

    private final RiderMarkupSuppressor createSuppressor(Lifetime lifetime, String filename, RdMarkupModel markupModel) {
        RiderMarkupSuppressor suppressor = new RiderMarkupSuppressor(lifetime, this.registrationHost, this.riderInternalFlags);
        IProperty<Boolean> daemonIsWorking2 = PropertyExKt.map((IReadonlyProperty)markupModel.getDaemonState(), lifetime, (Function1)new Function1<DaemonStateEnum, Boolean>(filename){
            final /* synthetic */ String $filename;

            public final boolean invoke(@NotNull DaemonStateEnum it) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                com.jetbrains.resharper.daemon.components.RiderMarkupHost$Companion.access$getLogger$p(RiderMarkupHost.Companion).debug("Daemon state for " + this.$filename + " -> " + (Object)((Object)it));
                return Intrinsics.areEqual((Object)((Object)it), (Object)((Object)DaemonStateEnum.INVALIDATED)) || Intrinsics.areEqual((Object)((Object)it), (Object)((Object)DaemonStateEnum.IN_PROGRESS_LOCAL)) || Intrinsics.areEqual((Object)((Object)it), (Object)((Object)DaemonStateEnum.IN_PROGRESS_GLOBAL));
            }
            {
                this.$filename = string2;
                super(1);
            }
        });
        suppressor.addSuppressionRule(lifetime, MarkupSuppressionKind.DELETION, daemonIsWorking2);
        return suppressor;
    }

    @NotNull
    public final RiderHighlighterRangeRepairer createRangeRepairer(@NotNull Lifetime lifetime, @NotNull Document document, @NotNull RdTextBuffer textBuffer) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)textBuffer, (String)"textBuffer");
        return new RiderHighlighterRangeRepairer(lifetime, textBuffer, document, this.registrationHost);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final HighlighterRegistrationHost getRegistrationHost() {
        return this.registrationHost;
    }

    public RiderMarkupHost(@NotNull Project project2, @NotNull TextControlHost textControlHost, @NotNull HighlighterRegistrationHost registrationHost2, @NotNull RiderInternalFlags riderInternalFlags, @NotNull PsiDocumentManager psiDocumentManager) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)registrationHost2, (String)"registrationHost");
        Intrinsics.checkParameterIsNotNull((Object)riderInternalFlags, (String)"riderInternalFlags");
        Intrinsics.checkParameterIsNotNull((Object)psiDocumentManager, (String)"psiDocumentManager");
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.textControlHost = textControlHost;
        this.registrationHost = registrationHost2;
        this.riderInternalFlags = riderInternalFlags;
        this.psiDocumentManager = psiDocumentManager;
        this.documentHost = this.textControlHost.getDocumentHost();
        this.strategyProviders = (RiderHighlighterInitializationStrategyProvider[])Extensions.getExtensions(RiderHighlighterInitializationStrategyProvider.Companion.getEP_NAME(), (AreaInstance)((AreaInstance)this.project));
        this.documentHost.getOpenedDocuments().view(this.getComponentLifetime(), (Function2<Lifetime, Map.Entry<EditableEntityId, Document>, Unit>)((Function2)new Function2<Lifetime, Map.Entry<? extends EditableEntityId, ? extends Document>, Unit>(){

            public final void invoke(@NotNull Lifetime lifetime, @NotNull Map.Entry<EditableEntityId, ? extends Document> result2) {
                Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
                Intrinsics.checkParameterIsNotNull(result2, (String)"result");
                final EditableEntityId entityId = result2.getKey();
                String filename = DocumentExKt.getFileName(entityId);
                Object v2 = this.getDocumentHost().getOpenedEntities().get(entityId);
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                final EditableEntity entity = (EditableEntity)v2;
                Document document = result2.getValue();
                PsiFile psiFile = psiDocumentManager.getPsiFile(document);
                if (psiFile == null) {
                    Intrinsics.throwNpe();
                }
                PsiFile psiFile2 = psiFile;
                Language language = psiFile2.getLanguage();
                Intrinsics.checkExpressionValueIsNotNull((Object)language, (String)"psiFile.language");
                RiderMarkupAdapterFactory adapterFactory = RiderMarkupAdapterFactory.Companion.forLanguage(language);
                if (adapterFactory == null) {
                    PropertyExKt.set(entity.getMarkup(), new RdEmptyMarkupModel());
                    return;
                }
                Companion.getLogger().info("Creating markup contributor for " + filename);
                final RdMarkupModel markupModel = new RdMarkupModel(false);
                IRiderDocumentMarkupAdapter markupAdapter = this.createMarkupAdapter(adapterFactory, lifetime, markupModel, document);
                RiderHighlighterRangeRepairer repairer = this.createRangeRepairer(lifetime, document, entity.getText());
                RiderMarkupSuppressor suppressor = this.createSuppressor(lifetime, filename, markupModel);
                final DocumentMarkupContributor contributor = new DocumentMarkupContributor(markupAdapter, repairer, suppressor);
                LoggerKt.infoBracket(Companion.getLogger(), lifetime, "Start viewing model changes", "All markup subscriptions has gone");
                markupModel.getHighlightersRemoved().advise(lifetime, (Function1<HighlighterIdList, Unit>)((Function1)new Function1<HighlighterIdList, Unit>(){

                    public final void invoke(@NotNull HighlighterIdList it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        contributor.highlightersRemoved(it.getElements());
                    }
                }));
                markupModel.getHighlightersAdded().advise(lifetime, (Function1<HighlighterList, Unit>)((Function1)new Function1<HighlighterList, Unit>(){

                    public final void invoke(@NotNull HighlighterList it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        contributor.highlightersAdded(it.getElements());
                    }
                }));
                suppressor.released(lifetime, (Function1<? super Lifetime, Unit>)((Function1)new Function1<Lifetime, Unit>(){

                    public final void invoke(@NotNull Lifetime it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        contributor.flushHighlighters();
                    }
                }));
                lifetime.add((Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        contributor.removeAllHighlighters();
                    }
                }));
                RiderMarkupHostKt.putContributor(this.getProject(), document, contributor, lifetime);
                PropertyExKt.set(entity.getMarkup(), markupModel);
                textControlHost.getOpenedEditors().view(lifetime, (Function3<Lifetime, TextControlId, Editor, Unit>)((Function3)new Function3<Lifetime, TextControlId, Editor, Unit>(){

                    public final void invoke(@NotNull Lifetime lt, @NotNull TextControlId id, final @NotNull Editor editor) {
                        Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                        if (Intrinsics.areEqual((Object)id.getDocumentId(), (Object)entityId) ^ true) {
                            return;
                        }
                        editor.getSettings().setShowIntentionBulb(false);
                        Object v2 = entity.getTabsForDocument().getTextControls().get(id);
                        if (v2 == null) {
                            Intrinsics.throwNpe();
                        }
                        TextControlModel textControlModel = (TextControlModel)v2;
                        RiderTrafficLightRenderer renderer = this.createTrafficLightRenderer(editor, textControlModel);
                        MarkupModel markupModel2 = editor.getMarkupModel();
                        if (markupModel2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorMarkupModelImpl");
                        }
                        final EditorMarkupModelImpl editorMarkup = (EditorMarkupModelImpl)markupModel2;
                        editorMarkup.setErrorStripeRenderer(renderer);
                        markupModel.getDaemonState().advise(lt, (Function1<DaemonStateEnum, Unit>)((Function1)new Function1<DaemonStateEnum, Unit>(){

                            public final void invoke(@NotNull DaemonStateEnum it) {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)it), (String)"it");
                                editorMarkup.repaintTrafficLightIcon();
                                DaemonListeners.repaintErrorStripeRenderer(editor, this.getProject());
                            }
                        }));
                    }
                }));
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderMarkupHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderMarkupHost.logger = logger;
        markupContributorKey = new Key("DocumentMarkupContributor");
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u000e\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R#\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/daemon/components/RiderMarkupHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "markupContributorKey", "Lcom/intellij/openapi/util/Key;", "", "Lcom/intellij/openapi/editor/Document;", "Lcom/jetbrains/resharper/daemon/DocumentMarkupContributor;", "getMarkupContributorKey", "()Lcom/intellij/openapi/util/Key;", "getMarkupContributor", "project", "Lcom/intellij/openapi/project/Project;", "document", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Key<Map<Document, DocumentMarkupContributor>> getMarkupContributorKey() {
            return markupContributorKey;
        }

        @Nullable
        public final DocumentMarkupContributor getMarkupContributor(@NotNull Project project2, @NotNull Document document) {
            Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
            return RiderMarkupHostKt.getContributor(project2, document);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

