/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.highlighters.customStyle;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.ui.ColorUtil;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategy;
import com.jetbrains.resharper.daemon.util.ModelUtilKt;
import com.jetbrains.rider.model.CustomStyleHighlighterModel;
import com.jetbrains.rider.model.HighlighterModel;
import com.jetbrains.rider.model.highlighterRegistration.IdeaTextAttributes;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/customStyle/RiderCustomStyleHighlighterInitializationStrategy;", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategy;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "(Lcom/intellij/openapi/editor/colors/EditorColorsManager;)V", "accept", "", "model", "Lcom/jetbrains/rider/model/HighlighterModel;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "initialize", "", "isDarkScheme", "rider"})
public final class RiderCustomStyleHighlighterInitializationStrategy
implements RiderHighlighterInitializationStrategy {
    private final EditorColorsManager editorColorsManager;

    @Override
    public boolean accept(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        return model2 instanceof CustomStyleHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        HighlighterModel highlighterModel = model2;
        if (highlighterModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.CustomStyleHighlighterModel");
        }
        CustomStyleHighlighterModel cfr_ignored_0 = (CustomStyleHighlighterModel)highlighterModel;
        RangeHighlighter rangeHighlighter = highlighter2;
        if (rangeHighlighter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeHighlighterEx");
        }
        RangeHighlighterEx cfr_ignored_1 = (RangeHighlighterEx)rangeHighlighter;
        IdeaTextAttributes attributeModel = this.isDarkScheme() ? ((CustomStyleHighlighterModel)model2).getDarkAttributes() : ((CustomStyleHighlighterModel)model2).getLightAttributes();
        ((RangeHighlighterEx)highlighter2).setTextAttributes(ModelUtilKt.toIdeaAttributes(attributeModel));
    }

    private final boolean isDarkScheme() {
        return ColorUtil.isDark((Color)this.editorColorsManager.getGlobalScheme().getDefaultBackground());
    }

    public RiderCustomStyleHighlighterInitializationStrategy(@NotNull EditorColorsManager editorColorsManager) {
        Intrinsics.checkParameterIsNotNull((Object)editorColorsManager, (String)"editorColorsManager");
        this.editorColorsManager = editorColorsManager;
    }

    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkParameterIsNotNull(highlighters, (String)"highlighters");
        RiderHighlighterInitializationStrategy.DefaultImpls.afterBulkAdd(this, highlighters);
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkParameterIsNotNull(highlighters, (String)"highlighters");
        RiderHighlighterInitializationStrategy.DefaultImpls.beforeBulkRemove(this, highlighters);
    }
}

