/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.highlighters.defaultHighlighters;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.daemon.HighlighterRegistrationHost;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategy;
import com.jetbrains.resharper.daemon.highlighters.defaultHighlighters.tooltips.RiderAsyncTooltipHighlightInfo;
import com.jetbrains.resharper.daemon.highlighters.defaultHighlighters.tooltips.RiderTooltipProvider;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.rider.model.DefaultHighlighterModel;
import com.jetbrains.rider.model.HighlighterModel;
import java.awt.Color;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/defaultHighlighters/RiderDefaultHighlighterInitializationStrategy;", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategy;", "document", "Lcom/intellij/openapi/editor/Document;", "registrationHost", "Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;", "editorColorsManager", "Lcom/intellij/openapi/editor/colors/EditorColorsManager;", "tooltipProvider", "Lcom/jetbrains/resharper/daemon/highlighters/defaultHighlighters/tooltips/RiderTooltipProvider;", "(Lcom/intellij/openapi/editor/Document;Lcom/jetbrains/resharper/daemon/HighlighterRegistrationHost;Lcom/intellij/openapi/editor/colors/EditorColorsManager;Lcom/jetbrains/resharper/daemon/highlighters/defaultHighlighters/tooltips/RiderTooltipProvider;)V", "accept", "", "model", "Lcom/jetbrains/rider/model/HighlighterModel;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "createHighlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "range", "Lcom/intellij/openapi/util/TextRange;", "registryKey", "", "id", "initialize", "", "rider"})
public final class RiderDefaultHighlighterInitializationStrategy
implements RiderHighlighterInitializationStrategy {
    private final Document document;
    private final HighlighterRegistrationHost registrationHost;
    private final EditorColorsManager editorColorsManager;
    private final RiderTooltipProvider tooltipProvider;

    @Override
    public boolean accept(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        return model2 instanceof DefaultHighlighterModel;
    }

    @Override
    public void initialize(@NotNull HighlighterModel model2, @NotNull RangeHighlighter highlighter2) {
        TextAttributes attributes;
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        HighlighterModel highlighterModel = model2;
        if (highlighterModel == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.rider.model.DefaultHighlighterModel");
        }
        DefaultHighlighterModel cfr_ignored_0 = (DefaultHighlighterModel)highlighterModel;
        TextRange range = new TextRange(highlighter2.getStartOffset(), highlighter2.getEndOffset());
        HighlightInfo info = this.createHighlightInfo(range, model2.getRegistryKey(), model2.getId());
        RangeHighlighter rangeHighlighter = highlighter2;
        if (rangeHighlighter == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.RangeHighlighterEx");
        }
        info.setHighlighter((RangeHighlighterEx)rangeHighlighter);
        ((RangeHighlighterEx)highlighter2).setAfterEndOfLine(info.isAfterEndOfLine());
        ((RangeHighlighterEx)highlighter2).setErrorStripeTooltip(info);
        TextAttributes textAttributes = attributes = HighlighterRegistrationHost.DefaultImpls.getTextAttributes$default(this.registrationHost, model2.getRegistryKey(), null, 2, null);
        if (textAttributes != null) {
            TextAttributes textAttributes2;
            TextAttributes it = textAttributes2 = textAttributes;
            ((RangeHighlighterEx)highlighter2).setTextAttributes(attributes);
        }
        if (info.getSeverity().compareTo(HighlightSeverity.INFORMATION) > 0) {
            EditorColorsScheme editorColorsScheme = this.editorColorsManager.getGlobalScheme();
            Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"editorColorsManager.globalScheme");
            Color color = HighlightersUtilKt.getErrorStripeColor(info, editorColorsScheme);
            if (color != null) {
                ((RangeHighlighterEx)highlighter2).setErrorStripeMarkColor(color);
            }
        }
    }

    private final HighlightInfo createHighlightInfo(TextRange range, int registryKey, int id) {
        HighlightInfoType infoType = this.registrationHost.getHighlightInfoType(registryKey);
        if (infoType == null) {
            String name = this.registrationHost.getAttributeId(registryKey);
            String string2 = "highlighter key:" + registryKey + ", type: '" + name + "', range: " + range + " can't be used to create HighlightInfo";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        boolean isAfterEOL = range.getLength() == 1 && this.document.getImmutableCharSequence().charAt(range.getStartOffset()) == '\n';
        TextAttributes textAttributes = HighlighterRegistrationHost.DefaultImpls.getTextAttributes$default(this.registrationHost, registryKey, null, 2, null);
        boolean needsUpdate = !this.registrationHost.isRecyclable(registryKey);
        return new RiderAsyncTooltipHighlightInfo(textAttributes, infoType, range, isAfterEOL, needsUpdate, id, this.tooltipProvider);
    }

    public RiderDefaultHighlighterInitializationStrategy(@NotNull Document document, @NotNull HighlighterRegistrationHost registrationHost2, @NotNull EditorColorsManager editorColorsManager, @NotNull RiderTooltipProvider tooltipProvider) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Intrinsics.checkParameterIsNotNull((Object)registrationHost2, (String)"registrationHost");
        Intrinsics.checkParameterIsNotNull((Object)editorColorsManager, (String)"editorColorsManager");
        Intrinsics.checkParameterIsNotNull((Object)tooltipProvider, (String)"tooltipProvider");
        this.document = document;
        this.registrationHost = registrationHost2;
        this.editorColorsManager = editorColorsManager;
        this.tooltipProvider = tooltipProvider;
    }

    @Override
    public void afterBulkAdd(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkParameterIsNotNull(highlighters, (String)"highlighters");
        RiderHighlighterInitializationStrategy.DefaultImpls.afterBulkAdd(this, highlighters);
    }

    @Override
    public void beforeBulkRemove(@NotNull List<? extends RangeHighlighter> highlighters) {
        Intrinsics.checkParameterIsNotNull(highlighters, (String)"highlighters");
        RiderHighlighterInitializationStrategy.DefaultImpls.beforeBulkRemove(this, highlighters);
    }
}

