/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.highlighters.foldings;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategy;
import com.jetbrains.resharper.daemon.RiderHighlighterInitializationStrategyProvider;
import com.jetbrains.resharper.daemon.highlighters.foldings.RiderCodeFoldingInitializationStrategy;
import com.jetbrains.resharper.daemon.highlighters.foldings.RiderCodeFoldingManager;
import com.jetbrains.resharper.daemon.highlighters.foldings.RiderFoldingModelAggregator;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.RdMarkupModel;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u000bH\u0002J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/foldings/RiderCodeFoldingManager;", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategyProvider;", "project", "Lcom/intellij/openapi/project/Project;", "psiDocumentManager", "Lcom/intellij/psi/PsiDocumentManager;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/PsiDocumentManager;Lcom/jetbrains/resharper/editors/TextControlHost;)V", "_aggregators", "", "Lcom/jetbrains/resharper/daemon/highlighters/foldings/RiderFoldingModelAggregator;", "foldingModelAggregators", "", "getFoldingModelAggregators", "()Ljava/util/List;", "getPsiDocumentManager", "()Lcom/intellij/psi/PsiDocumentManager;", "addAggregator", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "aggregator", "codeFoldingDisabled", "", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "createStrategy", "Lcom/jetbrains/resharper/daemon/RiderHighlighterInitializationStrategy;", "markupModel", "Lcom/jetbrains/rider/model/RdMarkupModel;", "document", "Lcom/intellij/openapi/editor/Document;", "rider"})
public final class RiderCodeFoldingManager
implements RiderHighlighterInitializationStrategyProvider {
    private final List<RiderFoldingModelAggregator> _aggregators;
    private final Project project;
    @NotNull
    private final PsiDocumentManager psiDocumentManager;
    private final TextControlHost textControlHost;

    @NotNull
    public final List<RiderFoldingModelAggregator> getFoldingModelAggregators() {
        return this._aggregators;
    }

    @Override
    @NotNull
    public RiderHighlighterInitializationStrategy createStrategy(@NotNull Lifetime lifetime, @NotNull RdMarkupModel markupModel, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)markupModel, (String)"markupModel");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        RiderCodeFoldingInitializationStrategy initializationStrategy = new RiderCodeFoldingInitializationStrategy(document, this.project);
        this.addAggregator(lifetime, initializationStrategy);
        return initializationStrategy;
    }

    private final void addAggregator(Lifetime lifetime, RiderFoldingModelAggregator aggregator) {
        this.textControlHost.getOpenedEditors().view(lifetime, (Function3<Lifetime, TextControlId, Editor, Unit>)((Function3)new Function3<Lifetime, TextControlId, Editor, Unit>(this, aggregator){
            final /* synthetic */ RiderCodeFoldingManager this$0;
            final /* synthetic */ RiderFoldingModelAggregator $aggregator;

            public final void invoke(@NotNull Lifetime lt, @NotNull TextControlId $noName_1, @NotNull Editor editor) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
                if (Intrinsics.areEqual((Object)editor.getDocument(), (Object)this.$aggregator.getDocument()) ^ true) {
                    return;
                }
                PsiFile file2 = this.this$0.getPsiDocumentManager().getPsiFile(this.$aggregator.getDocument());
                if (file2 == null || !file2.isValid() || !file2.getViewProvider().isPhysical()) {
                    return;
                }
                ApplicationKt.getApplication().invokeLater(new Runnable(this, editor, lt){
                    final /* synthetic */ addAggregator.1 this$0;
                    final /* synthetic */ Editor $editor;
                    final /* synthetic */ Lifetime $lt;

                    public final void run() {
                        AsyncEditorLoader.performWhenLoaded(this.$editor, new Runnable(this){
                            final /* synthetic */ addAggregator.1 this$0;

                            public final void invoke() {
                                Editor editor = this.this$0.$editor;
                                if (editor == null) {
                                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.editor.impl.EditorImpl");
                                }
                                EditorImpl cfr_ignored_0 = (EditorImpl)editor;
                                if (((EditorImpl)this.this$0.$editor).isDisposed() || this.this$0.$lt.isTerminated()) {
                                    return;
                                }
                                if (this.this$0.this$0.this$0.codeFoldingDisabled((EditorImpl)this.this$0.$editor)) {
                                    return;
                                }
                                this.this$0.this$0.$aggregator.addEditor(this.this$0.$lt, (EditorImpl)this.this$0.$editor);
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        });
                    }
                    {
                        this.this$0 = var1_1;
                        this.$editor = editor;
                        this.$lt = lifetime;
                    }
                });
            }
            {
                this.this$0 = riderCodeFoldingManager;
                this.$aggregator = riderFoldingModelAggregator;
                super(3);
            }
        }));
    }

    public final boolean codeFoldingDisabled(@NotNull EditorImpl editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        if (!editor.getSettings().isAutoCodeFoldingEnabled()) {
            return true;
        }
        if (!editor.getFoldingModel().isFoldingEnabled()) {
            return true;
        }
        return !editor.getSettings().isFoldingOutlineShown();
    }

    @NotNull
    public final PsiDocumentManager getPsiDocumentManager() {
        return this.psiDocumentManager;
    }

    public RiderCodeFoldingManager(@NotNull Project project2, @NotNull PsiDocumentManager psiDocumentManager, @NotNull TextControlHost textControlHost) {
        List list2;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)psiDocumentManager, (String)"psiDocumentManager");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        this.project = project2;
        this.psiDocumentManager = psiDocumentManager;
        this.textControlHost = textControlHost;
        RiderCodeFoldingManager riderCodeFoldingManager = this;
        riderCodeFoldingManager._aggregators = list2 = (List)new ArrayList();
    }
}

