/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.highlighters.foldings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FoldingModelImpl;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.util.SmartList;
import com.jetbrains.resharper.daemon.highlighters.foldings.FoldingInfo;
import com.jetbrains.resharper.daemon.highlighters.foldings.FoldingInfoKt;
import com.jetbrains.resharper.daemon.highlighters.foldings.IRiderEditorFoldingModelAdapter;
import com.jetbrains.resharper.settings.foldings.RiderCodeFoldingSettings;
import com.jetbrains.resharper.settings.foldings.RiderFoldingSettingsSnapshot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0004\u0018\u0000 #2\u00020\u0001:\u0001#B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J*\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0016\u0010\u0019\u001a\u00020\r2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016J\u0015\u0010\u001b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00120\u001cH\u0016\u00a2\u0006\u0002\u0010\u001dJ\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0002J\u0016\u0010!\u001a\u00020\r2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/foldings/RiderEditorFoldingModelAdapter;", "Lcom/jetbrains/resharper/daemon/highlighters/foldings/IRiderEditorFoldingModelAdapter;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "(Lcom/intellij/openapi/editor/impl/EditorImpl;)V", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "foldingModel", "Lcom/intellij/openapi/editor/impl/FoldingModelImpl;", "Lorg/jetbrains/annotations/NotNull;", "isInitialized", "", "addFoldings", "", "newHighlighters", "", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "addOrReuseFoldRegion", "Lcom/intellij/openapi/editor/FoldRegion;", "start", "", "end", "placeholder", "", "collapsedByDefault", "associateFoldRegions", "toAdd", "getAllFoldRegions", "", "()[Lcom/intellij/openapi/editor/FoldRegion;", "initFoldings", "highlighters", "", "removeFoldRegions", "toRemove", "Companion", "rider"})
public final class RiderEditorFoldingModelAdapter
implements IRiderEditorFoldingModelAdapter {
    private final FoldingModelImpl foldingModel;
    private boolean isInitialized;
    @NotNull
    private final EditorImpl editor;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    @Override
    public void associateFoldRegions(@NotNull Collection<? extends RangeHighlighter> toAdd) {
        Intrinsics.checkParameterIsNotNull(toAdd, (String)"toAdd");
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new Runnable(this, toAdd){
            final /* synthetic */ RiderEditorFoldingModelAdapter this$0;
            final /* synthetic */ Collection $toAdd;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                if (RiderEditorFoldingModelAdapter.access$isInitialized$p(this.this$0)) {
                    RiderEditorFoldingModelAdapter.access$addFoldings(this.this$0, this.$toAdd);
                } else {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    Iterable iterable = $receiver$iv = (Iterable)this.$toAdd;
                    Collection destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        RangeHighlighter it = (RangeHighlighter)element$iv$iv;
                        if (!(FoldingInfoKt.getFoldingInfo(it) != null)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List newHighlighters = (List)destination$iv$iv;
                    Collection collection = newHighlighters;
                    if (!collection.isEmpty()) {
                        RiderEditorFoldingModelAdapter.access$setInitialized$p(this.this$0, true);
                        RiderEditorFoldingModelAdapter.access$initFoldings(this.this$0, newHighlighters);
                    }
                }
            }
            {
                this.this$0 = riderEditorFoldingModelAdapter;
                this.$toAdd = collection;
            }
        });
    }

    private final void addFoldings(Collection<? extends RangeHighlighter> newHighlighters) {
        for (RangeHighlighter rangeHighlighter : newHighlighters) {
            FoldRegion region;
            FoldingInfo info;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null) {
                continue;
            }
            if (this.addOrReuseFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info.getPlaceholderText(), info.getCollapsedByDefault()) == null) {
                Intrinsics.throwNpe();
            }
            info.getRegions().add((Object)region);
        }
    }

    private final void initFoldings(List<? extends RangeHighlighter> highlighters) {
        FoldingInfo info;
        RiderFoldingSettingsSnapshot settings = RiderCodeFoldingSettings.Companion.getSnapshot();
        List oldRegions = ArraysKt.toMutableList((Object[])this.foldingModel.getAllFoldRegions());
        List newRegions = new ArrayList();
        for (RangeHighlighter rangeHighlighter : highlighters) {
            FoldRegion reuseCandidate;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null) {
                Intrinsics.throwNpe();
            }
            if ((reuseCandidate = this.foldingModel.getFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset())) != null) {
                FoldRegion reused = reuseCandidate;
                oldRegions.remove(reused);
                if (Intrinsics.areEqual((Object)reused.getPlaceholderText(), (Object)info.getPlaceholderText()) ^ true) {
                    this.foldingModel.removeFoldRegion(reused);
                    FoldRegion foldRegion = this.foldingModel.addFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info.getPlaceholderText());
                    if (foldRegion == null) {
                        Intrinsics.throwNpe();
                    }
                    reused = foldRegion;
                }
                if (reused.isExpanded()) {
                    reused.setExpanded(!settings.isCollapsed(rangeHighlighter));
                }
                info.getRegions().add((Object)reused);
                continue;
            }
            newRegions.add(rangeHighlighter);
        }
        for (FoldRegion foldRegion : oldRegions) {
            this.foldingModel.removeFoldRegion(foldRegion);
        }
        for (RangeHighlighter rangeHighlighter : newRegions) {
            FoldRegion newRegion;
            if (FoldingInfoKt.getFoldingInfo(rangeHighlighter) == null) {
                Intrinsics.throwNpe();
            }
            if (this.foldingModel.addFoldRegion(rangeHighlighter.getStartOffset(), rangeHighlighter.getEndOffset(), info.getPlaceholderText()) == null) {
                Intrinsics.throwNpe();
            }
            info.getRegions().add((Object)newRegion);
            newRegion.setExpanded(!settings.isCollapsed(rangeHighlighter));
        }
    }

    @Override
    public void removeFoldRegions(@NotNull Collection<? extends RangeHighlighter> toRemove) {
        Intrinsics.checkParameterIsNotNull(toRemove, (String)"toRemove");
        this.foldingModel.runBatchFoldingOperationDoNotCollapseCaret(new Runnable(this, toRemove){
            final /* synthetic */ RiderEditorFoldingModelAdapter this$0;
            final /* synthetic */ Collection $toRemove;

            public final void run() {
                for (RangeHighlighter h2 : this.$toRemove) {
                    T element$iv2;
                    SmartList<FoldRegion> foldRegions;
                    block3: {
                        SmartList<FoldRegion> smartList = FoldingInfoKt.getFoldingInfo(h2);
                        if (smartList == null || (smartList = smartList.getRegions()) == null) {
                            continue;
                        }
                        foldRegions = smartList;
                        Iterable $receiver$iv = (Iterable)foldRegions;
                        for (T element$iv2 : $receiver$iv) {
                            FoldRegion it = (FoldRegion)element$iv2;
                            if (!Intrinsics.areEqual((Object)it.getEditor(), (Object)this.this$0.getEditor())) continue;
                            break block3;
                        }
                        throw (Throwable)new NoSuchElementException("Collection contains no element matching the predicate.");
                    }
                    FoldRegion region = (FoldRegion)element$iv2;
                    foldRegions.remove((Object)region);
                    if (!region.isValid()) continue;
                    RiderEditorFoldingModelAdapter.access$getFoldingModel$p(this.this$0).removeFoldRegion(region);
                }
            }
            {
                this.this$0 = riderEditorFoldingModelAdapter;
                this.$toRemove = collection;
            }
        });
    }

    @Override
    @NotNull
    public FoldRegion[] getAllFoldRegions() {
        FoldRegion[] foldRegionArray = this.foldingModel.getAllFoldRegions();
        Intrinsics.checkExpressionValueIsNotNull((Object)foldRegionArray, (String)"foldingModel.allFoldRegions");
        return foldRegionArray;
    }

    private final FoldRegion addOrReuseFoldRegion(int start2, int end, String placeholder, boolean collapsedByDefault) {
        FoldRegion existingRegion = this.foldingModel.getFoldRegion(start2, end);
        Boolean wasExpanded = null;
        if (existingRegion != null) {
            if (Intrinsics.areEqual((Object)existingRegion.getPlaceholderText(), (Object)placeholder)) {
                return existingRegion;
            }
            wasExpanded = existingRegion.isExpanded();
            this.foldingModel.removeFoldRegion(existingRegion);
        }
        FoldRegion foldRegion = this.foldingModel.createFoldRegion(start2, end, placeholder, null, false);
        if (foldRegion == null) {
            Intrinsics.throwNpe();
        }
        FoldRegion newRegion = foldRegion;
        Boolean bl = wasExpanded;
        newRegion.setExpanded(bl != null ? bl : !collapsedByDefault);
        return this.foldingModel.addFoldRegion(newRegion) ? newRegion : null;
    }

    @Override
    @NotNull
    public EditorImpl getEditor() {
        return this.editor;
    }

    public RiderEditorFoldingModelAdapter(@NotNull EditorImpl editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        this.editor = editor;
        this.foldingModel = this.getEditor().getFoldingModel();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderEditorFoldingModelAdapter.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderEditorFoldingModelAdapter.logger = logger;
    }

    public static final /* synthetic */ boolean access$isInitialized$p(RiderEditorFoldingModelAdapter $this) {
        return $this.isInitialized;
    }

    public static final /* synthetic */ void access$setInitialized$p(RiderEditorFoldingModelAdapter $this, boolean bl) {
        $this.isInitialized = bl;
    }

    public static final /* synthetic */ void access$addFoldings(RiderEditorFoldingModelAdapter $this, @NotNull Collection newHighlighters) {
        $this.addFoldings(newHighlighters);
    }

    public static final /* synthetic */ void access$initFoldings(RiderEditorFoldingModelAdapter $this, @NotNull List highlighters) {
        $this.initFoldings(highlighters);
    }

    @NotNull
    public static final /* synthetic */ FoldingModelImpl access$getFoldingModel$p(RiderEditorFoldingModelAdapter $this) {
        return $this.foldingModel;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/foldings/RiderEditorFoldingModelAdapter$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

