/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.highlighters.gutterMarks;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SoftWrap;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.TextRange;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.rider.model.GutterMarkActionActivator;
import com.jetbrains.rider.model.GutterMarkHighlighterModel;
import com.jetbrains.rider.model.RdGutterExecutionRequest;
import java.util.ListIterator;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0011\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0000H\u0086\u0002J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0011\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\n\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0010H\u0016J\b\u0010\u001e\u001a\u00020\u0013H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/resharper/daemon/highlighters/gutterMarks/RiderGutterIconRenderer;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "highlighter", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "model", "Lcom/jetbrains/rider/model/GutterMarkHighlighterModel;", "gutterMarkActionActivator", "Lcom/jetbrains/rider/model/GutterMarkActionActivator;", "myIconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;Lcom/jetbrains/rider/model/GutterMarkHighlighterModel;Lcom/jetbrains/rider/model/GutterMarkActionActivator;Lcom/jetbrains/resharper/icons/IconHost;)V", "getHighlighter", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getModel", "()Lcom/jetbrains/rider/model/GutterMarkHighlighterModel;", "compareTo", "", "other", "equals", "", "", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getIcon", "Ljavax/swing/Icon;", "getTooltipText", "", "hashCode", "isNavigateAction", "rider"})
public final class RiderGutterIconRenderer
extends GutterIconRenderer {
    @NotNull
    private final RangeHighlighter highlighter;
    @NotNull
    private final GutterMarkHighlighterModel model;
    private final GutterMarkActionActivator gutterMarkActionActivator;
    private final IconHost myIconHost;

    @NotNull
    public Icon getIcon() {
        return IconHostKt.toIdeaIcon(this.model.getIcon(), this.myIconHost);
    }

    @NotNull
    public AnAction getClickAction() {
        return new AnAction(this, this.getIcon()){
            final /* synthetic */ RiderGutterIconRenderer this$0;

            public void actionPerformed(@Nullable AnActionEvent e2) {
                TextRange textRange;
                AnActionEvent anActionEvent = e2;
                if (anActionEvent == null || (anActionEvent = (Editor)anActionEvent.getData(CommonDataKeys.EDITOR)) == null) {
                    return;
                }
                AnActionEvent editor = anActionEvent;
                SoftWrapModel softWrapModel = editor.getSoftWrapModel();
                int offset = this.this$0.getHighlighter().getStartOffset();
                SoftWrap softWrap = softWrapModel.getSoftWrap(offset);
                if (softWrap != null) {
                    SoftWrap softWrap2;
                    SoftWrap it = softWrap2 = softWrap;
                    textRange = new TextRange(it.getStart(), it.getEnd());
                } else {
                    textRange = new TextRange(EditorUtil.getNotFoldedLineStartOffset((Editor)editor, offset), EditorUtil.getNotFoldedLineEndOffset((Editor)editor, offset));
                }
                TextRange rangeToCollectBulbs = textRange;
                RiderGutterIconRenderer.access$getGutterMarkActionActivator$p(this.this$0).getLeftClick().fire(new RdGutterExecutionRequest(this.this$0.getModel().getId(), rangeToCollectBulbs.getStartOffset(), rangeToCollectBulbs.getEndOffset()));
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        };
    }

    public boolean isNavigateAction() {
        return this.model.isNavigatable();
    }

    @Nullable
    public String getTooltipText() {
        return this.model.getTooltip();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        Object object = other;
        if (!(object instanceof RiderGutterIconRenderer)) {
            object = null;
        }
        RiderGutterIconRenderer otherResharperRenderer = (RiderGutterIconRenderer)((Object)object);
        if (other == null || otherResharperRenderer == null) {
            return false;
        }
        return this.model.getId() == otherResharperRenderer.model.getId();
    }

    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.LEFT;
    }

    public int hashCode() {
        return 397 * this.model.getIcon().hashCode() ^ this.model.getId();
    }

    public final int compareTo(@NotNull RiderGutterIconRenderer other) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)other), (String)"other");
        ListIterator iterator2 = CollectionsKt.asReversed(this.model.getPriority()).listIterator();
        ListIterator otherIterator = CollectionsKt.asReversed(other.model.getPriority()).listIterator();
        while (iterator2.hasNext() && otherIterator.hasNext()) {
            long value2 = ((Number)iterator2.next()).longValue();
            long otherValue = ((Number)otherIterator.next()).longValue();
            if (value2 < (long)0 && otherValue < (long)0) continue;
            if (value2 < (long)0) {
                return 1;
            }
            if (otherValue < (long)0) {
                return -1;
            }
            long diff = value2 - otherValue;
            return diff < (long)0 ? -1 : (diff > (long)0 ? 1 : 0);
        }
        if (iterator2.hasNext()) {
            return -1;
        }
        if (otherIterator.hasNext()) {
            return 1;
        }
        return StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE).compare(this.model.getTooltip(), other.model.getTooltip());
    }

    @NotNull
    public final RangeHighlighter getHighlighter() {
        return this.highlighter;
    }

    @NotNull
    public final GutterMarkHighlighterModel getModel() {
        return this.model;
    }

    public RiderGutterIconRenderer(@NotNull RangeHighlighter highlighter2, @NotNull GutterMarkHighlighterModel model2, @NotNull GutterMarkActionActivator gutterMarkActionActivator, @NotNull IconHost myIconHost) {
        Intrinsics.checkParameterIsNotNull((Object)highlighter2, (String)"highlighter");
        Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
        Intrinsics.checkParameterIsNotNull((Object)gutterMarkActionActivator, (String)"gutterMarkActionActivator");
        Intrinsics.checkParameterIsNotNull((Object)myIconHost, (String)"myIconHost");
        this.highlighter = highlighter2;
        this.model = model2;
        this.gutterMarkActionActivator = gutterMarkActionActivator;
        this.myIconHost = myIconHost;
    }

    @NotNull
    public static final /* synthetic */ GutterMarkActionActivator access$getGutterMarkActionActivator$p(RiderGutterIconRenderer $this) {
        return $this.gutterMarkActionActivator;
    }
}

