/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.util;

import com.intellij.openapi.util.Segment;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u0004\"\b\b\u0000\u0010\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u0002H\u00050\u000b2\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u0002H\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00040\rJ(\u0010\u000e\u001a\u00020\u000f*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0003J(\u0010\u0014\u001a\u00020\u0015*\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00102\u0006\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/daemon/util/HighlighterTextAnnotator;", "", "()V", "annotateWithTags", "", "TRange", "Lcom/intellij/openapi/util/Segment;", "text", "ranges", "", "comparator", "Ljava/util/Comparator;", "rangeTagNamePrinter", "Lkotlin/Function1;", "calculateAbsoluteOffset", "", "Ljava/util/TreeMap;", "currentOffset", "isStartTag", "", "updateOffset", "", "index", "value", "rider"})
public final class HighlighterTextAnnotator {
    public static final HighlighterTextAnnotator INSTANCE;

    @NotNull
    public final <TRange extends Segment> String annotateWithTags(@NotNull String text2, @NotNull Iterable<? extends TRange> ranges, @NotNull Comparator<TRange> comparator2, @NotNull Function1<? super TRange, String> rangeTagNamePrinter) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull(ranges, (String)"ranges");
        Intrinsics.checkParameterIsNotNull(comparator2, (String)"comparator");
        Intrinsics.checkParameterIsNotNull(rangeTagNamePrinter, (String)"rangeTagNamePrinter");
        List sortedHighlighters = CollectionsKt.sortedWith(ranges, comparator2);
        TreeMap<Integer, Integer> offsetMap = new TreeMap<Integer, Integer>();
        StringBuilder result2 = new StringBuilder(text2);
        for (Segment h2 : sortedHighlighters) {
            String tag;
            if ((String)rangeTagNamePrinter.invoke((Object)h2) == null) {
                continue;
            }
            int start2 = this.calculateAbsoluteOffset(offsetMap, h2.getStartOffset(), true);
            this.updateOffset(offsetMap, h2.getStartOffset(), tag.length() + 2);
            result2.insert(start2, "<" + tag + ">");
            if (h2.getStartOffset() == h2.getEndOffset()) continue;
            int end = this.calculateAbsoluteOffset(offsetMap, h2.getEndOffset(), false);
            this.updateOffset(offsetMap, h2.getEndOffset(), tag.length() + 3);
            result2.insert(end, "</" + tag + ">");
        }
        String string2 = result2.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"result.toString()");
        return string2;
    }

    private final void updateOffset(@NotNull TreeMap<Integer, Integer> $receiver, int index, int value2) {
        Integer n2 = $receiver.get(index);
        if (n2 == null) {
            n2 = 0;
        }
        Integer current = n2;
        Map map2 = $receiver;
        Integer n3 = index;
        Integer n4 = current + value2;
        map2.put(n3, n4);
    }

    private final int calculateAbsoluteOffset(@NotNull TreeMap<Integer, Integer> $receiver, int currentOffset, boolean isStartTag) {
        int absoluteOffset = currentOffset;
        int currentOffset2 = isStartTag ? currentOffset : currentOffset - 1;
        Map map2 = $receiver;
        Iterator iterator2 = map2.entrySet().iterator();
        while (iterator2.hasNext()) {
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator2.next();
            int offset = ((Number)entry2.getKey()).intValue();
            entry2 = entry;
            int delta = ((Number)entry2.getValue()).intValue();
            if (offset > currentOffset2) break;
            absoluteOffset += delta;
        }
        return absoluteOffset;
    }

    private HighlighterTextAnnotator() {
        INSTANCE = this;
    }

    static {
        new HighlighterTextAnnotator();
    }
}

