/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.util;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.daemon.DocumentMarkupContributor;
import com.jetbrains.resharper.daemon.IRiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.components.HighlighterRegistrationHostImpl;
import com.jetbrains.resharper.daemon.components.RiderMarkupHost;
import com.jetbrains.resharper.daemon.util.HighlighterDumpData;
import com.jetbrains.resharper.daemon.util.HighlightersDumpUtilKt;
import com.jetbrains.resharper.daemon.util.HighlightersTestUtilKt;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.resharper.utils.collections.SortedOneToSortedListMap;
import com.jetbrains.rider.model.HighlighterList;
import com.jetbrains.rider.model.HighlighterModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u00000\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u001a\u0016\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\r*\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\u00a8\u0006\u0010"}, d2={"hasErrors", "", "Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;", "getHasErrors", "(Lcom/jetbrains/resharper/daemon/IRiderDocumentMarkupAdapter;)Z", "getBackendDumpSync", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "getFrontendDump", "getHighlightersBySeverities", "Lcom/jetbrains/resharper/utils/collections/SortedOneToSortedListMap;", "Lcom/intellij/lang/annotation/HighlightSeverity;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "rider"})
public final class HighlightersTestUtilKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getBackendDumpSync(@NotNull Project project2, @NotNull Document document) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        Object object = RiderMarkupHost.Companion.getMarkupContributor(project2, document);
        if (object == null || (object = ((DocumentMarkupContributor)object).getMarkupAdapter()) == null) {
            return "No Backend Markup Support";
        }
        Object markupAdapter = object;
        Object object2 = ExtensionsKt.syncFromBackend$default(markupAdapter.getDumpBackendMarkup(), -1, project2, null, 4, null);
        if (object2 == null) {
            Intrinsics.throwNpe();
        }
        List<HighlighterModel> models = ((HighlighterList)object2).getElements();
        String text2 = document.getText();
        HighlighterRegistrationHostImpl host = HighlighterRegistrationHostImpl.Companion.getInstance();
        Iterable iterable = $receiver$iv = (Iterable)models;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            HighlighterModel highlighterModel = (HighlighterModel)item$iv$iv;
            Collection collection = destination$iv$iv;
            HighlighterDumpData highlighterDumpData = new HighlighterDumpData(it.getStart(), it.getEnd(), host.getSettingsDemoTextTag(it.getRegistryKey()));
            collection.add(highlighterDumpData);
        }
        List highlighters = (List)destination$iv$iv;
        String string2 = text2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        return HighlightersDumpUtilKt.annotateTextWithHighlighterDumpData(string2, highlighters);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String getFrontendDump(@NotNull Project project2, @NotNull Document document) {
        void $receiver$iv$iv;
        Object[] $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        RangeHighlighter[] models = DocumentMarkupModel.forDocument(document, project2, true).getAllHighlighters();
        String text2 = document.getText();
        HighlighterRegistrationHostImpl host = HighlighterRegistrationHostImpl.Companion.getInstance();
        Object[] objectArray = $receiver$iv = (Object[])models;
        Collection destination$iv$iv = new ArrayList();
        void $receiver$iv$iv$iv = $receiver$iv$iv;
        for (int i2 = 0; i2 < ((void)$receiver$iv$iv$iv).length; ++i2) {
            HighlighterDumpData highlighterDumpData;
            HighlighterDumpData highlighterDumpData2;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $receiver$iv$iv$iv[i2];
            RangeHighlighter it = (RangeHighlighter)element$iv$iv;
            Integer n2 = HighlightersUtilKt.getTryGetRegistryKey(it);
            if (n2 == null) {
                highlighterDumpData2 = null;
            } else {
                int registryKey = n2;
                highlighterDumpData2 = new HighlighterDumpData(it.getStartOffset(), it.getEndOffset(), host.getSettingsDemoTextTag(registryKey));
            }
            if (highlighterDumpData2 == null) continue;
            HighlighterDumpData it$iv$iv = highlighterDumpData = highlighterDumpData2;
            destination$iv$iv.add(it$iv$iv);
        }
        List highlighters = (List)destination$iv$iv;
        String string2 = text2;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"text");
        return HighlightersDumpUtilKt.annotateTextWithHighlighterDumpData(string2, highlighters);
    }

    @NotNull
    public static final SortedOneToSortedListMap<HighlightSeverity, RangeHighlighter> getHighlightersBySeverities(@NotNull IRiderDocumentMarkupAdapter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        SortedOneToSortedListMap<HighlightSeverity, RangeHighlighter> map2 = new SortedOneToSortedListMap<HighlightSeverity, RangeHighlighter>(getHighlightersBySeverities.map.1.INSTANCE, getHighlightersBySeverities.map.2.INSTANCE);
        Iterator<HighlightSeverity> iterator2 = HighlightersUtilKt.getRiderDefaultSeverities().iterator();
        while (iterator2.hasNext()) {
            HighlightSeverity severity;
            HighlightSeverity highlightSeverity = severity = iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"severity");
            map2.putKey(highlightSeverity);
        }
        RangeHighlighter[] rangeHighlighterArray = $receiver.getAllHighlighters();
        for (int i2 = 0; i2 < rangeHighlighterArray.length; ++i2) {
            HighlightSeverity severity;
            RangeHighlighter h2 = rangeHighlighterArray[i2];
            if (HighlightersUtilKt.getSeverity(h2) == null) {
                continue;
            }
            map2.put(severity, h2);
        }
        return map2;
    }

    public static final boolean getHasErrors(@NotNull IRiderDocumentMarkupAdapter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        RangeHighlighter[] rangeHighlighterArray = $receiver.getAllHighlighters();
        for (int i2 = 0; i2 < rangeHighlighterArray.length; ++i2) {
            HighlightSeverity severity;
            RangeHighlighter h2 = rangeHighlighterArray[i2];
            if (HighlightersUtilKt.getSeverity(h2) == null) {
                continue;
            }
            if (!Intrinsics.areEqual((Object)severity, (Object)HighlightSeverity.ERROR)) continue;
            return true;
        }
        return false;
    }
}

