/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.daemon.util;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.jetbrains.resharper.daemon.RiderDocumentMarkupAdapter;
import com.jetbrains.resharper.daemon.util.HighlightersUtilKt;
import com.jetbrains.resharper.daemon.util.MarkupChangeKind;
import com.jetbrains.resharper.ideaInterop.SuggestionSeveritiesProvider;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.resharper.util.idea.DocumentUtilKt;
import com.jetbrains.resharper.util.idea.RangeUtilKt;
import com.jetbrains.rider.model.HighlighterModel;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import java.awt.Color;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%\u001a \u0010&\u001a\u00020'2\u0018\u0010(\u001a\u0014\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+\u0012\u0004\u0012\u00020,0)\u001a\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020+H\u0002\u001a\u0010\u0010-\u001a\u00020\u000b2\u0006\u0010.\u001a\u00020/H\u0002\u001a\u0016\u00100\u001a\u00020,2\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u000204\u001a\u0014\u00105\u001a\u0004\u0018\u000106*\u00020#2\u0006\u0010$\u001a\u00020%\u001a\n\u00107\u001a\u00020\u000b*\u00020\u0007\u001a\u0012\u00108\u001a\u000209*\u00020\u00072\u0006\u0010:\u001a\u00020/\u001a\n\u0010;\u001a\u00020<*\u00020/\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\"\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\"\u0017\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\"\u0017\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\"\u0015\u0010\u0012\u001a\u00020\u0013*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015\"\u0015\u0010\u0016\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\r\"\u0015\u0010\u0018\u001a\u00020\u000b*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\r\"\u0017\u0010\u001a\u001a\u0004\u0018\u00010\u0002*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\"\u0017\u0010\u001d\u001a\u0004\u0018\u00010\u0013*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006="}, d2={"RiderDefaultSeverities", "Ljava/util/ArrayList;", "Lcom/intellij/lang/annotation/HighlightSeverity;", "getRiderDefaultSeverities", "()Ljava/util/ArrayList;", "attributeKey", "Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getAttributeKey", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/openapi/editor/colors/TextAttributesKey;", "attributeKeyName", "", "getAttributeKeyName", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Ljava/lang/String;", "highlightInfoType", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "getHighlightInfoType", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/codeInsight/daemon/impl/HighlightInfoType;", "registryKey", "", "getRegistryKey", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)I", "riderAttributeKeyName", "getRiderAttributeKeyName", "riderHighlighterType", "getRiderHighlighterType", "severity", "getSeverity", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Lcom/intellij/lang/annotation/HighlightSeverity;", "tryGetRegistryKey", "getTryGetRegistryKey", "(Lcom/intellij/openapi/editor/markup/RangeHighlighter;)Ljava/lang/Integer;", "attributesFromSeverity", "Lcom/intellij/openapi/editor/markup/TextAttributes;", "info", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "colorsScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "createDocumentMarkupListener", "Lcom/intellij/openapi/editor/impl/event/MarkupModelListener;", "action", "Lkotlin/Function2;", "Lcom/jetbrains/resharper/daemon/util/MarkupChangeKind;", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "", "print", "highlighter", "Lcom/jetbrains/rider/model/HighlighterModel;", "vanishHighlightersByTyping", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "markupModel", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "getErrorStripeColor", "Ljava/awt/Color;", "prettyPrint", "standsFor", "", "highlighterModel", "toIdeaTargetArea", "Lcom/intellij/openapi/editor/markup/HighlighterTargetArea;", "rider"})
public final class HighlightersUtilKt {
    @NotNull
    private static final ArrayList<HighlightSeverity> RiderDefaultSeverities;

    @NotNull
    public static final MarkupModelListener createDocumentMarkupListener(@NotNull Function2<? super MarkupChangeKind, ? super RangeHighlighterEx, Unit> action2) {
        Intrinsics.checkParameterIsNotNull(action2, (String)"action");
        return new MarkupModelListener(action2){
            final /* synthetic */ Function2 $action;

            public void attributesChanged(@NotNull RangeHighlighterEx h2, boolean b2, boolean c2) {
                Intrinsics.checkParameterIsNotNull((Object)h2, (String)"h");
                this.$action.invoke((Object)((Object)MarkupChangeKind.Changed), (Object)h2);
            }

            public void afterAdded(@NotNull RangeHighlighterEx h2) {
                Intrinsics.checkParameterIsNotNull((Object)h2, (String)"h");
                this.$action.invoke((Object)((Object)MarkupChangeKind.Added), (Object)h2);
            }

            public void beforeRemoved(@NotNull RangeHighlighterEx h2) {
                Intrinsics.checkParameterIsNotNull((Object)h2, (String)"h");
                this.$action.invoke((Object)((Object)MarkupChangeKind.Removed), (Object)h2);
            }
            {
                this.$action = $captured_local_variable$0;
            }
        };
    }

    @NotNull
    public static final HighlighterTargetArea toIdeaTargetArea(@NotNull HighlighterModel $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return $receiver.isExactRange() ? HighlighterTargetArea.EXACT_RANGE : HighlighterTargetArea.LINES_IN_RANGE;
    }

    public static final boolean standsFor(@NotNull RangeHighlighter $receiver, @NotNull HighlighterModel highlighterModel) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)highlighterModel, (String)"highlighterModel");
        return Intrinsics.areEqual((Object)highlighterModel.getRegistryKey(), (Object)HighlightersUtilKt.getTryGetRegistryKey($receiver)) && $receiver.isValid() && highlighterModel.getLayer() == $receiver.getLayer();
    }

    public static final int getRegistryKey(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Integer n2 = HighlightersUtilKt.getTryGetRegistryKey($receiver);
        if (n2 == null) {
            throw (Throwable)new InvalidDataException("highlighter wasn't registered by Rider");
        }
        return n2;
    }

    @Nullable
    public static final Integer getTryGetRegistryKey(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return RiderDocumentMarkupAdapter.Companion.getRegistryKey($receiver);
    }

    @NotNull
    public static final String getRiderHighlighterType(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return HighlightersUtilKt.getRiderAttributeKeyName($receiver);
    }

    @NotNull
    public static final String getRiderAttributeKeyName(@NotNull RangeHighlighter $receiver) {
        Object object;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object2 = $receiver.getErrorStripeTooltip();
        if (!(object2 instanceof HighlightInfo)) {
            object2 = null;
        }
        if ((object = (HighlightInfo)object2) == null || (object = ((HighlightInfo)object).type) == null || (object = object.getAttributesKey()) == null || (object = object.getExternalName()) == null) {
            object = $receiver.toString();
        }
        return object;
    }

    @Nullable
    public static final String getAttributeKeyName(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        TextAttributesKey textAttributesKey = HighlightersUtilKt.getAttributeKey($receiver);
        return textAttributesKey != null ? textAttributesKey.getExternalName() : null;
    }

    @Nullable
    public static final TextAttributesKey getAttributeKey(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HighlightInfoType highlightInfoType = HighlightersUtilKt.getHighlightInfoType($receiver);
        return highlightInfoType != null ? highlightInfoType.getAttributesKey() : null;
    }

    @Nullable
    public static final HighlightInfoType getHighlightInfoType(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Object object = $receiver.getErrorStripeTooltip();
        if (!(object instanceof HighlightInfo)) {
            object = null;
        }
        HighlightInfo highlightInfo = (HighlightInfo)object;
        return highlightInfo != null ? highlightInfo.type : null;
    }

    @Nullable
    public static final HighlightSeverity getSeverity(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        HighlightInfoType highlightInfoType = HighlightersUtilKt.getHighlightInfoType($receiver);
        if (!(highlightInfoType instanceof HighlightInfoType.HighlightInfoTypeImpl)) {
            highlightInfoType = null;
        }
        HighlightInfoType.HighlightInfoTypeImpl highlightInfoTypeImpl = (HighlightInfoType.HighlightInfoTypeImpl)highlightInfoType;
        return highlightInfoTypeImpl != null ? highlightInfoTypeImpl.getSeverity(null) : null;
    }

    @NotNull
    public static final String prettyPrint(@NotNull RangeHighlighter $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        return "{" + "\"" + HighlightersUtilKt.getAttributeKeyName($receiver) + "\"" + "; (" + $receiver.getStartOffset() + ", " + $receiver.getEndOffset() + ")}";
    }

    private static final String print(HighlighterModel highlighter2) {
        return "(" + highlighter2.getStart() + "," + highlighter2.getEnd() + "), layer= " + highlighter2.getRegistryKey();
    }

    private static final String print(RangeHighlighterEx highlighter2) {
        return "(" + highlighter2.getStartOffset() + ", " + highlighter2.getEndOffset() + "), " + HighlightersUtilKt.getRiderHighlighterType(highlighter2);
    }

    @NotNull
    public static final ArrayList<HighlightSeverity> getRiderDefaultSeverities() {
        return RiderDefaultSeverities;
    }

    @Nullable
    public static final Color getErrorStripeColor(@NotNull HighlightInfo $receiver, @NotNull EditorColorsScheme colorsScheme) {
        Color colorFromKey;
        Color colorFromAtt;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)colorsScheme, (String)"colorsScheme");
        TextAttributes textAttributes = $receiver.forcedTextAttributes;
        Color color = colorFromAtt = textAttributes != null ? textAttributes.getErrorStripeColor() : null;
        if (colorFromAtt != null) {
            return colorFromAtt;
        }
        TextAttributes textAttributes2 = colorsScheme.getAttributes($receiver.forcedTextAttributesKey);
        Color color2 = colorFromKey = textAttributes2 != null ? textAttributes2.getErrorStripeColor() : null;
        if (colorFromKey != null) {
            return colorFromKey;
        }
        TextAttributes textAttributes3 = HighlightersUtilKt.attributesFromSeverity($receiver, colorsScheme);
        return textAttributes3 != null ? textAttributes3.getErrorStripeColor() : null;
    }

    @Nullable
    public static final TextAttributes attributesFromSeverity(@NotNull HighlightInfo info, @NotNull EditorColorsScheme colorsScheme) {
        Intrinsics.checkParameterIsNotNull((Object)info, (String)"info");
        Intrinsics.checkParameterIsNotNull((Object)colorsScheme, (String)"colorsScheme");
        HighlightSeverity highlightSeverity = info.getSeverity();
        TextAttributesKey key = Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.ERROR) ? CodeInsightColors.ERRORS_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WARNING) ? CodeInsightColors.WARNINGS_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)SuggestionSeveritiesProvider.Companion.getSUGGESTION_SEVERITY()) ? SuggestionSeveritiesProvider.Companion.getSUGGESTION() : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.WEAK_WARNING) ? CodeInsightColors.WEAK_WARNING_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.INFORMATION) ? CodeInsightColors.INFORMATION_ATTRIBUTES : (Intrinsics.areEqual((Object)highlightSeverity, (Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING) ? CodeInsightColors.GENERIC_SERVER_ERROR_OR_WARNING : null)))));
        return colorsScheme.getAttributes(key);
    }

    public static final void vanishHighlightersByTyping(@NotNull Lifetime lifetime, @NotNull MarkupModelEx markupModel) {
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        Intrinsics.checkParameterIsNotNull((Object)markupModel, (String)"markupModel");
        markupModel.getDocument().addDocumentListener(new DocumentListener(lifetime, markupModel){
            final /* synthetic */ Lifetime $lifetime;
            final /* synthetic */ MarkupModelEx $markupModel;

            /*
             * WARNING - void declaration
             */
            public void documentChanged(@NotNull DocumentEvent event) {
                void end;
                void start2;
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                if (this.$lifetime.isTerminated()) {
                    return;
                }
                TextRange textRange = DocumentUtilKt.underlyingIdentifierRange(event);
                int n2 = RangeUtilKt.component1(textRange);
                int n3 = RangeUtilKt.component2(textRange);
                textRange = null;
                this.$markupModel.processRangeHighlightersOverlappingWith((int)start2, (int)end, (Processor<? super RangeHighlighterEx>)((Processor)new Processor<RangeHighlighterEx>(this){
                    final /* synthetic */ vanishHighlightersByTyping.1 this$0;

                    public final boolean invoke(RangeHighlighterEx it) {
                        TextAttributes textAttributes = it.getTextAttributes();
                        if (textAttributes == null) {
                            return true;
                        }
                        TextAttributes textAttributes2 = textAttributes;
                        if (vanishHighlightersByTyping.1.access$isSyntaxHighlighter(this.this$0, HighlightersUtilKt.getAttributeKey(it))) {
                            return true;
                        }
                        if (Intrinsics.areEqual((Object)textAttributes2, (Object)TextAttributes.ERASE_MARKER)) {
                            return true;
                        }
                        it.setTextAttributes(TextAttributes.ERASE_MARKER);
                        LifetimeExKt.plusAssign(this.this$0.$lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(it, textAttributes2){
                            final /* synthetic */ RangeHighlighterEx $it;
                            final /* synthetic */ TextAttributes $textAttributes;

                            public final void invoke() {
                                this.$it.setTextAttributes(this.$textAttributes);
                            }
                            {
                                this.$it = rangeHighlighterEx;
                                this.$textAttributes = textAttributes;
                                super(0);
                            }
                        }));
                        return true;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }

            private final boolean isSyntaxHighlighter(TextAttributesKey key) {
                for (TextAttributesKey attributeKey = key; attributeKey != null; attributeKey = attributeKey.getFallbackAttributeKey()) {
                    if (Intrinsics.areEqual((Object)attributeKey, (Object)DefaultLanguageHighlighterColors.STRING)) {
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)attributeKey, (Object)DefaultLanguageHighlighterColors.LINE_COMMENT)) {
                        return true;
                    }
                    if (Intrinsics.areEqual((Object)attributeKey, (Object)DefaultLanguageHighlighterColors.DOC_COMMENT)) {
                        return true;
                    }
                    if (!Intrinsics.areEqual((Object)attributeKey, (Object)DefaultLanguageHighlighterColors.NUMBER)) continue;
                    return true;
                }
                return false;
            }

            public void beforeDocumentChange(@Nullable DocumentEvent event) {
            }
            {
                this.$lifetime = $captured_local_variable$0;
                this.$markupModel = $captured_local_variable$1;
            }

            public static final /* synthetic */ boolean access$isSyntaxHighlighter(vanishHighlightersByTyping.1 $this, @Nullable TextAttributesKey key) {
                return $this.isSyntaxHighlighter(key);
            }
        }, DisposableExKt.toDisposable$default(lifetime, null, 1, null));
    }

    static {
        Object[] objectArray = new HighlightSeverity[4];
        HighlightSeverity highlightSeverity = HighlightSeverity.ERROR;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity, (String)"HighlightSeverity.ERROR");
        objectArray[0] = highlightSeverity;
        HighlightSeverity highlightSeverity2 = HighlightSeverity.WARNING;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity2, (String)"HighlightSeverity.WARNING");
        objectArray[1] = highlightSeverity2;
        objectArray[2] = SuggestionSeveritiesProvider.Companion.getSUGGESTION_SEVERITY();
        HighlightSeverity highlightSeverity3 = HighlightSeverity.INFORMATION;
        Intrinsics.checkExpressionValueIsNotNull((Object)highlightSeverity3, (String)"HighlightSeverity.INFORMATION");
        objectArray[3] = highlightSeverity3;
        RiderDefaultSeverities = CollectionsKt.arrayListOf((Object[])objectArray);
    }
}

