/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import java.io.File;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a\u0018\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u0016\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u0004\u0018\u00010\u00062\u0006\u0010\u0002\u001a\u00020\u0003\u00a8\u0006\u0007"}, d2={"findFileConsiderProjectMoved", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "originPath", "", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "rider"})
public final class DebuggerFileUtilKt {
    @Nullable
    public static final VirtualFile findFileConsiderProjectMoved(@NotNull Project project2, @NotNull String originPath) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)originPath, (String)"originPath");
        File positionFile = new File(originPath);
        return (VirtualFile)ApplicationKt.getApplication().runReadAction((Computable)new Computable<VirtualFile>(positionFile, project2){
            final /* synthetic */ File $positionFile;
            final /* synthetic */ Project $project;

            @Nullable
            public final VirtualFile compute() {
                VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)this.$positionFile, (boolean)true);
                if (virtualFile != null) {
                    return virtualFile;
                }
                Collection<VirtualFile> filesWithSameName = FilenameIndex.getVirtualFilesByName(this.$project, this.$positionFile.getName(), GlobalSearchScope.allScope((Project)this.$project));
                for (VirtualFile currentFile : filesWithSameName) {
                    String relativePath;
                    VirtualFile baseDir;
                    if (VfsUtil.getRelativePath((VirtualFile)currentFile, (VirtualFile)(baseDir = this.$project.getBaseDir())) == null) {
                        continue;
                    }
                    String string2 = relativePath;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"relativePath");
                    if (!FilesKt.endsWith((File)this.$positionFile, (String)string2)) continue;
                    return currentFile;
                }
                return null;
            }
            {
                this.$positionFile = file2;
                this.$project = project2;
            }
        });
    }

    @Nullable
    public static final VirtualFile findFileConsiderProjectMoved(@Nullable SourcePositionProxy $receiver, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        if ($receiver == null) {
            return null;
        }
        return DebuggerFileUtilKt.findFileConsiderProjectMoved(project2, $receiver.getFilename());
    }
}

