/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.RunContentBuilder;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.ObservableConsoleView;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.content.Content;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.SuspendPolicy;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.ui.XDebugTabLayouter;
import com.jetbrains.resharper.debugger.DotNetDebugProcess;
import com.jetbrains.resharper.debugger.DotNetDebugProcess$WhenMappings;
import com.jetbrains.resharper.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.resharper.debugger.DotNetSuspendContext;
import com.jetbrains.resharper.debugger.breakpoint.DotNetAllExceptionBreakpointHandler;
import com.jetbrains.resharper.debugger.breakpoint.DotNetBreakpointProperties;
import com.jetbrains.resharper.debugger.breakpoint.DotNetExceptionBreakpointHandler;
import com.jetbrains.resharper.debugger.breakpoint.DotNetExceptionBreakpointProperties;
import com.jetbrains.resharper.debugger.breakpoint.DotNetLineBreakpointHandler;
import com.jetbrains.resharper.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.resharper.editors.ITextControlHost;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.base.IPrintable;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.model.TextControlTuple;
import com.jetbrains.rider.model.debuggerWorker.BreakpointHitCountModeModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointId;
import com.jetbrains.rider.model.debuggerWorker.BreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.BreakpointStatus;
import com.jetbrains.rider.model.debuggerWorker.DebuggerSessionInfo;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.model.debuggerWorker.ExceptionBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.ExecutionCommandKind;
import com.jetbrains.rider.model.debuggerWorker.ExecutionCommandProxy;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.LineBreakpointModel;
import com.jetbrains.rider.model.debuggerWorker.OutputArgs;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.IProperty;
import com.jetbrains.rider.util.reactive.ISource;
import com.jetbrains.rider.util.reactive.Property;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import com.jetbrains.rider.util.wrappers.Session;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u00d0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001:\u0001WBE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010*\u001a\u00020+H\u0002J\u0018\u0010,\u001a\u00020+2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J\u0006\u00101\u001a\u00020\u000fJ\u0014\u00102\u001a\u0002032\n\u00104\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0002J\b\u00105\u001a\u00020\tH\u0016J\b\u00106\u001a\u000207H\u0016J\n\u00108\u001a\u0004\u0018\u00010\u0007H\u0014J\u0006\u00109\u001a\u00020+J\u0019\u0010:\u001a\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014H\u0016\u00a2\u0006\u0002\u0010;J\n\u0010<\u001a\u0004\u0018\u00010=H\u0016J\b\u0010>\u001a\u00020?H\u0016J\u0014\u0010@\u001a\u00020+2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0016J\u0014\u0010C\u001a\u00020+2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020E0DJ\u0012\u0010F\u001a\u00020+2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u001a\u0010I\u001a\u00020+2\u0006\u0010J\u001a\u00020K2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\b\u0010L\u001a\u00020+H\u0016J\u000e\u0010M\u001a\u00020+2\u0006\u0010J\u001a\u00020KJ\b\u0010N\u001a\u00020+H\u0002J\b\u0010O\u001a\u00020+H\u0016J\u0012\u0010P\u001a\u00020+2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0012\u0010Q\u001a\u00020+2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\u0012\u0010R\u001a\u00020+2\b\u0010G\u001a\u0004\u0018\u00010HH\u0016J\b\u0010S\u001a\u00020+H\u0016J\u0016\u0010T\u001a\u00020$2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020E0DH\u0002J\u0014\u0010U\u001a\u00020+2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u0016J\u0014\u0010V\u001a\u00020+2\f\u0010A\u001a\b\u0012\u0004\u0012\u00020E0DRV\u0010\u0013\u001aH\u0012D\u0012B\u0012>\b\u0001\u0012:\u00126\b\u0001\u00122\u0012\u0012\b\u0001\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0017 \u0018*\u0018\u0012\u0012\b\u0001\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00170\u0017\u0018\u00010\u00170\u00170\u00160\u00150\u0014X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0016\u0012\u0004\u0012\u00020\u001c0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010'\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006X"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetDebugProcess;", "Lcom/intellij/xdebugger/XDebugProcess;", "sessionLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "procHandler", "Lcom/intellij/execution/process/ProcessHandler;", "console", "Lcom/intellij/execution/ui/ExecutionConsole;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "sessionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "fireInitializedManually", "", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/jetbrains/rider/util/lifetime/Lifetime;Lcom/intellij/xdebugger/XDebugSession;Lcom/intellij/execution/process/ProcessHandler;Lcom/intellij/execution/ui/ExecutionConsole;Lcom/jetbrains/rider/framework/IProtocol;Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;ZLcom/jetbrains/resharper/icons/IconHost;)V", "breakpointHandlers", "", "Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "Lcom/intellij/xdebugger/breakpoints/XBreakpoint;", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointProperties;", "kotlin.jvm.PlatformType", "[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "breakpointMap", "Lcom/intellij/util/containers/BidirectionalMap;", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointId;", "debuggerOutputConsole", "Lcom/intellij/execution/impl/ConsoleViewImpl;", "editorsProvider", "Lcom/jetbrains/resharper/debugger/DotNetDebuggerEditorsProvider;", "manualPauseRequested", "processId", "Lcom/jetbrains/rider/util/reactive/Property;", "", "getProcessId", "()Lcom/jetbrains/rider/util/reactive/Property;", "setNextStatementIsEnabled", "state", "Lcom/jetbrains/resharper/debugger/DotNetDebugProcess$State;", "activateSession", "", "breakpointStatusChanged", "breakPointModel", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointModel;", "status", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointStatus;", "canSetNextStatement", "convertHitCountModeToModel", "Lcom/jetbrains/rider/model/debuggerWorker/BreakpointHitCountModeModel;", "properties", "createConsole", "createTabLayouter", "Lcom/intellij/xdebugger/ui/XDebugTabLayouter;", "doGetProcessHandler", "fireInitialized", "getBreakpointHandlers", "()[Lcom/intellij/xdebugger/breakpoints/XBreakpointHandler;", "getCurrentStateMessage", "", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "registerExceptionBreakpoint", "breakpoint", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetExceptionBreakpointProperties;", "registerLineBreakpoint", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointProperties;", "resume", "context", "Lcom/intellij/xdebugger/frame/XSuspendContext;", "runToPosition", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "sessionInitialized", "setNextStatement", "setUpOutput", "startPausing", "startStepInto", "startStepOut", "startStepOver", "stop", "tryGetColumnByOffset", "unregisterExceptionBreakpoint", "unregisterLineBreakpoint", "State", "rider"})
public final class DotNetDebugProcess
extends XDebugProcess {
    private final DotNetDebuggerEditorsProvider editorsProvider;
    private final XBreakpointHandler<? extends XBreakpoint<? extends DotNetBreakpointProperties<? extends DotNetBreakpointProperties<? extends DotNetBreakpointProperties<?>>>>>[] breakpointHandlers;
    private final BidirectionalMap<XBreakpoint<?>, BreakpointId> breakpointMap;
    private boolean manualPauseRequested;
    private ConsoleViewImpl debuggerOutputConsole;
    private State state;
    private boolean setNextStatementIsEnabled;
    @NotNull
    private final Property<Integer> processId;
    private final Lifetime sessionLifetime;
    private final ProcessHandler procHandler;
    private final ExecutionConsole console;
    private final IProtocol protocol;
    private final DotNetDebuggerSessionModel sessionProxy;
    private final boolean fireInitializedManually;

    @NotNull
    public final Property<Integer> getProcessId() {
        return this.processId;
    }

    private final void activateSession() {
        this.sessionProxy.getTargetReady().advise(this.sessionLifetime, (Function1<DebuggerSessionInfo, Unit>)((Function1)new Function1<DebuggerSessionInfo, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull DebuggerSessionInfo $processId1_canSetNextStatement) {
                Intrinsics.checkParameterIsNotNull((Object)$processId1_canSetNextStatement, (String)"<name for destructuring parameter 0>");
                int processId1 = $processId1_canSetNextStatement.component1();
                boolean canSetNextStatement = $processId1_canSetNextStatement.component2();
                DotNetDebugProcess.access$setSetNextStatementIsEnabled$p(this.this$0, canSetNextStatement);
                PropertyExKt.set(this.this$0.getProcessId(), processId1);
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
        this.setUpOutput();
        this.sessionProxy.getShowNotification().advise(this.sessionLifetime, (Function1<OutputArgs, Unit>)((Function1)new Function1<OutputArgs, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull OutputArgs it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XDebugSessionImpl.NOTIFICATION_GROUP.createNotification(it.getOutput(), it.isError() ? NotificationType.ERROR : NotificationType.WARNING).notify(this.this$0.getSession().getProject());
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
        this.sessionProxy.getExecutionContext().view(this.sessionLifetime, (Function2<Lifetime, ExecutionContextProxy, Unit>)((Function2)new Function2<Lifetime, ExecutionContextProxy, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull Lifetime lf, @Nullable ExecutionContextProxy contextProxy) {
                IProperty<T> iProperty;
                Intrinsics.checkParameterIsNotNull((Object)lf, (String)"lf");
                if (contextProxy == null) {
                    this.this$0.getSession().sessionResumed();
                    return;
                }
                XDebugSession xDebugSession = this.this$0.getSession();
                Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"session");
                DotNetSuspendContext dotNetSuspendContext = new DotNetSuspendContext(xDebugSession, contextProxy, lf);
                Project project2 = this.this$0.getSession().getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"session.project");
                ITextControlHost iTextControlHost = TextControlHost.Companion.getInstance(project2);
                if (!(iTextControlHost instanceof TextControlHost)) {
                    iTextControlHost = null;
                }
                if ((iProperty = (TextControlHost)iTextControlHost) != null && (iProperty = ((TextControlHost)((Object)iProperty)).getLastFocusedTextControl()) != null && (iProperty = ((Session)((Object)iProperty)).getProperty()) != null) {
                    iProperty.advise(lf, (Function1)new Function1<TextControlTuple, Unit>(this, dotNetSuspendContext){
                        final /* synthetic */ activateSession.3 this$0;
                        final /* synthetic */ DotNetSuspendContext $dotNetSuspendContext;

                        public final void invoke(@Nullable TextControlTuple textControlTuple) {
                            Object object = textControlTuple;
                            if (object == null || (object = ((TextControlTuple)object).getId()) == null || (object = ((TextControlId)object).getDocumentId()) == null || (object = ((EditableEntityId)object).getFilePath()) == null) {
                                return;
                            }
                            Object location = object;
                            if (!this.$dotNetSuspendContext.checkFileMatchesDebugInfo((String)location)) {
                                XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("The source file " + (String)location + " may have changed since building the module.", NotificationType.WARNING).notify(this.this$0.this$0.getSession().getProject());
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$dotNetSuspendContext = dotNetSuspendContext;
                            super(1);
                        }
                    });
                }
                if (contextProxy.getBreakpoint() != null) {
                    XBreakpoint xBreakpoint;
                    List list2 = DotNetDebugProcess.access$getBreakpointMap$p(this.this$0).getKeysByValue((Object)contextProxy.getBreakpoint());
                    Object object = xBreakpoint = list2 != null ? (XBreakpoint)CollectionsKt.firstOrNull((List)list2) : null;
                    if (xBreakpoint != null) {
                        this.this$0.getSession().breakpointReached(xBreakpoint, null, (XSuspendContext)dotNetSuspendContext);
                        return;
                    }
                }
                XDebugSession xDebugSession2 = this.this$0.getSession();
                if (xDebugSession2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
                }
                ((XDebugSessionImpl)xDebugSession2).positionReached(dotNetSuspendContext, !DotNetDebugProcess.access$getManualPauseRequested$p(this.this$0));
                DotNetDebugProcess.access$setManualPauseRequested$p(this.this$0, false);
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(2);
            }
        }));
    }

    private final void setUpOutput() {
        ConsoleView consoleView = TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject()).getConsole();
        if (consoleView == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.execution.impl.ConsoleViewImpl");
        }
        this.debuggerOutputConsole = (ConsoleViewImpl)consoleView;
        this.sessionProxy.getTargetReady().advise(this.sessionLifetime, (Function1<DebuggerSessionInfo, Unit>)((Function1)new Function1<DebuggerSessionInfo, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull DebuggerSessionInfo it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DotNetDebugProcess.access$setState$p(this.this$0, State.Ready);
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
        this.sessionProxy.getTargetOutput().advise(this.sessionLifetime, (Function1<OutputArgs, Unit>)((Function1)new Function1<OutputArgs, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull OutputArgs it) {
                block1: {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    ExecutionConsole executionConsole = DotNetDebugProcess.access$getConsole$p(this.this$0);
                    if (!(executionConsole instanceof ConsoleView)) {
                        executionConsole = null;
                    }
                    ConsoleView consoleView = (ConsoleView)executionConsole;
                    if (consoleView == null) break block1;
                    consoleView.print(it.getOutput(), it.isError() ? ConsoleViewContentType.ERROR_OUTPUT : ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
        this.sessionProxy.getTargetDebug().advise(this.sessionLifetime, (Function1<OutputArgs, Unit>)((Function1)new Function1<OutputArgs, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull OutputArgs it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0).print(it.getOutput(), ConsoleViewContentType.NORMAL_OUTPUT);
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
        this.sessionProxy.getDebuggerOutput().advise(this.sessionLifetime, (Function1<OutputArgs, Unit>)((Function1)new Function1<OutputArgs, Unit>(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public final void invoke(@NotNull OutputArgs it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0).print(it.getOutput(), ConsoleViewContentType.SYSTEM_OUTPUT);
            }
            {
                this.this$0 = dotNetDebugProcess;
                super(1);
            }
        }));
    }

    @Nullable
    public String getCurrentStateMessage() {
        String string2;
        switch (DotNetDebugProcess$WhenMappings.$EnumSwitchMapping$0[this.state.ordinal()]) {
            case 1: {
                string2 = "Waiting for target to get ready";
                break;
            }
            case 2: {
                string2 = "Target ready";
                break;
            }
            case 3: {
                string2 = "Disconnected";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string2;
    }

    public final void registerExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        IPrintable iPrintable;
        DotNetExceptionBreakpointProperties properties;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next());
        DotNetExceptionBreakpointProperties dotNetExceptionBreakpointProperties = properties = (DotNetExceptionBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dotNetExceptionBreakpointProperties), (String)"properties");
        BreakpointHitCountModeModel hitCountMode = this.convertHitCountModeToModel(dotNetExceptionBreakpointProperties);
        Map map2 = this.sessionProxy.getBreakpoints();
        XExpression xExpression = breakpoint.getConditionExpression();
        XExpression xExpression2 = breakpoint.getLogExpressionObject();
        ExceptionBreakpointModel $receiver = iPrintable = new ExceptionBreakpointModel(properties.getException(), properties.getJustMyCode(), breakpointId, xExpression != null ? xExpression.getExpression() : null, Intrinsics.areEqual((Object)breakpoint.getSuspendPolicy(), (Object)SuspendPolicy.NONE) ^ true, xExpression2 != null ? xExpression2.getExpression() : null, breakpoint.isLogMessage(), properties.getHitCount(), hitCountMode);
        $receiver.getStatusChanged().advise(Lifetime.Companion.getEternal(), (Function1<BreakpointStatus, Unit>)((Function1)new Function1<BreakpointStatus, Unit>($receiver, this){
            final /* synthetic */ ExceptionBreakpointModel receiver$0;
            final /* synthetic */ DotNetDebugProcess this$0;
            {
                this.receiver$0 = exceptionBreakpointModel;
                this.this$0 = dotNetDebugProcess;
                super(1);
            }

            public final void invoke(BreakpointStatus it) {
                DotNetDebugProcess.access$breakpointStatusChanged(this.this$0, this.receiver$0, it);
            }
        }));
        map2.put(breakpointId, iPrintable);
        map2 = (Map)this.breakpointMap;
        iPrintable = breakpointId;
        map2.put(breakpoint, iPrintable);
    }

    private final BreakpointHitCountModeModel convertHitCountModeToModel(DotNetBreakpointProperties<?> properties) {
        BreakpointHitCountModeModel breakpointHitCountModeModel;
        if (!properties.getHitCountFilterEnabled()) {
            return BreakpointHitCountModeModel.None;
        }
        switch (DotNetDebugProcess$WhenMappings.$EnumSwitchMapping$1[properties.getHitCountMode().ordinal()]) {
            case 1: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.LessThan;
                break;
            }
            case 2: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.LessThanOrEqualTo;
                break;
            }
            case 3: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.EqualTo;
                break;
            }
            case 4: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.GreaterThan;
                break;
            }
            case 5: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.GreaterThanOrEqualTo;
                break;
            }
            case 6: {
                breakpointHitCountModeModel = BreakpointHitCountModeModel.MultipleOf;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return breakpointHitCountModeModel;
    }

    public final void registerLineBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        IPrintable iPrintable;
        DotNetLineBreakpointProperties properties;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        int column = this.tryGetColumnByOffset(breakpoint);
        BreakpointId breakpointId = new BreakpointId(this.protocol.getIdentity().next());
        DotNetLineBreakpointProperties dotNetLineBreakpointProperties = properties = (DotNetLineBreakpointProperties)breakpoint.getProperties();
        Intrinsics.checkExpressionValueIsNotNull((Object)((Object)dotNetLineBreakpointProperties), (String)"properties");
        BreakpointHitCountModeModel hitCountMode = this.convertHitCountModeToModel(dotNetLineBreakpointProperties);
        Map map2 = this.sessionProxy.getBreakpoints();
        String string2 = breakpoint.getPresentableFilePath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"breakpoint.presentableFilePath");
        XExpression xExpression = breakpoint.getConditionExpression();
        XExpression xExpression2 = breakpoint.getLogExpressionObject();
        LineBreakpointModel $receiver = iPrintable = new LineBreakpointModel(string2, breakpoint.getLine(), column, breakpointId, xExpression != null ? xExpression.getExpression() : null, Intrinsics.areEqual((Object)breakpoint.getSuspendPolicy(), (Object)SuspendPolicy.NONE) ^ true, xExpression2 != null ? xExpression2.getExpression() : null, breakpoint.isLogMessage(), properties.getHitCount(), hitCountMode);
        $receiver.getStatusChanged().advise(Lifetime.Companion.getEternal(), (Function1<BreakpointStatus, Unit>)((Function1)new Function1<BreakpointStatus, Unit>($receiver, this){
            final /* synthetic */ LineBreakpointModel receiver$0;
            final /* synthetic */ DotNetDebugProcess this$0;
            {
                this.receiver$0 = lineBreakpointModel;
                this.this$0 = dotNetDebugProcess;
                super(1);
            }

            public final void invoke(BreakpointStatus it) {
                DotNetDebugProcess.access$breakpointStatusChanged(this.this$0, this.receiver$0, it);
            }
        }));
        map2.put(breakpointId, iPrintable);
        map2 = (Map)this.breakpointMap;
        iPrintable = breakpointId;
        map2.put(breakpoint, iPrintable);
    }

    private final int tryGetColumnByOffset(XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return 0;
        }
        XSourcePosition sourcePosition = xSourcePosition;
        Document document = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document == null) {
            return 0;
        }
        Document document2 = document;
        TextRange textRange = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getTextRange();
        if (Intrinsics.areEqual((Object)textRange, (Object)TextRange.EMPTY_RANGE)) {
            return 0;
        }
        int lineStartOffset = document2.getLineStartOffset(breakpoint.getLine());
        if (textRange.getStartOffset() < lineStartOffset) {
            return 0;
        }
        return textRange.getStartOffset() - lineStartOffset;
    }

    private final void breakpointStatusChanged(BreakpointModel breakPointModel, BreakpointStatus status) {
        if (breakPointModel instanceof LineBreakpointModel) {
            Icon icon;
            XDebugSession session2 = this.getSession();
            List list2 = this.breakpointMap.getKeysByValue((Object)breakPointModel.getId());
            if (list2 == null || (list2 = (XBreakpoint)CollectionsKt.firstOrNull((List)list2)) == null) {
                return;
            }
            List breakpoint = list2;
            switch (DotNetDebugProcess$WhenMappings.$EnumSwitchMapping$2[status.getStatus().ordinal()]) {
                case 1: {
                    icon = AllIcons.Debugger.Db_verified_breakpoint;
                    break;
                }
                case 2: {
                    icon = AllIcons.Debugger.Db_set_breakpoint;
                    break;
                }
                default: {
                    icon = AllIcons.Debugger.Db_invalid_breakpoint;
                }
            }
            Icon icon2 = icon;
            String message2 = status.getMessage();
            List list3 = breakpoint;
            if (list3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type com.intellij.xdebugger.breakpoints.XLineBreakpoint<out com.intellij.xdebugger.breakpoints.XBreakpointProperties<(raw) kotlin.Any!>!>");
            }
            XLineBreakpoint lineBreakpoint = (XLineBreakpoint)list3;
            session2.updateBreakpointPresentation(lineBreakpoint, icon2, message2);
        }
    }

    public final void unregisterLineBreakpoint(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        BreakpointId breakpointId = (BreakpointId)this.breakpointMap.get(breakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId id = breakpointId;
        this.sessionProxy.getBreakpoints().remove(id);
        this.breakpointMap.remove(breakpoint);
    }

    public final void unregisterExceptionBreakpoint(@NotNull XBreakpoint<DotNetExceptionBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        BreakpointId breakpointId = (BreakpointId)this.breakpointMap.get(breakpoint);
        if (breakpointId == null) {
            return;
        }
        BreakpointId id = breakpointId;
        this.sessionProxy.getBreakpoints().remove(id);
        this.breakpointMap.remove(breakpoint);
    }

    @NotNull
    public XDebugTabLayouter createTabLayouter() {
        return new XDebugTabLayouter(this){
            final /* synthetic */ DotNetDebugProcess this$0;

            public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
                Intrinsics.checkParameterIsNotNull((Object)ui, (String)"ui");
                Content debuggerOutputConsoleContent = ui.createContent("DebuggerOutput", DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0).getComponent(), "Debug Output", AllIcons.Debugger.Console_log, DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0).getPreferredFocusableComponent());
                debuggerOutputConsoleContent.setCloseable(false);
                RunContentBuilder.addAdditionalConsoleEditorActions((ExecutionConsole)DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0), debuggerOutputConsoleContent);
                ui.addContent(debuggerOutputConsoleContent);
                DotNetDebugProcess.access$getDebuggerOutputConsole$p(this.this$0).addChangeListener(new ObservableConsoleView.ChangeListener(debuggerOutputConsoleContent){
                    final /* synthetic */ Content $debuggerOutputConsoleContent;

                    public final void contentAdded(Collection<ConsoleViewContentType> it) {
                        if (it.contains(ConsoleViewContentType.NORMAL_OUTPUT) || it.contains(ConsoleViewContentType.ERROR_OUTPUT)) {
                            this.$debuggerOutputConsoleContent.fireAlert();
                        }
                    }
                    {
                        this.$debuggerOutputConsoleContent = content2;
                    }
                }, (Disposable)debuggerOutputConsoleContent);
            }
            {
                this.this$0 = $outer;
            }
        };
    }

    public void sessionInitialized() {
        if (!this.fireInitializedManually) {
            this.fireInitialized();
        }
    }

    public final void fireInitialized() {
        this.sessionProxy.getInitialized().fire();
    }

    @NotNull
    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return this.breakpointHandlers;
    }

    @NotNull
    public XDebuggerEditorsProvider getEditorsProvider() {
        return this.editorsProvider;
    }

    public void startStepOver(@Nullable XSuspendContext context2) {
        this.manualPauseRequested = true;
        this.sessionProxy.getCommand().fire(new ExecutionCommandProxy(ExecutionCommandKind.StepOver, null));
    }

    public void startStepInto(@Nullable XSuspendContext context2) {
        this.manualPauseRequested = true;
        this.sessionProxy.getCommand().fire(new ExecutionCommandProxy(ExecutionCommandKind.StepInto, null));
    }

    public void startStepOut(@Nullable XSuspendContext context2) {
        this.manualPauseRequested = true;
        this.sessionProxy.getCommand().fire(new ExecutionCommandProxy(ExecutionCommandKind.StepOut, null));
    }

    public void resume(@Nullable XSuspendContext context2) {
        this.sessionProxy.getCommand().fire(new ExecutionCommandProxy(ExecutionCommandKind.Resume, null));
    }

    public void stop() {
    }

    public void startPausing() {
        this.sessionProxy.getCommand().fire(new ExecutionCommandProxy(ExecutionCommandKind.Pause, null));
    }

    public void runToPosition(@NotNull XSourcePosition position, @Nullable XSuspendContext context2) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.manualPauseRequested = true;
        ISource<ExecutionCommandProxy> iSource = this.sessionProxy.getCommand();
        String string2 = position.getFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"position.file.path");
        iSource.fire(new ExecutionCommandProxy(ExecutionCommandKind.RunToCursor, new SourcePositionProxy(string2, position.getLine(), 0, position.getLine(), 0, "")));
    }

    public final void setNextStatement(@NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        this.manualPauseRequested = true;
        ISource<ExecutionCommandProxy> iSource = this.sessionProxy.getCommand();
        String string2 = position.getFile().getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"position.file.path");
        iSource.fire(new ExecutionCommandProxy(ExecutionCommandKind.SetNextStatement, new SourcePositionProxy(string2, position.getLine(), 0, position.getLine(), 0, "")));
    }

    public final boolean canSetNextStatement() {
        return this.setNextStatementIsEnabled;
    }

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return this.procHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        return this.console;
    }

    /*
     * WARNING - void declaration
     */
    public DotNetDebugProcess(@NotNull Lifetime sessionLifetime, @NotNull XDebugSession session2, @NotNull ProcessHandler procHandler, @NotNull ExecutionConsole console, @NotNull IProtocol protocol2, @NotNull DotNetDebuggerSessionModel sessionProxy, boolean fireInitializedManually, @NotNull IconHost iconHost) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)procHandler, (String)"procHandler");
        Intrinsics.checkParameterIsNotNull((Object)console, (String)"console");
        Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
        Intrinsics.checkParameterIsNotNull((Object)sessionProxy, (String)"sessionProxy");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        super(session2);
        this.sessionLifetime = sessionLifetime;
        this.procHandler = procHandler;
        this.console = console;
        this.protocol = protocol2;
        this.sessionProxy = sessionProxy;
        this.fireInitializedManually = fireInitializedManually;
        this.editorsProvider = new DotNetDebuggerEditorsProvider(iconHost);
        XBreakpointHandler[] xBreakpointHandlerArray = new XBreakpointHandler[]{new DotNetLineBreakpointHandler(this), new DotNetExceptionBreakpointHandler(this), new DotNetAllExceptionBreakpointHandler(this)};
        DotNetDebugProcess dotNetDebugProcess = this;
        Object[] objectArray = (Object[])elements$iv;
        dotNetDebugProcess.breakpointHandlers = (XBreakpointHandler[])objectArray;
        this.breakpointMap = new BidirectionalMap();
        this.state = State.Started;
        this.activateSession();
        this.processId = new Property();
    }

    public static final /* synthetic */ boolean access$getSetNextStatementIsEnabled$p(DotNetDebugProcess $this) {
        return $this.setNextStatementIsEnabled;
    }

    public static final /* synthetic */ void access$setSetNextStatementIsEnabled$p(DotNetDebugProcess $this, boolean bl) {
        $this.setNextStatementIsEnabled = bl;
    }

    @NotNull
    public static final /* synthetic */ BidirectionalMap access$getBreakpointMap$p(DotNetDebugProcess $this) {
        return $this.breakpointMap;
    }

    public static final /* synthetic */ boolean access$getManualPauseRequested$p(DotNetDebugProcess $this) {
        return $this.manualPauseRequested;
    }

    public static final /* synthetic */ void access$setManualPauseRequested$p(DotNetDebugProcess $this, boolean bl) {
        $this.manualPauseRequested = bl;
    }

    @NotNull
    public static final /* synthetic */ State access$getState$p(DotNetDebugProcess $this) {
        return $this.state;
    }

    public static final /* synthetic */ void access$setState$p(DotNetDebugProcess $this, @NotNull State state) {
        $this.state = state;
    }

    @NotNull
    public static final /* synthetic */ ExecutionConsole access$getConsole$p(DotNetDebugProcess $this) {
        return $this.console;
    }

    @NotNull
    public static final /* synthetic */ ConsoleViewImpl access$getDebuggerOutputConsole$p(DotNetDebugProcess $this) {
        ConsoleViewImpl consoleViewImpl = $this.debuggerOutputConsole;
        if (consoleViewImpl == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"debuggerOutputConsole");
        }
        return consoleViewImpl;
    }

    public static final /* synthetic */ void access$setDebuggerOutputConsole$p(DotNetDebugProcess $this, @NotNull ConsoleViewImpl consoleViewImpl) {
        $this.debuggerOutputConsole = consoleViewImpl;
    }

    public static final /* synthetic */ void access$breakpointStatusChanged(DotNetDebugProcess $this, @NotNull BreakpointModel breakPointModel, @NotNull BreakpointStatus status) {
        $this.breakpointStatusChanged(breakPointModel, status);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetDebugProcess$State;", "", "(Ljava/lang/String;I)V", "Started", "Ready", "Stopped", "rider"})
    private static final class State
    extends Enum<State> {
        public static final /* enum */ State Started;
        public static final /* enum */ State Ready;
        public static final /* enum */ State Stopped;
        private static final /* synthetic */ State[] $VALUES;

        static {
            State[] stateArray = new State[3];
            State[] stateArray2 = stateArray;
            stateArray[0] = Started = new State();
            stateArray[1] = Ready = new State();
            stateArray[2] = Stopped = new State();
            $VALUES = stateArray;
        }

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        public static State valueOf(String string2) {
            return Enum.valueOf(State.class, string2);
        }
    }
}

