/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.AsyncGenericProgramRunner;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.debugger.DebuggerHelperHost;
import com.jetbrains.resharper.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.resharper.debugger.DotNetDebugProcess;
import com.jetbrains.resharper.debugger.DotNetDebugRunner;
import com.jetbrains.resharper.debugger.DotNetRunnerBase;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.protocol.RdDispatcher;
import com.jetbrains.resharper.run.IDotNetCustomRunnerConfiguration;
import com.jetbrains.resharper.run.IDotNetDebugProfileState;
import com.jetbrains.resharper.run.IDotNetRunProfile;
import com.jetbrains.resharper.run.configurations.unitTesting.RiderUnitTestFakeDebugProfileState;
import com.jetbrains.resharper.util.concurrent.SyncEvent;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.utils.RiderProcessUtil;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.Identities;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.Serializers;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.framework.WireExKt;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DebuggerWorkerModel;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.PortPair;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001e2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001eB\u0005\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J6\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u001c\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u001dH\u0014\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetDebugRunner;", "Lcom/intellij/execution/runners/AsyncGenericProgramRunner;", "Lcom/intellij/execution/configurations/RunnerSettings;", "Lcom/jetbrains/resharper/debugger/DotNetRunnerBase;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createAndStartSession", "Lcom/intellij/xdebugger/XDebugSession;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/jetbrains/resharper/run/IDotNetDebugProfileState;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "sessionLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "workerProcessHandler", "Lcom/jetbrains/resharper/debugger/DebuggerWorkerProcessHandler;", "sessionModel", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "prepare", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/RunProfileStarter;", "environment", "Lcom/intellij/execution/configurations/RunProfileState;", "Companion", "rider"})
public final class DotNetDebugRunner
extends AsyncGenericProgramRunner<RunnerSettings>
implements DotNetRunnerBase {
    private static final long workerInitTimeoutMs = 100000L;
    @NotNull
    private static final Key<Boolean> FIRE_INITIALIZED_MANUALLY;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Promise promise2 = Promise.resolve((Object)new RunProfileStarter(this){
            final /* synthetic */ DotNetDebugRunner this$0;

            @Nullable
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                throw (Throwable)new UnsupportedOperationException("executeAsync must be called");
            }

            @NotNull
            public Promise<RunContentDescriptor> executeAsync(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                AsyncPromise asyncPromise = new AsyncPromise();
                if (state instanceof RiderUnitTestFakeDebugProfileState) {
                    ((RiderUnitTestFakeDebugProfileState)state).getSession().debug();
                    asyncPromise.setResult(null);
                    return (Promise)asyncPromise;
                }
                try {
                    ComponentManager $receiver$iv = (ComponentManager)environment.getProject();
                    Object object = $receiver$iv.getComponent(DebuggerHelperHost.class);
                    if (object == null) {
                        throw (Throwable)new IllegalStateException("Component " + DebuggerHelperHost.class + " not found in container " + $receiver$iv);
                    }
                    DebuggerHelperHost helper = (DebuggerHelperHost)object;
                    RunProfileState runProfileState = state;
                    if (!(runProfileState instanceof IDotNetDebugProfileState)) {
                        runProfileState = null;
                    }
                    IDotNetDebugProfileState iDotNetDebugProfileState = (IDotNetDebugProfileState)runProfileState;
                    if (iDotNetDebugProfileState == null) {
                        throw (Throwable)new CantRunException("This run profile is not supported: " + state.getClass());
                    }
                    IDotNetDebugProfileState debugProfileState = iDotNetDebugProfileState;
                    debugProfileState.checkBeforeExecution();
                    LifetimeDefinition processLifetimeDefinition = Lifetime.Companion.create(Lifetime.Companion.getEternal());
                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Creating protocol for debugger worker (execution id = " + environment.getExecutionId() + ")");
                    Protocol protocol2 = new Protocol(new Serializers(), new Identities(null, 1, null), new RdDispatcher(ApplicationKt.getApplication(), processLifetimeDefinition.getLifetime()), (Function1<? super Protocol, ? extends IWire>)((Function1)new Function1<Protocol, SocketWire.Server>(processLifetimeDefinition){
                        final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;

                        @NotNull
                        public final SocketWire.Server invoke(@NotNull Protocol it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return new SocketWire.Server(this.$processLifetimeDefinition.getLifetime(), it, null, "FrontendToDebugWorker");
                        }
                        {
                            this.$processLifetimeDefinition = lifetimeDefinition;
                            super(1);
                        }
                    }));
                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Creating worker run cmd (execution id = " + environment.getExecutionId() + ")");
                    Promise<GeneralCommandLine> cmdPromise = debugProfileState.createWorkerRunCmd(processLifetimeDefinition.getLifetime(), helper, WireExKt.getServerPort(protocol2.getWire()));
                    cmdPromise.rejected((Consumer)new Consumer<Throwable>(asyncPromise){
                        final /* synthetic */ AsyncPromise $asyncPromise;

                        public final void consume(Throwable throwable) {
                            com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Creating run cmd failed: " + throwable);
                            Throwable throwable2 = throwable;
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"throwable");
                            this.$asyncPromise.setError(throwable2);
                        }
                        {
                            this.$asyncPromise = asyncPromise;
                        }
                    });
                    cmdPromise.done((Consumer)new Consumer<GeneralCommandLine>(this, processLifetimeDefinition, protocol2, debugProfileState, environment, asyncPromise){
                        final /* synthetic */ prepare.1 this$0;
                        final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;
                        final /* synthetic */ Protocol $protocol;
                        final /* synthetic */ IDotNetDebugProfileState $debugProfileState;
                        final /* synthetic */ ExecutionEnvironment $environment;
                        final /* synthetic */ AsyncPromise $asyncPromise;

                        /*
                         * WARNING - void declaration
                         */
                        public final void consume(GeneralCommandLine workerCmd) {
                            void receiverPortToHost;
                            void senderPortToHost;
                            com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Run cmd created: " + workerCmd);
                            ProcessBuilder processBuilder = new ProcessBuilder(workerCmd.getCommandLineList(null));
                            File workerLogDir = new File(RiderEnvironment.INSTANCE.getLogDirectory(), "DebuggerWorker");
                            workerLogDir.mkdirs();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss");
                            String currentTimeString = format.format(new Date());
                            PortPair portPair = PortPair.Companion.getFree(6672, 6675);
                            int n2 = portPair.component1();
                            int n3 = portPair.component2();
                            portPair = null;
                            processBuilder.environment().clear();
                            Map<String, String> map2 = processBuilder.environment();
                            Map map3 = EnvironmentUtil.getEnvironmentMap();
                            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"EnvironmentUtil.getEnvironmentMap()");
                            map2.putAll(map3);
                            processBuilder.environment().put("LOG_DIR", workerLogDir.getAbsolutePath());
                            processBuilder.environment().put("DEBUGGER_PARENT_PROCESS_PID", String.valueOf(RiderProcessUtil.INSTANCE.getCurrentPid()));
                            processBuilder.environment().put("SENDER_PORT_TO_HOST", String.valueOf((int)senderPortToHost));
                            processBuilder.environment().put("RECEIVER_PORT_TO_HOST", String.valueOf((int)receiverPortToHost));
                            DebuggerWorkerModel workerModel = DebuggerWorkerModel.Companion.create(this.$processLifetimeDefinition.getLifetime(), this.$protocol);
                            com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Starting debugger worker process");
                            Process process2 = processBuilder.start();
                            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"processBuilder.start()");
                            String string2 = workerCmd.getCommandLineString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workerCmd.commandLineString");
                            DebuggerWorkerProcessHandler workerProcessHandler = new DebuggerWorkerProcessHandler(process2, string2, workerModel, this.$debugProfileState.getAttached(), this.$protocol, this.$processLifetimeDefinition.getLifetime());
                            workerProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(this){
                                final /* synthetic */ prepare.executeAsync.2 this$0;

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Debugger worker process terminated with code " + event.getExitCode() + " (execution id = " + this.this$0.$environment.getExecutionId() + ")");
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                        final /* synthetic */ prepare.executeAsync.1 this$0;

                                        public final void invoke() {
                                            if (!this.this$0.this$0.$processLifetimeDefinition.isTerminated()) {
                                                this.this$0.this$0.$processLifetimeDefinition.terminate();
                                            }
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = $outer;
                                }
                            });
                            RiderEnvironment.INSTANCE.addRiderProcess((BaseOSProcessHandler)workerProcessHandler);
                            if (workerProcessHandler.isProcessTerminated()) {
                                this.$processLifetimeDefinition.terminate();
                                this.$asyncPromise.setError((Throwable)new ExecutionException("Debugger worker process has exited unexpectedly with exit code " + workerProcessHandler.getProcess().exitValue()));
                                return;
                            }
                            workerModel.getHostPort().advise(this.$processLifetimeDefinition.getLifetime(), (Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
                                final /* synthetic */ prepare.executeAsync.2 this$0;

                                public final void invoke(int it) {
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this, it){
                                        final /* synthetic */ prepare.executeAsync.2 this$0;
                                        final /* synthetic */ int $it;

                                        public final void invoke() {
                                            com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Got helper port " + this.$it + ". Sending helper port to backend");
                                            CollectionExKt.put(SolutionHostExtensionsKt.getSolution(this.this$0.this$0.$environment.getProject()).getDebuggerWorkerConnectionHelper().getPorts(), this.this$0.this$0.$processLifetimeDefinition.getLifetime(), this.this$0.this$0.$environment.getExecutionId(), this.$it);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$it = n2;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                            SyncEvent event = new SyncEvent();
                            workerModel.getInitialized().advise(this.$processLifetimeDefinition.getLifetime(), (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, event){
                                final /* synthetic */ prepare.executeAsync.2 this$0;
                                final /* synthetic */ SyncEvent $event;

                                public final void invoke(boolean it) {
                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Debugger worker initialized event got");
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                        final /* synthetic */ prepare.executeAsync.3 this$0;

                                        public final void invoke() {
                                            this.this$0.$event.set();
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$event = syncEvent;
                                    super(1);
                                }
                            }));
                            ApplicationKt.getApplication().executeOnPooledThread(new Runnable(this, event, workerModel, workerProcessHandler, workerCmd){
                                final /* synthetic */ prepare.executeAsync.2 this$0;
                                final /* synthetic */ SyncEvent $event;
                                final /* synthetic */ DebuggerWorkerModel $workerModel;
                                final /* synthetic */ DebuggerWorkerProcessHandler $workerProcessHandler;
                                final /* synthetic */ GeneralCommandLine $workerCmd;

                                public final void run() {
                                    if (this.$event.wait(100000L)) {
                                        this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                            final /* synthetic */ prepare.executeAsync.4 this$0;

                                            public final void invoke() {
                                                try {
                                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Creating start info");
                                                    DebuggerStartInfoBase startInfoModel = this.this$0.this$0.$debugProfileState.createModelStartInfo();
                                                    DotNetDebuggerSessionModel sessionModel = new DotNetDebuggerSessionModel(startInfoModel);
                                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Setting session to worker");
                                                    PropertyExKt.set(this.this$0.$workerModel.getActiveSession(), sessionModel);
                                                    XDebugSession xDebugSession = this.this$0.this$0.this$0.this$0.createAndStartSession(this.this$0.this$0.$environment, this.this$0.this$0.$debugProfileState, this.this$0.this$0.$protocol, this.this$0.this$0.$processLifetimeDefinition.getLifetime(), this.this$0.$workerProcessHandler, sessionModel);
                                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Creating and starting frontend session");
                                                    this.this$0.this$0.$asyncPromise.setResult((Object)xDebugSession.getRunContentDescriptor());
                                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Session started");
                                                }
                                                catch (Throwable t2) {
                                                    com.jetbrains.resharper.debugger.DotNetDebugRunner$Companion.access$getLogger$p(DotNetDebugRunner.Companion).trace("Exception on starting session " + t2);
                                                    this.this$0.this$0.$asyncPromise.setError(t2);
                                                }
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(0);
                                            }
                                        }));
                                    } else {
                                        this.$workerProcessHandler.killProcess();
                                        this.this$0.$asyncPromise.setError((Throwable)new ProcessNotCreatedException("Debugger worker was not initialized within " + 100000L + " ms", this.$workerCmd));
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$event = syncEvent;
                                    this.$workerModel = debuggerWorkerModel;
                                    this.$workerProcessHandler = debuggerWorkerProcessHandler;
                                    this.$workerCmd = generalCommandLine;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$processLifetimeDefinition = lifetimeDefinition;
                            this.$protocol = protocol2;
                            this.$debugProfileState = iDotNetDebugProfileState;
                            this.$environment = executionEnvironment;
                            this.$asyncPromise = asyncPromise;
                        }
                    });
                }
                catch (Throwable t2) {
                    asyncPromise.setError(t2);
                }
                return (Promise)asyncPromise;
            }
            {
                this.this$0 = $outer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(object :\u2026\n            }\n        })");
        return promise2;
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile2, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)DefaultDebugExecutor.EXECUTOR_ID) && !(profile2 instanceof IDotNetCustomRunnerConfiguration) && profile2 instanceof IDotNetRunProfile;
    }

    @NotNull
    public final XDebugSession createAndStartSession(@NotNull ExecutionEnvironment env, @NotNull IDotNetDebugProfileState state, @NotNull IProtocol protocol2, @NotNull Lifetime sessionLifetime, @NotNull DebuggerWorkerProcessHandler workerProcessHandler, @NotNull DotNetDebuggerSessionModel sessionModel) {
        Boolean bl;
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkParameterIsNotNull((Object)workerProcessHandler, (String)"workerProcessHandler");
        Intrinsics.checkParameterIsNotNull((Object)sessionModel, (String)"sessionModel");
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)env.getProject());
        Executor executor2 = env.getExecutor();
        Intrinsics.checkExpressionValueIsNotNull((Object)executor2, (String)"env.executor");
        ExecutionResult executionResult = state.execute(executor2, this, workerProcessHandler);
        ProcessHandler processHandler2 = executionResult.getProcessHandler();
        ExecutionConsole executionConsole = executionResult.getExecutionConsole();
        if (Intrinsics.areEqual((Object)((Object)state.getConsoleKind()), (Object)((Object)IDotNetDebugProfileState.ConsoleKind.Normal)) ^ true) {
            ExecutionConsole executionConsole2 = executionConsole;
            if (!(executionConsole2 instanceof ConsoleView)) {
                executionConsole2 = null;
            }
            ConsoleView consoleView = (ConsoleView)executionConsole2;
            if (consoleView != null) {
                consoleView.print("Input/Output redirection disabled: " + state.getConsoleKind().getMessage() + System.lineSeparator(), ConsoleViewContentType.SYSTEM_OUTPUT);
            }
        }
        if ((bl = (Boolean)env.getUserData(Companion.getFIRE_INITIALIZED_MANUALLY())) == null) {
            bl = false;
        }
        Boolean fireInitializedManually = bl;
        XDebugSession newSession2 = debuggerManager.startSession(env, new XDebugProcessStarter(env, sessionLifetime, processHandler2, executionConsole, protocol2, sessionModel, fireInitializedManually){
            final /* synthetic */ ExecutionEnvironment $env;
            final /* synthetic */ Lifetime $sessionLifetime;
            final /* synthetic */ ProcessHandler $processHandler;
            final /* synthetic */ ExecutionConsole $executionConsole;
            final /* synthetic */ IProtocol $protocol;
            final /* synthetic */ DotNetDebuggerSessionModel $sessionModel;
            final /* synthetic */ Boolean $fireInitializedManually;

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                ComponentManager $receiver$iv = (ComponentManager)this.$env.getProject();
                Object object = $receiver$iv.getComponent(IconHost.class);
                if (object == null) {
                    throw (Throwable)new IllegalStateException("Component " + IconHost.class + " not found in container " + $receiver$iv);
                }
                IconHost iconHost = (IconHost)object;
                ProcessHandler processHandler2 = this.$processHandler;
                Intrinsics.checkExpressionValueIsNotNull((Object)processHandler2, (String)"processHandler");
                ExecutionConsole executionConsole = this.$executionConsole;
                Intrinsics.checkExpressionValueIsNotNull((Object)executionConsole, (String)"executionConsole");
                Boolean bl = this.$fireInitializedManually;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"fireInitializedManually");
                return new DotNetDebugProcess(this.$sessionLifetime, session2, processHandler2, executionConsole, this.$protocol, this.$sessionModel, bl, iconHost);
            }
            {
                this.$env = $captured_local_variable$0;
                this.$sessionLifetime = $captured_local_variable$1;
                this.$processHandler = $captured_local_variable$2;
                this.$executionConsole = $captured_local_variable$3;
                this.$protocol = $captured_local_variable$4;
                this.$sessionModel = $captured_local_variable$5;
                this.$fireInitializedManually = $captured_local_variable$6;
            }
        });
        newSession2.setPauseActionSupported(true);
        XDebugSession xDebugSession = newSession2;
        Intrinsics.checkExpressionValueIsNotNull((Object)xDebugSession, (String)"newSession");
        return xDebugSession;
    }

    static {
        Companion = new Companion(null);
        FIRE_INITIALIZED_MANUALLY = new Key("FIRE_INITIALIZED_MANUALLY");
        Logger logger = Logger.getInstance(DotNetDebugRunner.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DotNetDebugRunner.logger = logger;
    }

    @Override
    @NotNull
    @NonNls
    public String getRunnerId() {
        return DotNetRunnerBase.DefaultImpls.getRunnerId(this);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetDebugRunner$Companion;", "", "()V", "FIRE_INITIALIZED_MANUALLY", "Lcom/intellij/openapi/util/Key;", "", "getFIRE_INITIALIZED_MANUALLY", "()Lcom/intellij/openapi/util/Key;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "workerInitTimeoutMs", "", "rider"})
    public static final class Companion {
        @NotNull
        public final Key<Boolean> getFIRE_INITIALIZED_MANUALLY() {
            return FIRE_INITIALIZED_MANUALLY;
        }

        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

