/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.jetbrains.resharper.debugger.DebuggerFileUtilKt;
import com.jetbrains.resharper.debugger.DotNetExecutionStack;
import com.jetbrains.resharper.debugger.DotNetStackFrame;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.debuggerWorker.ComputeFramesArg;
import com.jetbrains.rider.model.debuggerWorker.ComputeFramesResult;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import com.jetbrains.rider.model.debuggerWorker.StackProxy;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\n\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u001e2\u0006\u0010&\u001a\u00020\u001aH\u0002J\u0016\u0010%\u001a\u00020\u001e2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001a0(H\u0002J\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u000fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetExecutionStack;", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "context", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "stackProxy", "Lcom/jetbrains/rider/model/debuggerWorker/StackProxy;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/rider/model/debuggerWorker/StackProxy;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "getContext", "()Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "framesLocationsValidityMarks", "", "", "", "framesLocationsValidityMarksLock", "Ljava/lang/Object;", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getStackProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/StackProxy;", "topFrame", "Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "checkFileMatchesDebugInfo", "path", "computeStackFrames", "", "firstFrameIndex", "", "container", "Lcom/intellij/xdebugger/frame/XExecutionStack$XStackFrameContainer;", "getTopFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "modifyLocationValidityMarks", "frame", "frames", "", "normalizePath", "rider"})
public final class DotNetExecutionStack
extends XExecutionStack {
    private final Map<String, Boolean> framesLocationsValidityMarks;
    private final Object framesLocationsValidityMarksLock;
    private DotNetStackFrame topFrame;
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final ExecutionContextProxy context;
    @NotNull
    private final StackProxy stackProxy;
    @NotNull
    private final Lifetime lifetime;

    @Nullable
    public XStackFrame getTopFrame() {
        return this.topFrame;
    }

    public void computeStackFrames(int firstFrameIndex, @NotNull XExecutionStack.XStackFrameContainer container) {
        int firstIndex;
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        if (this.lifetime.isTerminated()) {
            container.errorOccurred("Stack is not valid");
            return;
        }
        if (this.topFrame == null) {
            XExecutionStack.XStackFrameContainer xStackFrameContainer = container;
            ArrayList arrayList = new ArrayList();
            xStackFrameContainer.addStackFrames((List)arrayList, true);
        }
        if ((firstIndex = firstFrameIndex) == 0) {
            container.addStackFrames((List)CollectionsKt.arrayListOf((Object[])new DotNetStackFrame[]{this.topFrame}), false);
            firstIndex = 1;
        }
        this.context.getComputeFrames().start(new ComputeFramesArg(this.stackProxy.getId(), firstIndex), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<ComputeFramesResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends ComputeFramesResult>, Unit>(this, container){
            final /* synthetic */ DotNetExecutionStack this$0;
            final /* synthetic */ XExecutionStack.XStackFrameContainer $container;

            /*
             * WARNING - void declaration
             */
            public final void invoke(@NotNull RdTaskResult<ComputeFramesResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ComputeFramesResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    String topFrameFilename;
                    void $receiver$iv$iv;
                    Iterable $receiver$iv;
                    ComputeFramesResult result2 = (ComputeFramesResult)((RdTaskResult.Success)it).getValue();
                    if (result2.getStackId() != this.this$0.getStackProxy().getId()) {
                        return;
                    }
                    Iterable iterable = $receiver$iv = (Iterable)result2.getFrames();
                    Object destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void it2;
                        StackFrameProxy stackFrameProxy = (StackFrameProxy)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        DotNetStackFrame dotNetStackFrame = new DotNetStackFrame(this.this$0.getSession(), this.this$0.getContext(), (StackFrameProxy)it2, this.this$0, this.this$0.getLifetime());
                        collection.add(dotNetStackFrame);
                    }
                    List frames = (List)destination$iv$iv;
                    this.$container.addStackFrames(frames, result2.getLast());
                    Object object = DotNetExecutionStack.access$getTopFrame$p(this.this$0);
                    SourcePositionProxy sourcePositionProxy = object != null && (object = object.getFrameProxy()) != null ? ((StackFrameProxy)object).getLocation() : null;
                    Project project2 = this.this$0.getSession().getProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"session.project");
                    VirtualFile topFrameFile = DebuggerFileUtilKt.findFileConsiderProjectMoved(sourcePositionProxy, project2);
                    Object object2 = DotNetExecutionStack.access$getTopFrame$p(this.this$0);
                    String string2 = object2 != null && (object2 = object2.getFrameProxy()) != null && (object2 = ((StackFrameProxy)object2).getLocation()) != null ? ((SourcePositionProxy)object2).getFilename() : (topFrameFilename = null);
                    if (topFrameFile == null) {
                        if (DotNetExecutionStack.access$getTopFrame$p(this.this$0) != null && !((destination$iv$iv = (CharSequence)topFrameFilename) == null || destination$iv$iv.length() == 0)) {
                            XDebugSessionImpl.NOTIFICATION_GROUP.createNotification("Cannot navigate to file", "File " + topFrameFilename + " is referenced in debug symbols but doesn't exist locally", NotificationType.INFORMATION, null).notify(this.this$0.getSession().getProject());
                        }
                        for (DotNetStackFrame frame : frames) {
                            SourcePositionProxy sourcePositionProxy2 = frame.getFrameProxy().getLocation();
                            Project project3 = this.this$0.getSession().getProject();
                            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"session.project");
                            if (DebuggerFileUtilKt.findFileConsiderProjectMoved(sourcePositionProxy2, project3) == null) {
                                continue;
                            }
                            AppUIUtil.invokeLaterIfProjectAlive(this.this$0.getSession().getProject(), new Runnable(this, frame){
                                final /* synthetic */ computeStackFrames.1 this$0;
                                final /* synthetic */ DotNetStackFrame $frame;

                                public final void run() {
                                    XDebugSessionTab sessionTab;
                                    this.this$0.this$0.getSession().setCurrentStackFrame((XExecutionStack)this.this$0.this$0, (XStackFrame)this.$frame, false);
                                    XDebugSession xDebugSession = this.this$0.this$0.getSession();
                                    if (!(xDebugSession instanceof XDebugSessionImpl)) {
                                        xDebugSession = null;
                                    }
                                    XDebugSessionImpl xDebugSessionImpl = (XDebugSessionImpl)xDebugSession;
                                    XDebugSessionTab xDebugSessionTab = sessionTab = xDebugSessionImpl != null ? xDebugSessionImpl.getSessionTab() : null;
                                    if (sessionTab == null) {
                                        this.this$0.this$0.getSession().updateExecutionPosition();
                                    } else {
                                        sessionTab.toFront(true, new Runnable(this){
                                            final /* synthetic */ computeStackFrames.1 this$0;

                                            public final void run() {
                                                this.this$0.this$0.this$0.getSession().updateExecutionPosition();
                                            }
                                            {
                                                this.this$0 = var1_1;
                                            }
                                        });
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$frame = dotNetStackFrame;
                                }
                            });
                            break;
                        }
                        DotNetExecutionStack.access$modifyLocationValidityMarks(this.this$0, frames);
                    }
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    String string3 = ((RdTaskResult.Fault)it).getError().getMessage();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$container.errorOccurred(string3);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    this.$container.errorOccurred("Evaluation of frames was cancelled");
                }
            }
            {
                this.this$0 = dotNetExecutionStack;
                this.$container = xStackFrameContainer;
                super(1);
            }
        }));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean checkFileMatchesDebugInfo(@NotNull String path) {
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Object object = this.framesLocationsValidityMarksLock;
        synchronized (object) {
            Boolean bl = this.framesLocationsValidityMarks.get(this.normalizePath(path));
            boolean bl2 = bl != null ? bl : true;
            return bl2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyLocationValidityMarks(DotNetStackFrame frame) {
        Object object = this.framesLocationsValidityMarksLock;
        synchronized (object) {
            Object object2 = frame.getFrameProxy().getLocation();
            if (object2 == null || (object2 = ((SourcePositionProxy)object2).getFilename()) == null) {
                return;
            }
            Object location = object2;
            Boolean bl = this.framesLocationsValidityMarks.put(this.normalizePath((String)location), frame.getFrameProxy().isDebugInfoMatchesSources());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void modifyLocationValidityMarks(List<DotNetStackFrame> frames) {
        Object object = this.framesLocationsValidityMarksLock;
        synchronized (object) {
            for (DotNetStackFrame frame : frames) {
                Object object2 = frame.getFrameProxy().getLocation();
                if (object2 == null || (object2 = ((SourcePositionProxy)object2).getFilename()) == null) {
                    continue;
                }
                Object location = object2;
                this.framesLocationsValidityMarks.put(this.normalizePath((String)location), frame.getFrameProxy().isDebugInfoMatchesSources());
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final String normalizePath(String path) {
        String string2;
        String string3 = string2 = StringsKt.replace$default((String)path, (String)"\\", (String)"/", (boolean)false, (int)4, null);
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.toLowerCase();
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
        return string4;
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final ExecutionContextProxy getContext() {
        return this.context;
    }

    @NotNull
    public final StackProxy getStackProxy() {
        return this.stackProxy;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public DotNetExecutionStack(@NotNull XDebugSession session2, @NotNull ExecutionContextProxy context2, @NotNull StackProxy stackProxy, @NotNull Lifetime lifetime) {
        DotNetStackFrame dotNetStackFrame;
        Map map2;
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)stackProxy, (String)"stackProxy");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        super(stackProxy.getName() + " @" + stackProxy.getThreadId());
        this.session = session2;
        this.context = context2;
        this.stackProxy = stackProxy;
        this.lifetime = lifetime;
        DotNetExecutionStack dotNetExecutionStack = this;
        dotNetExecutionStack.framesLocationsValidityMarks = map2 = (Map)new LinkedHashMap();
        this.framesLocationsValidityMarksLock = new Object();
        if (this.stackProxy.getTopFrame() == null) {
            dotNetStackFrame = null;
        } else {
            StackFrameProxy stackFrameProxy = this.stackProxy.getTopFrame();
            if (stackFrameProxy == null) {
                Intrinsics.throwNpe();
            }
            dotNetStackFrame = this.topFrame = new DotNetStackFrame(this.session, this.context, stackFrameProxy, this, this.lifetime);
        }
        if (this.topFrame != null) {
            DotNetStackFrame dotNetStackFrame2 = this.topFrame;
            if (dotNetStackFrame2 == null) {
                Intrinsics.throwNpe();
            }
            this.modifyLocationValidityMarks(dotNetStackFrame2);
        }
    }

    @Nullable
    public static final /* synthetic */ DotNetStackFrame access$getTopFrame$p(DotNetExecutionStack $this) {
        return $this.topFrame;
    }

    public static final /* synthetic */ void access$setTopFrame$p(DotNetExecutionStack $this, @Nullable DotNetStackFrame dotNetStackFrame) {
        $this.topFrame = dotNetStackFrame;
    }

    public static final /* synthetic */ void access$modifyLocationValidityMarks(DotNetExecutionStack $this, @NotNull List frames) {
        $this.modifyLocationValidityMarks(frames);
    }
}

