/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.ThreeState;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XInlineDebuggerDataCallback;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.resharper.debugger.DotNetNamedValue;
import com.jetbrains.resharper.debugger.DotNetStackFrame;
import com.jetbrains.resharper.debugger.DotNetValue;
import com.jetbrains.resharper.debugger.DotNetValueModifier;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.PsiDebuggerHostModel;
import com.jetbrains.rider.model.ResolveLocalSymbolArg;
import com.jetbrains.rider.model.ResolveLocalSymbolResult;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010+H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0011R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetNamedValue;", "Lcom/intellij/xdebugger/frame/XNamedValue;", "name", "", "objectProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "frame", "Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "isLocal", "", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Ljava/lang/String;Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;Lcom/jetbrains/resharper/debugger/DotNetStackFrame;ZLcom/jetbrains/rider/util/lifetime/Lifetime;)V", "documentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "getFrame", "()Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "()Z", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getObjectProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "value", "Lcom/jetbrains/resharper/debugger/DotNetValue;", "calculateEvaluationExpression", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/XExpression;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computeInlineDebuggerData", "Lcom/intellij/util/ThreeState;", "callback", "Lcom/intellij/xdebugger/frame/XInlineDebuggerDataCallback;", "computePresentation", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "computeSourcePosition", "navigatable", "Lcom/intellij/xdebugger/frame/XNavigatable;", "getModifier", "Lcom/intellij/xdebugger/frame/XValueModifier;", "rider"})
public final class DotNetNamedValue
extends XNamedValue {
    private final DotNetValue value;
    private final FileDocumentManager documentManager;
    @NotNull
    private final ObjectProxy objectProxy;
    @NotNull
    private final DotNetStackFrame frame;
    private final boolean isLocal;
    @NotNull
    private final Lifetime lifetime;

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        this.value.computePresentation(node, place);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        this.value.computeChildren(node);
    }

    @Nullable
    public XValueModifier getModifier() {
        ObjectPropertiesProxy objectPropertiesProxy = this.objectProxy.getProperties();
        if (objectPropertiesProxy == null) {
            return null;
        }
        ObjectPropertiesProxy properties = objectPropertiesProxy;
        if (properties.isReadonly()) {
            return null;
        }
        return new DotNetValueModifier(this);
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        Intrinsics.checkParameterIsNotNull((Object)navigatable, (String)"navigatable");
        if (this.lifetime.isTerminated()) {
            return;
        }
        if (!this.isLocal) {
            return;
        }
        XSourcePosition xSourcePosition = this.frame.getSourcePosition();
        if (xSourcePosition == null) {
            return;
        }
        XSourcePosition sourcePosition = xSourcePosition;
        PsiDebuggerHostModel psiDebuggerHost = SolutionHostExtensionsKt.getSolution(this.frame.getSession().getProject()).getPsiDebuggerHost();
        Document document = this.documentManager.getDocument(sourcePosition.getFile());
        if (document == null) {
            return;
        }
        Document document2 = document;
        Project project2 = this.frame.getSession().getProject();
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"frame.session.project");
        EditableEntityId editableEntityId = DocumentExKt.getFirstEditableEntityId(document2, project2);
        if (editableEntityId == null) {
            return;
        }
        EditableEntityId editableEntityId2 = editableEntityId;
        IRdCall<ResolveLocalSymbolArg, ResolveLocalSymbolResult> iRdCall = psiDebuggerHost.getResolveLocalSymbol();
        int n2 = sourcePosition.getOffset();
        String string2 = this.myName;
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"myName");
        iRdCall.start(new ResolveLocalSymbolArg(editableEntityId2, n2, string2), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<ResolveLocalSymbolResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends ResolveLocalSymbolResult>, Unit>(navigatable, sourcePosition){
            final /* synthetic */ XNavigatable $navigatable;
            final /* synthetic */ XSourcePosition $sourcePosition;

            public final void invoke(@NotNull RdTaskResult<ResolveLocalSymbolResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ResolveLocalSymbolResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    ResolveLocalSymbolResult resolveLocalSymbolResult = (ResolveLocalSymbolResult)((RdTaskResult.Success)it).getValue();
                    if (resolveLocalSymbolResult == null) {
                        return;
                    }
                    ResolveLocalSymbolResult value2 = resolveLocalSymbolResult;
                    ApplicationKt.getApplication().runReadAction(new Runnable(this, value2){
                        final /* synthetic */ computeSourcePosition.1 this$0;
                        final /* synthetic */ ResolveLocalSymbolResult $value;

                        public final void run() {
                            this.this$0.$navigatable.setSourcePosition(XDebuggerUtil.getInstance().createPositionByOffset(this.this$0.$sourcePosition.getFile(), this.$value.getDeclarationOffset()));
                        }
                        {
                            this.this$0 = var1_1;
                            this.$value = resolveLocalSymbolResult;
                        }
                    });
                }
            }
            {
                this.$navigatable = xNavigatable;
                this.$sourcePosition = xSourcePosition;
                super(1);
            }
        }));
    }

    @NotNull
    public ThreeState computeInlineDebuggerData(@NotNull XInlineDebuggerDataCallback callback) {
        ThreeState threeState;
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        if (this.isLocal) {
            ThreeState threeState2 = super.computeInlineDebuggerData(callback);
            threeState = threeState2;
            Intrinsics.checkExpressionValueIsNotNull((Object)threeState2, (String)"super.computeInlineDebuggerData(callback)");
        } else {
            threeState = ThreeState.NO;
        }
        return threeState;
    }

    @NotNull
    public Promise<XExpression> calculateEvaluationExpression() {
        Promise promise2 = this.value.calculateEvaluationExpression();
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"value.calculateEvaluationExpression()");
        return promise2;
    }

    @NotNull
    public final ObjectProxy getObjectProxy() {
        return this.objectProxy;
    }

    @NotNull
    public final DotNetStackFrame getFrame() {
        return this.frame;
    }

    public final boolean isLocal() {
        return this.isLocal;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    /*
     * WARNING - void declaration
     */
    public DotNetNamedValue(@NotNull String name, @NotNull ObjectProxy objectProxy, @NotNull DotNetStackFrame frame, boolean isLocal, @NotNull Lifetime lifetime) {
        void $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        Intrinsics.checkParameterIsNotNull((Object)objectProxy, (String)"objectProxy");
        Intrinsics.checkParameterIsNotNull((Object)((Object)frame), (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        super(name);
        this.objectProxy = objectProxy;
        this.frame = frame;
        this.isLocal = isLocal;
        this.lifetime = lifetime;
        this.value = new DotNetValue(this.frame, this.objectProxy, this.lifetime);
        ComponentManager componentManager = (ComponentManager)this.frame.getSession().getProject();
        DotNetNamedValue dotNetNamedValue = this;
        Object object = $receiver$iv.getComponent(FileDocumentManager.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + FileDocumentManager.class + " not found in container " + $receiver$iv);
        }
        Object object2 = object;
        dotNetNamedValue.documentManager = (FileDocumentManager)object2;
    }
}

