/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.XSourcePositionWrapper;
import com.intellij.xdebugger.impl.ui.ExecutionPointHighlighter;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.framework.base.IRdBindableKt;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\n\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetSourcePositionWrapper;", "Lcom/intellij/xdebugger/XSourcePositionWrapper;", "Lcom/intellij/xdebugger/impl/ui/ExecutionPointHighlighter$HighlighterProvider;", "position", "Lcom/intellij/xdebugger/XSourcePosition;", "positionProxy", "Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "(Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;)V", "getPositionProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/SourcePositionProxy;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "Companion", "rider"})
public final class DotNetSourcePositionWrapper
extends XSourcePositionWrapper
implements ExecutionPointHighlighter.HighlighterProvider {
    @NotNull
    private final SourcePositionProxy positionProxy;
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public TextRange getHighlightRange() {
        if (this.positionProxy.getLine() < 0 || this.positionProxy.getColumn() < 0 || this.positionProxy.getEndColumn() < 0 || this.positionProxy.getEndLine() < 0) {
            DotNetSourcePositionWrapper.Companion.getLogger().debug("Source position is incomplete or invalid to create range: " + IRdBindableKt.printToString(this.positionProxy));
            return null;
        }
        AccessToken lock = ApplicationKt.getApplication().acquireReadActionLock();
        try {
            Document document;
            if (this.getFile() instanceof LightVirtualFile || this.getFile() instanceof HttpVirtualFile) {
                TextRange textRange = null;
                return textRange;
            }
            if (!this.getFile().isValid()) {
                TextRange textRange = null;
                return textRange;
            }
            if (FileDocumentManager.getInstance().getDocument(this.getFile()) == null) {
                TextRange textRange = null;
                return textRange;
            }
            Document document2 = document;
            if (this.positionProxy.getLine() >= document2.getLineCount()) {
                DotNetSourcePositionWrapper.Companion.getLogger().error("Start line " + this.positionProxy.getLine() + " is out of document lines " + document2.getLineCount());
                TextRange textRange = null;
                return textRange;
            }
            int startOffset = document2.getLineStartOffset(this.positionProxy.getLine()) + this.positionProxy.getColumn();
            if (startOffset >= document2.getTextLength()) {
                DotNetSourcePositionWrapper.Companion.getLogger().error("Resulting start offset " + startOffset + " is out of document length " + document2.getTextLength());
                TextRange textRange = null;
                return textRange;
            }
            if (this.positionProxy.getEndLine() >= document2.getLineCount()) {
                DotNetSourcePositionWrapper.Companion.getLogger().error("End line " + this.positionProxy.getEndLine() + " is out of document lines " + document2.getLineCount());
                TextRange textRange = null;
                return textRange;
            }
            int endOffset = document2.getLineStartOffset(this.positionProxy.getEndLine()) + this.positionProxy.getEndColumn();
            if (endOffset >= document2.getTextLength()) {
                DotNetSourcePositionWrapper.Companion.getLogger().error("Resulting end offset " + endOffset + " is out of document length " + document2.getTextLength());
                TextRange textRange = null;
                return textRange;
            }
            TextRange textRange = new TextRange(startOffset, endOffset);
            return textRange;
        }
        finally {
            lock.finish();
        }
    }

    @NotNull
    public final SourcePositionProxy getPositionProxy() {
        return this.positionProxy;
    }

    public DotNetSourcePositionWrapper(@NotNull XSourcePosition position, @NotNull SourcePositionProxy positionProxy) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        Intrinsics.checkParameterIsNotNull((Object)positionProxy, (String)"positionProxy");
        super(position);
        this.positionProxy = positionProxy;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DotNetSourcePositionWrapper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DotNetSourcePositionWrapper.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetSourcePositionWrapper$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

