/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PathUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.resharper.debugger.DebuggerFileUtilKt;
import com.jetbrains.resharper.debugger.DotNetExecutionStack;
import com.jetbrains.resharper.debugger.DotNetNamedValue;
import com.jetbrains.resharper.debugger.DotNetSourcePositionWrapper;
import com.jetbrains.resharper.debugger.evaluation.DotNetEvaluator;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.debuggerWorker.ComputeFrameLocalsArg;
import com.jetbrains.rider.model.debuggerWorker.ComputeFrameLocalsResult;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.model.debuggerWorker.SourcePositionProxy;
import com.jetbrains.rider.model.debuggerWorker.StackFrameProxy;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import java.io.File;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\n\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "context", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "frameProxy", "Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "stack", "Lcom/jetbrains/resharper/debugger/DotNetExecutionStack;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;Lcom/jetbrains/resharper/debugger/DotNetExecutionStack;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "getContext", "()Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "getFrameProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/StackFrameProxy;", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "getStack", "()Lcom/jetbrains/resharper/debugger/DotNetExecutionStack;", "computeChildren", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "customizePresentation", "component", "Lcom/intellij/ui/ColoredTextContainer;", "getEvaluator", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "getSourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "rider"})
public final class DotNetStackFrame
extends XStackFrame {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final ExecutionContextProxy context;
    @NotNull
    private final StackFrameProxy frameProxy;
    @NotNull
    private final DotNetExecutionStack stack;
    @NotNull
    private final Lifetime lifetime;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XSourcePosition getSourcePosition() {
        void simplePosition;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        SourcePositionProxy sourcePositionProxy = this.frameProxy.getLocation();
        if (sourcePositionProxy == null) {
            return null;
        }
        SourcePositionProxy positionProxy = sourcePositionProxy;
        ApplicationKt.getApplication().invokeAndWait(new Runnable(this, positionProxy, (Ref.ObjectRef)simplePosition){
            final /* synthetic */ DotNetStackFrame this$0;
            final /* synthetic */ SourcePositionProxy $positionProxy;
            final /* synthetic */ Ref.ObjectRef $simplePosition;

            public final void run() {
                Project project2 = this.this$0.getSession().getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"session.project");
                VirtualFile virtualFile = DebuggerFileUtilKt.findFileConsiderProjectMoved(this.$positionProxy, project2);
                this.$simplePosition.element = XDebuggerUtil.getInstance().createPosition(virtualFile, this.$positionProxy.getLine());
            }
            {
                this.this$0 = dotNetStackFrame;
                this.$positionProxy = sourcePositionProxy;
                this.$simplePosition = objectRef;
            }
        });
        if ((XSourcePosition)simplePosition.element == null) {
            return null;
        }
        XSourcePosition xSourcePosition = (XSourcePosition)simplePosition.element;
        if (xSourcePosition == null) {
            Intrinsics.throwNpe();
        }
        return (XSourcePosition)new DotNetSourcePositionWrapper(xSourcePosition, positionProxy);
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        boolean bl;
        block14: {
            String string2;
            String typeName;
            String string3;
            String string4;
            Intrinsics.checkParameterIsNotNull((Object)component, (String)"component");
            int methodNameLastDot = StringsKt.lastIndexOf$default((CharSequence)this.frameProxy.getMethodName(), (char)'.', (int)0, (boolean)false, (int)6, null);
            if (methodNameLastDot != -1) {
                String string5 = this.frameProxy.getMethodName();
                int n2 = methodNameLastDot + 1;
                String string6 = string5;
                if (string6 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string7 = string6.substring(n2);
                string4 = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string7, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string4 = this.frameProxy.getMethodName();
            }
            String methodName = string4;
            int typeNameLastDot = StringsKt.lastIndexOf$default((CharSequence)this.frameProxy.getTypeName(), (char)'.', (int)0, (boolean)false, (int)6, null);
            if (typeNameLastDot != -1) {
                String string8 = this.frameProxy.getTypeName();
                int n3 = typeNameLastDot + 1;
                String string9 = string8;
                if (string9 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string10 = string9.substring(n3);
                string3 = string10;
                Intrinsics.checkExpressionValueIsNotNull((Object)string10, (String)"(this as java.lang.String).substring(startIndex)");
            } else {
                string3 = typeName = this.frameProxy.getTypeName();
            }
            if (typeNameLastDot != -1) {
                String string11 = this.frameProxy.getTypeName();
                int n4 = 0;
                String string12 = string11;
                if (string12 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
                }
                String string13 = string12.substring(n4, typeNameLastDot);
                string2 = string13;
                Intrinsics.checkExpressionValueIsNotNull((Object)string13, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string2 = "";
            }
            String namespace = string2;
            String moduleName = PathUtil.getFileName((String)this.frameProxy.getModuleName());
            SourcePositionProxy sourcePositionProxy = this.frameProxy.getLocation();
            component.append(methodName + "()", this.frameProxy.isExternalCode() ? SimpleTextAttributes.DARK_TEXT : SimpleTextAttributes.REGULAR_ATTRIBUTES);
            if (sourcePositionProxy != null) {
                component.append(":" + (sourcePositionProxy.getLine() + 1), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            }
            component.append(", " + typeName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(" (" + namespace + ")@" + moduleName, SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
            component.setIcon(AllIcons.Debugger.StackFrame);
            if (sourcePositionProxy == null) {
                return;
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(sourcePositionProxy.getFilename()), (boolean)true);
            if (virtualFile == null) {
                return;
            }
            VirtualFile virtualFile2 = virtualFile;
            XLineBreakpointType[] breakpointTypes = XDebuggerUtil.getInstance().getLineBreakpointTypes();
            Object[] $receiver$iv = breakpointTypes;
            for (int i2 = 0; i2 < $receiver$iv.length; ++i2) {
                Object element$iv = $receiver$iv[i2];
                XLineBreakpointType type = (XLineBreakpointType)element$iv;
                if (!(XDebuggerManager.getInstance((Project)this.session.getProject()).getBreakpointManager().findBreakpointAtLine(type, virtualFile2, sourcePositionProxy.getLine()) != null)) continue;
                bl = true;
                break block14;
            }
            bl = false;
        }
        if (bl) {
            component.setIcon(AllIcons.Debugger.Db_set_breakpoint);
        }
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (this.lifetime.isTerminated()) {
            node.setErrorMessage("Frame is not valid");
            return;
        }
        this.context.getComputeFrameLocals().start(new ComputeFrameLocalsArg(this.frameProxy.getId()), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<ComputeFrameLocalsResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends ComputeFrameLocalsResult>, Unit>(this, node){
            final /* synthetic */ DotNetStackFrame this$0;
            final /* synthetic */ XCompositeNode $node;

            public final void invoke(@NotNull RdTaskResult<ComputeFrameLocalsResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ComputeFrameLocalsResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    ComputeFrameLocalsResult result2 = (ComputeFrameLocalsResult)((RdTaskResult.Success)it).getValue();
                    if (result2.getFrameId() != this.this$0.getFrameProxy().getId()) {
                        return;
                    }
                    XValueChildrenList childrenList = new XValueChildrenList();
                    for (ObjectProxy value2 : result2.getLocals()) {
                        childrenList.add((XNamedValue)new DotNetNamedValue(value2.getName(), value2, this.this$0, true, this.this$0.getLifetime()));
                    }
                    this.$node.addChildren(childrenList, true);
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    String string2 = ((RdTaskResult.Fault)it).getError().getMessage();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$node.setErrorMessage(string2);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    this.$node.setErrorMessage("Computation cancelled");
                }
            }
            {
                this.this$0 = dotNetStackFrame;
                this.$node = xCompositeNode;
                super(1);
            }
        }));
    }

    @Nullable
    public XDebuggerEvaluator getEvaluator() {
        return new DotNetEvaluator(this.session, this.context, this, this.lifetime);
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final ExecutionContextProxy getContext() {
        return this.context;
    }

    @NotNull
    public final StackFrameProxy getFrameProxy() {
        return this.frameProxy;
    }

    @NotNull
    public final DotNetExecutionStack getStack() {
        return this.stack;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public DotNetStackFrame(@NotNull XDebugSession session2, @NotNull ExecutionContextProxy context2, @NotNull StackFrameProxy frameProxy, @NotNull DotNetExecutionStack stack, @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)context2, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)frameProxy, (String)"frameProxy");
        Intrinsics.checkParameterIsNotNull((Object)((Object)stack), (String)"stack");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.session = session2;
        this.context = context2;
        this.frameProxy = frameProxy;
        this.stack = stack;
        this.lifetime = lifetime;
    }
}

