/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.LayeredIcon;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.frame.presentation.XErrorValuePresentation;
import com.intellij.xdebugger.frame.presentation.XValuePresentation;
import com.jetbrains.resharper.debugger.DotNetNamedValue;
import com.jetbrains.resharper.debugger.DotNetStackFrame;
import com.jetbrains.resharper.debugger.DotNetValue;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.debuggerWorker.ComputeObjectPropertiesArg;
import com.jetbrains.rider.model.debuggerWorker.ComputeValueChildrenArg;
import com.jetbrains.rider.model.debuggerWorker.ComputeValueChildrenResult;
import com.jetbrains.rider.model.debuggerWorker.ObjectPropertiesProxy;
import com.jetbrains.rider.model.debuggerWorker.ObjectProxy;
import com.jetbrains.rider.model.debuggerWorker.RefreshValueArg;
import com.jetbrains.rider.model.debuggerWorker.RefreshValueResult;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 (2\u00020\u0001:\u0001(B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ:\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u001cH\u0002J\u0010\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u001fH\u0016J\u0018\u0010 \u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u0014H\u0002J\u0018\u0010$\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001aH\u0002J \u0010&\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J \u0010'\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010\u00a8\u0006)"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetValue;", "Lcom/intellij/xdebugger/frame/XValue;", "frame", "Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "objectProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/jetbrains/resharper/debugger/DotNetStackFrame;Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "getFrame", "()Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getObjectProxy", "()Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;", "setObjectProxy", "(Lcom/jetbrains/rider/model/debuggerWorker/ObjectProxy;)V", "addFullValueEvaluator", "", "objectPropertiesProxy", "Lcom/jetbrains/rider/model/debuggerWorker/ObjectPropertiesProxy;", "node", "Lcom/intellij/xdebugger/frame/XValueNode;", "place", "Lcom/intellij/xdebugger/frame/XValuePlace;", "name", "", "showPopup", "", "shouldUpdatePresentation", "computeChildren", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "computePresentation", "getIcon", "Ljavax/swing/Icon;", "properties", "setError", "error", "updateFullValueEvaluators", "updateProperties", "Companion", "rider"})
public final class DotNetValue
extends XValue {
    @NotNull
    private final DotNetStackFrame frame;
    @NotNull
    private ObjectProxy objectProxy;
    @NotNull
    private final Lifetime lifetime;
    private static final Logger logger;
    public static final Companion Companion;

    public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)place, (String)"place");
        ObjectPropertiesProxy objectPropertiesProxy = this.objectProxy.getProperties();
        if (objectPropertiesProxy != null) {
            this.updateProperties(node, objectPropertiesProxy, place);
            return;
        }
        this.frame.getContext().getComputeObjectProperties().start(new ComputeObjectPropertiesArg(this.objectProxy.getId()), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<ObjectPropertiesProxy>, Unit>)((Function1)new Function1<RdTaskResult<? extends ObjectPropertiesProxy>, Unit>(this, node, place){
            final /* synthetic */ DotNetValue this$0;
            final /* synthetic */ XValueNode $node;
            final /* synthetic */ XValuePlace $place;

            public final void invoke(@NotNull RdTaskResult<ObjectPropertiesProxy> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ObjectPropertiesProxy> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    DotNetValue.access$updateProperties(this.this$0, this.$node, (ObjectPropertiesProxy)((RdTaskResult.Success)it).getValue(), this.$place);
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    String string2 = ((RdTaskResult.Fault)it).getError().getMessage();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    DotNetValue.access$setError(this.this$0, this.$node, string2);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    DotNetValue.access$setError(this.this$0, this.$node, "Computation cancelled");
                }
            }
            {
                this.this$0 = dotNetValue;
                this.$node = xValueNode;
                this.$place = xValuePlace;
                super(1);
            }
        }));
    }

    private final void setError(XValueNode node, String error) {
        node.setPresentation(AllIcons.General.Error, (XValuePresentation)new XErrorValuePresentation(error), false);
    }

    private final void updateProperties(XValueNode node, ObjectPropertiesProxy objectPropertiesProxy, XValuePlace place) {
        node.setPresentation(this.getIcon(objectPropertiesProxy), new XValuePresentation(objectPropertiesProxy){
            final /* synthetic */ ObjectPropertiesProxy $objectPropertiesProxy;

            public void renderValue(@NotNull XValuePresentation.XValueTextRenderer renderer) {
                Intrinsics.checkParameterIsNotNull((Object)renderer, (String)"renderer");
                if (this.$objectPropertiesProxy.isError()) {
                    renderer.renderError(this.$objectPropertiesProxy.getValue());
                } else if (this.$objectPropertiesProxy.isString() && !this.$objectPropertiesProxy.isNull()) {
                    renderer.renderStringValue(this.$objectPropertiesProxy.getValue());
                } else {
                    renderer.renderValue(this.$objectPropertiesProxy.getValue());
                }
            }

            @Nullable
            public String getType() {
                return this.$objectPropertiesProxy.getType();
            }
            {
                this.$objectPropertiesProxy = $captured_local_variable$0;
            }
        }, objectPropertiesProxy.getHasChildren());
        this.updateFullValueEvaluators(objectPropertiesProxy, node, place);
    }

    private final void updateFullValueEvaluators(ObjectPropertiesProxy objectPropertiesProxy, XValueNode node, XValuePlace place) {
        if (objectPropertiesProxy.getHasRefresh()) {
            DotNetValue.addFullValueEvaluator$default(this, objectPropertiesProxy, node, place, "Refresh", false, false, 32, null);
        } else if (objectPropertiesProxy.isString() && !objectPropertiesProxy.isNull()) {
            this.addFullValueEvaluator(objectPropertiesProxy, node, place, "View", true, false);
        }
    }

    private final Icon getIcon(ObjectPropertiesProxy properties) {
        if (properties.isGroup()) {
            Icon icon = AllIcons.Nodes.Folder;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Nodes.Folder");
            return icon;
        }
        if (properties.isArray()) {
            Icon icon = AllIcons.Debugger.Db_array;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Debugger.Db_array");
            return icon;
        }
        if (properties.isPrimitive()) {
            Icon icon = AllIcons.Debugger.Db_primitive;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.Debugger.Db_primitive");
            return icon;
        }
        if (properties.isError()) {
            Icon icon = AllIcons.General.BalloonWarning;
            Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"AllIcons.General.BalloonWarning");
            return icon;
        }
        Icon mainIcon = AllIcons.Debugger.Value;
        if (properties.isStatic()) {
            mainIcon = (Icon)new LayeredIcon(new Icon[]{mainIcon, AllIcons.Nodes.StaticMark});
        }
        Icon icon = mainIcon;
        Intrinsics.checkExpressionValueIsNotNull((Object)icon, (String)"mainIcon");
        return icon;
    }

    private final void addFullValueEvaluator(ObjectPropertiesProxy objectPropertiesProxy, XValueNode node, XValuePlace place, String name, boolean showPopup2, boolean shouldUpdatePresentation) {
        XFullValueEvaluator evaluator2 = new XFullValueEvaluator(this, objectPropertiesProxy, shouldUpdatePresentation, node, place, name, name){
            final /* synthetic */ DotNetValue this$0;
            final /* synthetic */ ObjectPropertiesProxy $objectPropertiesProxy;
            final /* synthetic */ boolean $shouldUpdatePresentation;
            final /* synthetic */ XValueNode $node;
            final /* synthetic */ XValuePlace $place;
            final /* synthetic */ String $name;

            public void startEvaluation(@NotNull XFullValueEvaluator.XFullValueEvaluationCallback callback) {
                Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
                this.this$0.getFrame().getContext().getRefreshValue().start(new RefreshValueArg(this.this$0.getObjectProxy().getId()), SynchronousScheduler.INSTANCE).getResult().advise(this.this$0.getLifetime(), (Function1<RdTaskResult<RefreshValueResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends RefreshValueResult>, Unit>(this, callback){
                    final /* synthetic */ addFullValueEvaluator.evaluator.1 this$0;
                    final /* synthetic */ XFullValueEvaluator.XFullValueEvaluationCallback $callback;

                    public final void invoke(@NotNull RdTaskResult<RefreshValueResult> it) {
                        Intrinsics.checkParameterIsNotNull(it, (String)"it");
                        RdTaskResult<RefreshValueResult> rdTaskResult = it;
                        if (rdTaskResult instanceof RdTaskResult.Success) {
                            RefreshValueResult result2 = (RefreshValueResult)((RdTaskResult.Success)it).getValue();
                            if (this.this$0.$objectPropertiesProxy.getObjectId() != result2.getValueId()) {
                                return;
                            }
                            this.this$0.this$0.setObjectProxy(result2.getValue());
                            Object object = this.this$0.this$0.getObjectProxy().getProperties();
                            if (object == null || (object = ((ObjectPropertiesProxy)object).getValue()) == null) {
                                object = "";
                            }
                            Object value2 = object;
                            this.$callback.evaluated((String)value2);
                            if (this.this$0.$shouldUpdatePresentation) {
                                this.this$0.this$0.computePresentation(this.this$0.$node, this.this$0.$place);
                            }
                        } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                            String string2 = ((RdTaskResult.Fault)it).getError().getMessage();
                            if (string2 == null) {
                                string2 = "";
                            }
                            this.$callback.errorOccurred(string2);
                        } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                            this.$callback.errorOccurred("Request was cancelled");
                        }
                    }
                    {
                        this.this$0 = var1_1;
                        this.$callback = xFullValueEvaluationCallback;
                        super(1);
                    }
                }));
            }
            {
                this.this$0 = $outer;
                this.$objectPropertiesProxy = $captured_local_variable$1;
                this.$shouldUpdatePresentation = $captured_local_variable$2;
                this.$node = $captured_local_variable$3;
                this.$place = $captured_local_variable$4;
                this.$name = $captured_local_variable$5;
                super($super_call_param$6);
            }
        };
        evaluator2.setShowValuePopup(showPopup2);
        node.setFullValueEvaluator(evaluator2);
    }

    static /* bridge */ /* synthetic */ void addFullValueEvaluator$default(DotNetValue dotNetValue, ObjectPropertiesProxy objectPropertiesProxy, XValueNode xValueNode, XValuePlace xValuePlace, String string2, boolean bl, boolean bl2, int n2, Object object) {
        if ((n2 & 0x20) != 0) {
            bl2 = true;
        }
        dotNetValue.addFullValueEvaluator(objectPropertiesProxy, xValueNode, xValuePlace, string2, bl, bl2);
    }

    public void computeChildren(@NotNull XCompositeNode node) {
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        if (this.lifetime.isTerminated()) {
            node.setErrorMessage("Value is not valid");
            return;
        }
        this.frame.getContext().getComputeValueChildren().start(new ComputeValueChildrenArg(this.objectProxy.getId()), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<ComputeValueChildrenResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends ComputeValueChildrenResult>, Unit>(this, node){
            final /* synthetic */ DotNetValue this$0;
            final /* synthetic */ XCompositeNode $node;

            public final void invoke(@NotNull RdTaskResult<ComputeValueChildrenResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ComputeValueChildrenResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    ComputeValueChildrenResult result2 = (ComputeValueChildrenResult)((RdTaskResult.Success)it).getValue();
                    if (result2.getValueId() != this.this$0.getObjectProxy().getId()) {
                        return;
                    }
                    XValueChildrenList childrenList = new XValueChildrenList();
                    for (ObjectProxy value2 : result2.getChildren()) {
                        childrenList.add((XNamedValue)new DotNetNamedValue(value2.getName(), value2, this.this$0.getFrame(), false, this.this$0.getLifetime()));
                    }
                    this.$node.addChildren(childrenList, true);
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    String string2 = ((RdTaskResult.Fault)it).getError().getMessage();
                    if (string2 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$node.setErrorMessage(string2);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    this.$node.setErrorMessage("Computation cancelled");
                }
            }
            {
                this.this$0 = dotNetValue;
                this.$node = xCompositeNode;
                super(1);
            }
        }));
    }

    @NotNull
    public final DotNetStackFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final ObjectProxy getObjectProxy() {
        return this.objectProxy;
    }

    public final void setObjectProxy(@NotNull ObjectProxy objectProxy) {
        Intrinsics.checkParameterIsNotNull((Object)objectProxy, (String)"<set-?>");
        this.objectProxy = objectProxy;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public DotNetValue(@NotNull DotNetStackFrame frame, @NotNull ObjectProxy objectProxy, @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)frame), (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)objectProxy, (String)"objectProxy");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.frame = frame;
        this.objectProxy = objectProxy;
        this.lifetime = lifetime;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DotNetValue.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DotNetValue.logger = logger;
    }

    public static final /* synthetic */ void access$updateProperties(DotNetValue $this, @NotNull XValueNode node, @NotNull ObjectPropertiesProxy objectPropertiesProxy, @NotNull XValuePlace place) {
        $this.updateProperties(node, objectPropertiesProxy, place);
    }

    public static final /* synthetic */ void access$setError(DotNetValue $this, @NotNull XValueNode node, @NotNull String error) {
        $this.setError(node, error);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/debugger/DotNetValue$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

