/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger;

import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.RunnerRegistry;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.resharper.debugger.DotNetDebugProcess;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.run.configurations.unitTesting.RiderUnitTestDebugBackendConfiguration;
import com.jetbrains.resharper.run.configurations.unitTesting.RiderUnitTestRunConfiguration;
import com.jetbrains.resharper.runtime.RiderDotNetActiveRuntimeHost;
import com.jetbrains.resharper.unitTesting.RiderUnitTestSessionConductor;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.RdUnitTestDebuggerSession;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.ISink;
import com.jetbrains.rider.util.reactive.ISinkExKt;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \f2\u00020\u00012\u00020\u0002:\u0001\fB\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/debugger/RiderUnitTestDebuggerSessionsHandler;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "riderDotNetActiveRuntimeHost", "Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/runtime/RiderDotNetActiveRuntimeHost;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "Companion", "rider"})
public final class RiderUnitTestDebuggerSessionsHandler
extends AbstractProjectComponent
implements ILifetimedComponent {
    private static final Logger logger;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    public RiderUnitTestDebuggerSessionsHandler(final @NotNull Project project2, final @NotNull RiderDotNetActiveRuntimeHost riderDotNetActiveRuntimeHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)riderDotNetActiveRuntimeHost, (String)"riderDotNetActiveRuntimeHost");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        SolutionHostExtensionsKt.getSolution(project2).getUnitTestHost().getDebugSessions().view(this.getComponentLifetime(), (Function3<Lifetime, UUID, RdUnitTestDebuggerSession, Unit>)((Function3)new Function3<Lifetime, UUID, RdUnitTestDebuggerSession, Unit>(){

            public final void invoke(final @NotNull Lifetime lt, @NotNull UUID $noName_1, final @NotNull RdUnitTestDebuggerSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)lt, (String)"lt");
                Intrinsics.checkParameterIsNotNull((Object)$noName_1, (String)"<anonymous parameter 1>");
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                String executorId = DefaultDebugExecutor.EXECUTOR_ID;
                RiderUnitTestDebugBackendConfiguration backendConfiguration = new RiderUnitTestDebugBackendConfiguration(session2, lt, riderDotNetActiveRuntimeHost);
                RunnerAndConfigurationSettings runnerAndConfigurationSettings = RiderUnitTestSessionConductor.Companion.getInstance(project2).getConfigurationSettings(session2.getSessionStartDescriptor().getSessionId());
                if (runnerAndConfigurationSettings == null) {
                    throw (Throwable)new Exception("Can't find session with id " + session2.getSessionStartDescriptor().getSessionId());
                }
                RunnerAndConfigurationSettings settings = runnerAndConfigurationSettings;
                RunConfiguration runConfiguration = settings.getConfiguration();
                if (runConfiguration == null) {
                    throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.run.configurations.unitTesting.RiderUnitTestRunConfiguration");
                }
                RiderUnitTestRunConfiguration configuration = (RiderUnitTestRunConfiguration)runConfiguration;
                configuration.setBackendConfiguration(backendConfiguration);
                ProgramRunner debugRunner = RunnerRegistry.getInstance().getRunner(executorId, (RunProfile)configuration);
                if (debugRunner == null) {
                    Companion.getLogger().error("Can't find suitable runner");
                    return;
                }
                ExecutionEnvironment env = ExecutionEnvironmentBuilder.create((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)settings).build();
                env.putUserData(RiderUnitTestRunConfiguration.Companion.getBackendMode(), (Object)true);
                ProgramRunnerUtil.executeConfigurationAsync(env, false, true, new ProgramRunner.Callback(){

                    public final void processStarted(RunContentDescriptor it) {
                        ExecutionConsole executionConsole = it.getExecutionConsole();
                        if (executionConsole != null) {
                            DotNetDebugProcess process2;
                            XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)project2);
                            XDebugSession xDebugSession = xDebuggerManager.getDebugSession(executionConsole);
                            Object object = xDebugSession != null ? xDebugSession.getDebugProcess() : null;
                            if (!(object instanceof DotNetDebugProcess)) {
                                object = null;
                            }
                            if ((process2 = (DotNetDebugProcess)((Object)object)) != null) {
                                ISinkExKt.adviseOnce((ISink)process2.getProcessId(), lt, (Function1)new Function1<Integer, Unit>(){

                                    public final void invoke(int it) {
                                        PropertyExKt.set(session2.getPid(), it);
                                    }
                                });
                            } else {
                                Companion.getLogger().warn("Can't get debug process when running host debugger session");
                            }
                        } else {
                            Companion.getLogger().warn("Can't get execution console when running host debugger session");
                        }
                    }
                });
            }
        }));
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderUnitTestDebuggerSessionsHandler.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderUnitTestDebuggerSessionsHandler.logger = logger;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/debugger/RiderUnitTestDebuggerSessionsHandler$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

