/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.actions.handlers;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.resharper.debugger.DotNetDebugProcess;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/debugger/actions/handlers/RiderSetNextStatementHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "()V", "isEnabled", "", "session", "Lcom/intellij/xdebugger/XDebugSession;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "perform", "", "rider"})
public final class RiderSetNextStatementHandler
extends XDebuggerSuspendedActionHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        if (!super.isEnabled(session2, dataContext)) return false;
        if (XDebuggerUtilImpl.getCaretPosition(session2.getProject(), dataContext) == null) return false;
        if (!(session2.getDebugProcess() instanceof DotNetDebugProcess)) return false;
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        if (xDebugProcess == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.jetbrains.resharper.debugger.DotNetDebugProcess");
        }
        if (!((DotNetDebugProcess)xDebugProcess).canSetNextStatement()) return false;
        return true;
    }

    @Override
    protected void perform(@NotNull XDebugSession session2, @NotNull DataContext dataContext) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)dataContext, (String)"dataContext");
        XDebugProcess xDebugProcess = session2.getDebugProcess();
        if (!(xDebugProcess instanceof DotNetDebugProcess)) {
            xDebugProcess = null;
        }
        DotNetDebugProcess dotNetDebugProcess = (DotNetDebugProcess)xDebugProcess;
        if (dotNetDebugProcess == null) {
            return;
        }
        DotNetDebugProcess riderDebugProcess = dotNetDebugProcess;
        XSourcePosition position = XDebuggerUtilImpl.getCaretPosition(session2.getProject(), dataContext);
        if (position != null) {
            riderDebugProcess.setNextStatement(position);
        }
    }
}

