/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.attach;

import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.intellij.xdebugger.attach.XLocalAttachDebuggerProvider;
import com.intellij.xdebugger.attach.XLocalAttachGroup;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.debugger.attach.MonoAttachGroup;
import com.jetbrains.resharper.debugger.attach.MonoLocalAttachDebugger;
import com.jetbrains.resharper.runtime.mono.MonoRuntime;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J&\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MonoAttachProvider;", "Lcom/intellij/xdebugger/attach/XLocalAttachDebuggerProvider;", "()V", "getAttachGroup", "Lcom/intellij/xdebugger/attach/XLocalAttachGroup;", "getAvailableDebuggers", "", "Lcom/intellij/xdebugger/attach/XLocalAttachDebugger;", "project", "Lcom/intellij/openapi/project/Project;", "processInfo", "Lcom/intellij/execution/process/ProcessInfo;", "contextHolder", "Lcom/intellij/openapi/util/UserDataHolder;", "Companion", "rider"})
public final class MonoAttachProvider
implements XLocalAttachDebuggerProvider {
    private static final Regex addressMatcher;
    public static final Companion Companion;

    @Override
    @NotNull
    public XLocalAttachGroup getAttachGroup() {
        return MonoAttachGroup.INSTANCE;
    }

    @Override
    @NotNull
    public List<XLocalAttachDebugger> getAvailableDebuggers(@NotNull Project project2, @NotNull ProcessInfo processInfo, @NotNull UserDataHolder contextHolder) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)processInfo, (String)"processInfo");
        Intrinsics.checkParameterIsNotNull((Object)contextHolder, (String)"contextHolder");
        if (RiderEnvironment.INSTANCE.isRiderProcess(processInfo.getPid())) {
            return CollectionsKt.emptyList();
        }
        if (!MonoRuntime.Companion.getPossibleMonoExecutables().contains(processInfo.getExecutableName())) {
            return CollectionsKt.emptyList();
        }
        Regex regex = MonoAttachProvider.Companion.getAddressMatcher();
        String string2 = processInfo.getCommandLine();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"processInfo.commandLine");
        MatchResult matchResult = Regex.find$default((Regex)regex, (CharSequence)string2, (int)0, (int)2, null);
        if (matchResult == null) {
            return CollectionsKt.emptyList();
        }
        MatchResult matchResult2 = matchResult;
        Collection collection = matchResult2.getGroupValues();
        if (collection.size() < 3) {
            return CollectionsKt.emptyList();
        }
        String host = (String)matchResult2.getGroupValues().get(1);
        String portString = (String)matchResult2.getGroupValues().get(2);
        try {
            String string3 = portString;
            int port = Integer.parseInt(string3);
            return CollectionsKt.arrayListOf((Object[])new MonoLocalAttachDebugger[]{new MonoLocalAttachDebugger(host, port)});
        }
        catch (NumberFormatException e2) {
            return CollectionsKt.emptyList();
        }
    }

    static {
        Companion = new Companion(null);
        addressMatcher = new Regex("address=([\\d.\\w]+):(\\d+)", RegexOption.IGNORE_CASE);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MonoAttachProvider$Companion;", "", "()V", "addressMatcher", "Lkotlin/text/Regex;", "getAddressMatcher", "()Lkotlin/text/Regex;", "rider"})
    public static final class Companion {
        private final Regex getAddressMatcher() {
            return addressMatcher;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

