/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.attach;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ConcurrentList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost;
import com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost$calculateProcesses$;
import com.jetbrains.resharper.util.concurrent.SyncEvent;
import com.jetbrains.resharper.util.idea.ILifetimedDisposableApplicationComponent;
import com.jetbrains.resharper.util.idea.LifetimedDisposableApplicationComponent;
import com.jetbrains.resharper.utils.RiderProcessUtil;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.Identities;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.Serializers;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.framework.WireExKt;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.CalculateProcessesResult;
import com.jetbrains.rider.model.MsClrProcessEnumeratorModel;
import com.jetbrains.rider.model.PlatformKind;
import com.jetbrains.rider.model.RdProcessInfo;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.lifetime.LifetimeExKt;
import com.jetbrains.rider.util.threading.SingleThreadScheduler;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 #2\u00020\u00012\u00020\u0002:\u0002#$B\u0005\u00a2\u0006\u0002\u0010\u0003J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\t\u0010\u0017\u001a\u00020\u0018H\u0096\u0001J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\b\u0010 \u001a\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\u0018H\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002R\u0012\u0010\u0004\u001a\u00020\u0005X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R/\u0010\b\u001a#\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost;", "Lcom/intellij/openapi/components/ApplicationComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedDisposableApplicationComponent;", "()V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "enumerators", "Ljava/util/concurrent/ConcurrentMap;", "Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost$Companion$EnumeratorWorkerType;", "kotlin.jvm.PlatformType", "Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost$ProcessEnumeratorEntry;", "Lorg/jetbrains/annotations/NotNull;", "initialized", "", "lock", "", "scheduler", "Lcom/jetbrains/rider/util/threading/SingleThreadScheduler;", "calculateProcesses", "", "Lcom/jetbrains/rider/model/RdProcessInfo;", "dispose", "", "disposeComponent", "doRunWorker", "workerType", "leftAttempts", "", "getComponentName", "", "initComponent", "runProcesses", "runWorker", "Companion", "ProcessEnumeratorEntry", "rider"})
public final class MsClrAttachableProcessesHost
implements ApplicationComponent,
ILifetimedDisposableApplicationComponent {
    private final SingleThreadScheduler scheduler;
    private final ConcurrentMap<Companion.EnumeratorWorkerType, ProcessEnumeratorEntry> enumerators;
    private boolean initialized;
    private final Object lock;
    public static final int enumeratorExitCodeOnParentProcessDeath = 239;
    private static final Logger logger;
    public static final long timeout = 10000L;
    public static final int maxRunAttempts = 3;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedDisposableApplicationComponent $$delegate_0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<RdProcessInfo> calculateProcesses() {
        Object object = this.lock;
        synchronized (object) {
            ProcessEnumeratorEntry[] entries;
            block9: {
                Collection $receiver$iv;
                if (!this.initialized) {
                    this.runProcesses();
                    this.initialized = true;
                }
                Collection collection = $receiver$iv = this.enumerators.values();
                if (collection == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                }
                Collection thisCollection$iv = collection;
                ProcessEnumeratorEntry[] processEnumeratorEntryArray = thisCollection$iv.toArray(new ProcessEnumeratorEntry[thisCollection$iv.size()]);
                if (processEnumeratorEntryArray == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                }
                entries = (ProcessEnumeratorEntry[])((Object[])processEnumeratorEntryArray);
                if (!this.enumerators.isEmpty()) break block9;
                List list2 = CollectionsKt.emptyList();
                return list2;
            }
            Semaphore semaphore = new Semaphore(0);
            ConcurrentList result2 = ContainerUtil.createConcurrentList();
            for (int i2 = 0; i2 < entries.length; ++i2) {
                ProcessEnumeratorEntry entry = entries[i2];
                this.scheduler.invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(entry, result2, semaphore, this){
                    final /* synthetic */ ProcessEnumeratorEntry $entry;
                    final /* synthetic */ ConcurrentList $result;
                    final /* synthetic */ Semaphore $semaphore;
                    final /* synthetic */ MsClrAttachableProcessesHost this$0;
                    {
                        this.$entry = processEnumeratorEntry;
                        this.$result = concurrentList;
                        this.$semaphore = semaphore;
                        this.this$0 = msClrAttachableProcessesHost;
                        super(0);
                    }

                    public final void invoke() {
                        this.$entry.getModel().getCalculateProcesses().start(true, MsClrAttachableProcessesHost.access$getScheduler$p(this.this$0)).getResult().advise(this.this$0.getComponentLifetime(), (Function1<RdTaskResult<CalculateProcessesResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends CalculateProcessesResult>, Unit>(this){
                            final /* synthetic */ calculateProcesses$$inlined$synchronized$lambda$1 this$0;
                            {
                                this.this$0 = var1_1;
                                super(1);
                            }

                            public final void invoke(RdTaskResult<CalculateProcessesResult> it) {
                                RdTaskResult<CalculateProcessesResult> rdTaskResult = it;
                                if (rdTaskResult instanceof RdTaskResult.Success) {
                                    this.this$0.$result.addAll((Collection)((CalculateProcessesResult)((RdTaskResult.Success)it).getValue()).getProcesses());
                                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                                    com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost$Companion.access$getLogger$p(MsClrAttachableProcessesHost.Companion).error("Error enumerating processes on worker", ((RdTaskResult.Fault)it).getError());
                                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                                    com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost$Companion.access$getLogger$p(MsClrAttachableProcessesHost.Companion).trace("Enumeration cancelled");
                                }
                                this.this$0.$semaphore.release();
                            }
                        }));
                    }
                }));
            }
            if (!semaphore.tryAcquire(((Object[])entries).length, 10000L, TimeUnit.MILLISECONDS)) {
                MsClrAttachableProcessesHost.Companion.getLogger().error("Unable to get whole Ms CLR process list within " + 10000L + " ms");
            }
            ConcurrentList concurrentList = result2;
            Intrinsics.checkExpressionValueIsNotNull((Object)concurrentList, (String)"result");
            List list3 = MsClrAttachableProcessesHost.Companion.merge((List)concurrentList);
            return list3;
        }
    }

    private final void runProcesses() {
        if (!SystemInfo.isWindows) {
            return;
        }
        SyncEvent syncEvent = new SyncEvent();
        this.scheduler.invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this, syncEvent){
            final /* synthetic */ MsClrAttachableProcessesHost this$0;
            final /* synthetic */ SyncEvent $syncEvent;

            public final void invoke() {
                MsClrAttachableProcessesHost.access$runWorker(this.this$0, Companion.EnumeratorWorkerType.WorkerX86, 3);
                if (RiderEnvironment.INSTANCE.is64BitWindows()) {
                    MsClrAttachableProcessesHost.access$runWorker(this.this$0, Companion.EnumeratorWorkerType.WorkerX64, 3);
                }
                this.$syncEvent.set();
            }
            {
                this.this$0 = msClrAttachableProcessesHost;
                this.$syncEvent = syncEvent;
                super(0);
            }
        }));
        SyncEvent.wait$default(syncEvent, 0L, 1, null);
    }

    private final void runWorker(Companion.EnumeratorWorkerType workerType, int leftAttempts) {
        try {
            this.doRunWorker(workerType, leftAttempts);
        }
        catch (Throwable t2) {
            MsClrAttachableProcessesHost.Companion.getLogger().error("Error while starting " + (Object)((Object)workerType), t2);
        }
    }

    private final void doRunWorker(Companion.EnumeratorWorkerType workerType, int leftAttempts) {
        LifetimeDefinition processLifetimeDefinition = Lifetime.Companion.create(Lifetime.Companion.getEternal());
        Protocol protocol2 = new Protocol(new Serializers(), new Identities(null, 1, null), this.scheduler, (Function1<? super Protocol, ? extends IWire>)((Function1)new Function1<Protocol, SocketWire.Server>(processLifetimeDefinition, workerType){
            final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;
            final /* synthetic */ Companion.EnumeratorWorkerType $workerType;

            @NotNull
            public final SocketWire.Server invoke(@NotNull Protocol it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return new SocketWire.Server(this.$processLifetimeDefinition.getLifetime(), it, null, "FrontendToProcessEnumerator." + (Object)((Object)this.$workerType));
            }
            {
                this.$processLifetimeDefinition = lifetimeDefinition;
                this.$workerType = enumeratorWorkerType;
                super(1);
            }
        }));
        GeneralCommandLine cmd = RiderEnvironment.INSTANCE.createRunCmdForBundledAssembly(workerType.getAssemblyName(), String.valueOf(WireExKt.getServerPort(protocol2.getWire())));
        ProcessBuilder processBuilder = new ProcessBuilder(cmd.getCommandLineList(null));
        File workerLogDir = new File(RiderEnvironment.INSTANCE.getLogDirectory(), "MsClrProcessEnumeratorWorker");
        workerLogDir.mkdirs();
        SimpleDateFormat format = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss");
        String currentTimeString = format.format(new Date());
        processBuilder.redirectError(ProcessBuilder.Redirect.to(new File(workerLogDir, workerType.getAssemblyName() + "_" + currentTimeString + ".err")));
        processBuilder.redirectOutput(ProcessBuilder.Redirect.to(new File(workerLogDir, workerType.getAssemblyName() + "_" + currentTimeString + ".out")));
        processBuilder.environment().clear();
        Map<String, String> map2 = processBuilder.environment();
        Map map3 = EnvironmentUtil.getEnvironmentMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"EnvironmentUtil.getEnvironmentMap()");
        map2.putAll(map3);
        processBuilder.environment().put("LOG_DIR", workerLogDir.getAbsolutePath());
        processBuilder.environment().put("ENUMERATOR_PARENT_PROCESS_PID", String.valueOf(RiderProcessUtil.INSTANCE.getCurrentPid()));
        OSProcessHandler processHandler2 = new OSProcessHandler(processBuilder.start(), cmd.getCommandLineString());
        processHandler2.addProcessListener((ProcessListener)new ProcessAdapter(this, workerType, leftAttempts){
            final /* synthetic */ MsClrAttachableProcessesHost this$0;
            final /* synthetic */ Companion.EnumeratorWorkerType $workerType;
            final /* synthetic */ int $leftAttempts;

            public void processTerminated(@NotNull ProcessEvent event) {
                Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                MsClrAttachableProcessesHost.access$getEnumerators$p(this.this$0).remove((Object)((Object)this.$workerType));
                if (event.getExitCode() != 239) {
                    com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost$Companion.access$getLogger$p(MsClrAttachableProcessesHost.Companion).warn(this.$workerType.getAssemblyName() + " was unexpectedly exited with code " + event.getExitCode() + ". Restart attempts left: " + this.$leftAttempts);
                    if (this.$leftAttempts > 0 && LifetimeExKt.isAlive(this.this$0.getComponentLifetime())) {
                        MsClrAttachableProcessesHost.access$getScheduler$p(this.this$0).invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ doRunWorker.1 this$0;

                            public final void invoke() {
                                com.jetbrains.resharper.debugger.attach.MsClrAttachableProcessesHost$Companion.access$getLogger$p(MsClrAttachableProcessesHost.Companion).warn("Restarting " + this.this$0.$workerType.getAssemblyName());
                                MsClrAttachableProcessesHost.access$runWorker(this.this$0.this$0, this.this$0.$workerType, this.this$0.$leftAttempts - 1);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                }
            }
            {
                this.this$0 = $outer;
                this.$workerType = $captured_local_variable$1;
                this.$leftAttempts = $captured_local_variable$2;
            }
        });
        RiderEnvironment.INSTANCE.addRiderProcess((BaseOSProcessHandler)processHandler2);
        processHandler2.startNotify();
        MsClrProcessEnumeratorModel model2 = MsClrProcessEnumeratorModel.Companion.create(processLifetimeDefinition.getLifetime(), protocol2);
        Map map4 = this.enumerators;
        ProcessEnumeratorEntry processEnumeratorEntry = new ProcessEnumeratorEntry(processHandler2, model2);
        map4.put(workerType, processEnumeratorEntry);
    }

    @NotNull
    public String getComponentName() {
        String string2 = this.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaClass.name");
        return string2;
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public MsClrAttachableProcessesHost() {
        this.$$delegate_0 = new LifetimedDisposableApplicationComponent();
        Lifetime lifetime = this.getComponentLifetime();
        String string2 = this.getClass().getName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"javaClass.name");
        this.scheduler = new SingleThreadScheduler(lifetime, string2);
        this.enumerators = ContainerUtil.newConcurrentMap();
        this.lock = new Object();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(MsClrAttachableProcessesHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        MsClrAttachableProcessesHost.logger = logger;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public void dispose() {
        this.$$delegate_0.dispose();
    }

    @NotNull
    public static final /* synthetic */ SingleThreadScheduler access$getScheduler$p(MsClrAttachableProcessesHost $this) {
        return $this.scheduler;
    }

    public static final /* synthetic */ void access$runWorker(MsClrAttachableProcessesHost $this, @NotNull Companion.EnumeratorWorkerType workerType, int leftAttempts) {
        $this.runWorker(workerType, leftAttempts);
    }

    @NotNull
    public static final /* synthetic */ ConcurrentMap access$getEnumerators$p(MsClrAttachableProcessesHost $this) {
        return $this.enumerators;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost$ProcessEnumeratorEntry;", "", "processHandler", "Lcom/intellij/execution/process/OSProcessHandler;", "model", "Lcom/jetbrains/rider/model/MsClrProcessEnumeratorModel;", "(Lcom/intellij/execution/process/OSProcessHandler;Lcom/jetbrains/rider/model/MsClrProcessEnumeratorModel;)V", "getModel", "()Lcom/jetbrains/rider/model/MsClrProcessEnumeratorModel;", "getProcessHandler", "()Lcom/intellij/execution/process/OSProcessHandler;", "rider"})
    private static final class ProcessEnumeratorEntry {
        @NotNull
        private final OSProcessHandler processHandler;
        @NotNull
        private final MsClrProcessEnumeratorModel model;

        @NotNull
        public final OSProcessHandler getProcessHandler() {
            return this.processHandler;
        }

        @NotNull
        public final MsClrProcessEnumeratorModel getModel() {
            return this.model;
        }

        public ProcessEnumeratorEntry(@NotNull OSProcessHandler processHandler2, @NotNull MsClrProcessEnumeratorModel model2) {
            Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
            Intrinsics.checkParameterIsNotNull((Object)model2, (String)"model");
            this.processHandler = processHandler2;
            this.model = model2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0010B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost$Companion;", "", "()V", "enumeratorExitCodeOnParentProcessDeath", "", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "maxRunAttempts", "timeout", "", "merge", "", "Lcom/jetbrains/rider/model/RdProcessInfo;", "rdProcesses", "EnumeratorWorkerType", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        /*
         * WARNING - void declaration
         */
        private final List<RdProcessInfo> merge(List<RdProcessInfo> rdProcesses) {
            HashMap map2 = new HashMap();
            for (RdProcessInfo rdProcess : rdProcesses) {
                void mainWindowTitle;
                void name;
                void id;
                List loadedRuntimes;
                PlatformKind platform;
                Object object;
                Object object2;
                if (!map2.containsKey(rdProcess.getId())) {
                    Map map3 = map2;
                    object2 = rdProcess.getId();
                    object = rdProcess;
                    map3.put(object2, object);
                    continue;
                }
                Object v2 = map2.get(rdProcess.getId());
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                RdProcessInfo rdProcessInfo = (RdProcessInfo)v2;
                int n2 = rdProcessInfo.component1();
                object2 = rdProcessInfo.component2();
                object = rdProcessInfo.component3();
                String string2 = rdProcessInfo.component4();
                List<String> list2 = rdProcessInfo.component5();
                rdProcessInfo = null;
                if (Intrinsics.areEqual((Object)((Object)platform), (Object)((Object)PlatformKind.Unknown))) {
                    platform = rdProcess.getPlatform();
                }
                if (CollectionsKt.any((Iterable)rdProcess.getLoadedRuntimes())) {
                    Collection thisCollection$iv;
                    Collection $receiver$iv = loadedRuntimes;
                    if ($receiver$iv == null) {
                        throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
                    }
                    String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
                    if (stringArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    String[] stringArray2 = (String[])((Object[])stringArray);
                    List unifiedRuntimes = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(stringArray2, stringArray2.length));
                    unifiedRuntimes.addAll((Collection)rdProcess.getLoadedRuntimes());
                    loadedRuntimes = unifiedRuntimes;
                }
                RdProcessInfo newRdProcessInfo = new RdProcessInfo((int)id, (String)name, platform, (String)mainWindowTitle, loadedRuntimes);
                Map map4 = map2;
                Integer n3 = (int)id;
                RdProcessInfo rdProcessInfo2 = newRdProcessInfo;
                map4.put(n3, rdProcessInfo2);
            }
            return CollectionsKt.toList((Iterable)map2.values());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/debugger/attach/MsClrAttachableProcessesHost$Companion$EnumeratorWorkerType;", "", "assemblyName", "", "(Ljava/lang/String;ILjava/lang/String;)V", "getAssemblyName", "()Ljava/lang/String;", "WorkerX86", "WorkerX64", "rider"})
        public static final class EnumeratorWorkerType
        extends Enum<EnumeratorWorkerType> {
            public static final /* enum */ EnumeratorWorkerType WorkerX86;
            public static final /* enum */ EnumeratorWorkerType WorkerX64;
            private static final /* synthetic */ EnumeratorWorkerType[] $VALUES;
            @NotNull
            private final String assemblyName;

            static {
                EnumeratorWorkerType[] enumeratorWorkerTypeArray = new EnumeratorWorkerType[2];
                EnumeratorWorkerType[] enumeratorWorkerTypeArray2 = enumeratorWorkerTypeArray;
                enumeratorWorkerTypeArray[0] = WorkerX86 = new EnumeratorWorkerType("JetBrains.Platform.MsClrProcessEnumerator.Worker32.exe");
                enumeratorWorkerTypeArray[1] = WorkerX64 = new EnumeratorWorkerType("JetBrains.Platform.MsClrProcessEnumerator.Worker64.exe");
                $VALUES = enumeratorWorkerTypeArray;
            }

            @NotNull
            public final String getAssemblyName() {
                return this.assemblyName;
            }

            protected EnumeratorWorkerType(String assemblyName) {
                Intrinsics.checkParameterIsNotNull((Object)assemblyName, (String)"assemblyName");
                this.assemblyName = assemblyName;
            }

            public static EnumeratorWorkerType[] values() {
                return (EnumeratorWorkerType[])$VALUES.clone();
            }

            public static EnumeratorWorkerType valueOf(String string2) {
                return Enum.valueOf(EnumeratorWorkerType.class, string2);
            }
        }
    }
}

