/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.breakpoint;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.jetbrains.resharper.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.resharper.debugger.breakpoint.DotNetBreakpointProperties;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class DotNetBreakpointFiltersPanel<T extends DotNetBreakpointProperties, B extends XBreakpoint<T>>
extends XBreakpointCustomPropertiesPanel<B> {
    private JCheckBox myHitCountCheckbox;
    private JTextField myHitCountTextField;
    private JPanel myConditionsPanel;
    private JComboBox myHitCountMode;

    public DotNetBreakpointFiltersPanel() {
        this.$$$setupUI$$$();
        DebuggerUIUtil.focusEditorOnCheck(this.myHitCountCheckbox, this.myHitCountTextField);
        ActionListener updateListener = e2 -> this.updateCheckboxes();
        this.myHitCountCheckbox.addActionListener(updateListener);
        this.myHitCountMode.setModel(new DefaultComboBoxModel<BreakpointHitCountMode>(BreakpointHitCountMode.values()));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myConditionsPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointFiltersPanel", "getComponent"));
        }
        return jPanel;
    }

    public void saveTo(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointFiltersPanel", "saveTo"));
        }
        DotNetBreakpointProperties properties = (DotNetBreakpointProperties)breakpoint.getProperties();
        if (properties == null) {
            return;
        }
        boolean changed = false;
        try {
            int filter2;
            String text2 = this.myHitCountTextField.getText().trim();
            int n2 = filter2 = !text2.isEmpty() ? Integer.parseInt(text2) : 0;
            if (filter2 < 0) {
                filter2 = 0;
            }
            changed = properties.getHitCountFilterEnabled() != this.myHitCountCheckbox.isSelected() || properties.getHitCount() != filter2 || properties.getHitCountMode() != this.myHitCountMode.getSelectedItem();
            properties.setHitCount(filter2);
            properties.setHitCountFilterEnabled(this.myHitCountCheckbox.isSelected());
            properties.setHitCountMode((BreakpointHitCountMode)((Object)this.myHitCountMode.getSelectedItem()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (changed) {
            ((XBreakpointBase)breakpoint).fireBreakpointChanged();
        }
    }

    public void loadFrom(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointFiltersPanel", "loadFrom"));
        }
        DotNetBreakpointProperties properties = (DotNetBreakpointProperties)breakpoint.getProperties();
        if (properties != null) {
            if (properties.getHitCount() > 0) {
                this.myHitCountTextField.setText(Integer.toString(properties.getHitCount()));
            } else {
                this.myHitCountTextField.setText("");
            }
            this.myHitCountCheckbox.setSelected(properties.getHitCountFilterEnabled());
            this.myHitCountMode.setSelectedItem((Object)properties.getHitCountMode());
        }
        this.updateCheckboxes();
    }

    public boolean isVisibleOnPopup(@NotNull B breakpoint) {
        if (breakpoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakpoint", "com/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointFiltersPanel", "isVisibleOnPopup"));
        }
        DotNetBreakpointProperties properties = (DotNetBreakpointProperties)breakpoint.getProperties();
        return properties != null && properties.getHitCountFilterEnabled();
    }

    private void updateCheckboxes() {
        this.myHitCountTextField.setEditable(this.myHitCountCheckbox.isSelected());
        this.myHitCountTextField.setEnabled(this.myHitCountCheckbox.isSelected());
        this.myHitCountMode.setEnabled(this.myHitCountCheckbox.isSelected());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.myConditionsPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHitCountCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Hit count:");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myHitCountMode = jComboBox = new JComboBox();
        jComboBox.setToolTipText("Hit count mode");
        jPanel.add(jComboBox, new GridConstraints(1, 0, 1, 2, 8, 1, 2, 0, null, null, null));
        this.myHitCountTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(2, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myConditionsPanel;
    }
}

