/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.breakpoint;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.jetbrains.resharper.debugger.breakpoint.BreakpointHitCountMode;
import com.jetbrains.resharper.debugger.breakpoint.DotNetBreakpointProperties;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B=\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fB#\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0013\u001a\u00020\u0000H\u0016J\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0000H\u0016R\u0012\u0010\u000e\u001a\u00020\u00038\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00058\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointProperties;", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetBreakpointProperties;", "documentPath", "", "startOffset", "", "endOffset", "hitCountFilterEnabled", "", "hitCount", "hitCountMode", "Lcom/jetbrains/resharper/debugger/breakpoint/BreakpointHitCountMode;", "(Ljava/lang/String;IIZILcom/jetbrains/resharper/debugger/breakpoint/BreakpointHitCountMode;)V", "(ZILcom/jetbrains/resharper/debugger/breakpoint/BreakpointHitCountMode;)V", "initialDocumentPath", "initialEndOffset", "initialStartOffset", "rangeMarker", "Lcom/intellij/openapi/editor/RangeMarker;", "getState", "getTextRange", "Lcom/intellij/openapi/util/TextRange;", "loadState", "", "state", "rider"})
public final class DotNetLineBreakpointProperties
extends DotNetBreakpointProperties<DotNetLineBreakpointProperties> {
    private RangeMarker rangeMarker;
    @Attribute(value="startOffset")
    private int initialStartOffset;
    @Attribute(value="endOffset")
    private int initialEndOffset;
    @Attribute(value="documentPath")
    private String initialDocumentPath;

    @Override
    public void loadState(@NotNull DotNetLineBreakpointProperties state) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)state), (String)"state");
        super.loadState((XBreakpointProperties)state);
        this.initialStartOffset = state.initialStartOffset;
        this.initialEndOffset = state.initialEndOffset;
        this.initialDocumentPath = state.initialDocumentPath;
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(this.initialDocumentPath), (boolean)true);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        int n2 = this.initialStartOffset;
        this.rangeMarker = 0 <= n2 && n2 <= this.initialEndOffset - 1 && this.initialEndOffset <= document2.getTextLength() ? document2.createRangeMarker(this.initialStartOffset, this.initialEndOffset) : null;
    }

    @Override
    @NotNull
    public DotNetLineBreakpointProperties getState() {
        if (this.rangeMarker == null) {
            return new DotNetLineBreakpointProperties(false, 0, null, 7, null);
        }
        if (this.rangeMarker != null) {
            RangeMarker rangeMarker = this.rangeMarker;
            if (rangeMarker == null) {
                Intrinsics.throwNpe();
            }
            int n2 = rangeMarker.getStartOffset();
            RangeMarker rangeMarker2 = this.rangeMarker;
            if (rangeMarker2 == null) {
                Intrinsics.throwNpe();
            }
            return new DotNetLineBreakpointProperties(this.initialDocumentPath, n2, rangeMarker2.getEndOffset(), this.getHitCountFilterEnabled(), this.getHitCount(), this.getHitCountMode());
        }
        return new DotNetLineBreakpointProperties(false, 0, null, 7, null);
    }

    @NotNull
    public final TextRange getTextRange() {
        if (this.rangeMarker != null) {
            RangeMarker rangeMarker = this.rangeMarker;
            if (rangeMarker == null) {
                Intrinsics.throwNpe();
            }
            int n2 = rangeMarker.getStartOffset();
            RangeMarker rangeMarker2 = this.rangeMarker;
            if (rangeMarker2 == null) {
                Intrinsics.throwNpe();
            }
            return new TextRange(n2, rangeMarker2.getEndOffset());
        }
        TextRange textRange = TextRange.EMPTY_RANGE;
        Intrinsics.checkExpressionValueIsNotNull((Object)textRange, (String)"TextRange.EMPTY_RANGE");
        return textRange;
    }

    public DotNetLineBreakpointProperties(boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)hitCountMode), (String)"hitCountMode");
        super(hitCountFilterEnabled, hitCount, hitCountMode);
        this.initialStartOffset = -1;
        this.initialEndOffset = -1;
        this.initialDocumentPath = "";
    }

    public /* synthetic */ DotNetLineBreakpointProperties(boolean bl, int n2, BreakpointHitCountMode breakpointHitCountMode, int n3, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n3 & 1) != 0) {
            bl = false;
        }
        if ((n3 & 2) != 0) {
            n2 = 0;
        }
        if ((n3 & 4) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        this(bl, n2, breakpointHitCountMode);
    }

    public DotNetLineBreakpointProperties() {
        this(false, 0, null, 7, null);
    }

    public DotNetLineBreakpointProperties(@NotNull String documentPath, int startOffset, int endOffset, boolean hitCountFilterEnabled, int hitCount, @NotNull BreakpointHitCountMode hitCountMode) {
        Intrinsics.checkParameterIsNotNull((Object)documentPath, (String)"documentPath");
        Intrinsics.checkParameterIsNotNull((Object)((Object)hitCountMode), (String)"hitCountMode");
        this(hitCountFilterEnabled, hitCount, hitCountMode);
        this.initialStartOffset = startOffset;
        this.initialEndOffset = endOffset;
        this.initialDocumentPath = documentPath;
        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(documentPath), (boolean)true);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile2);
        if (document == null) {
            return;
        }
        Document document2 = document;
        int n2 = this.initialStartOffset;
        this.rangeMarker = 0 <= n2 && n2 <= this.initialEndOffset - 1 && this.initialEndOffset <= document2.getTextLength() ? document2.createRangeMarker(this.initialStartOffset, this.initialEndOffset) : null;
    }

    public /* synthetic */ DotNetLineBreakpointProperties(String string2, int n2, int n3, boolean bl, int n4, BreakpointHitCountMode breakpointHitCountMode, int n5, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n5 & 8) != 0) {
            bl = false;
        }
        if ((n5 & 0x10) != 0) {
            n4 = 0;
        }
        if ((n5 & 0x20) != 0) {
            breakpointHitCountMode = BreakpointHitCountMode.LessThan;
        }
        this(string2, n2, n3, bl, n4, breakpointHitCountMode);
    }
}

