/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.breakpoint;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.resharper.debugger.DotNetDebuggerEditorsProvider;
import com.jetbrains.resharper.debugger.breakpoint.DotNetBreakpointFiltersPanel;
import com.jetbrains.resharper.debugger.breakpoint.DotNetLineBreakpointProperties;
import com.jetbrains.resharper.debugger.breakpoint.RiderBreakpointHost;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.rider.model.BreakpointVariantList;
import com.jetbrains.rider.model.BreakpointVariantModel;
import com.jetbrains.rider.model.BreakpointVariantModelBase;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\"#B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u00000\r2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J.\u0010\u0011\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u000e\u0012\f0\u0013R\b\u0012\u0004\u0012\u00020\u00020\u00010\r0\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u0010H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001e\u0010\u0016\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u0018\u0018\u00010\u00172\u0006\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u0018\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u0018H\u0016J \u0010\u001d\u001a\u0004\u0018\u00010\u001e2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u00182\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u001f\u001a\u0004\u0018\u00010 2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u0018H\u0016J\b\u0010!\u001a\u00020\tH\u0016\u00a8\u0006$"}, d2={"Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointProperties;", "()V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "computeVariants", "", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "computeVariantsAsync", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "position", "createBreakpointProperties", "createCustomRightPropertiesPanel", "Lcom/intellij/xdebugger/breakpoints/ui/XBreakpointCustomPropertiesPanel;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "createProperties", "getDisplayText", "", "breakpoint", "getEditorsProvider", "Lcom/intellij/xdebugger/evaluation/XDebuggerEditorsProvider;", "getHighlightRange", "Lcom/intellij/openapi/util/TextRange;", "getPriority", "Companion", "DotNetBreakpointVariant", "rider"})
public final class DotNetLineBreakpointType
extends XLineBreakpointType<DotNetLineBreakpointProperties> {
    @NotNull
    private static final String Id = "DotNet Breakpoints";
    @NotNull
    private static final String Title = ".NET Line Breakpoints";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public DotNetLineBreakpointProperties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document == null) {
            return new DotNetLineBreakpointProperties(false, 0, null, 7, null);
        }
        Document document2 = document;
        int startOffset = document2.getLineStartOffset(line);
        String string2 = file2.getPath();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
        return new DotNetLineBreakpointProperties(string2, startOffset, startOffset, false, 0, null, 56, null);
    }

    @NotNull
    public DotNetLineBreakpointProperties createProperties() {
        return new DotNetLineBreakpointProperties(false, 0, null, 7, null);
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint, @NotNull Project project2) {
        void $receiver$iv;
        DotNetDebuggerEditorsProvider dotNetDebuggerEditorsProvider;
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        ComponentManager componentManager = (ComponentManager)project2;
        DotNetDebuggerEditorsProvider dotNetDebuggerEditorsProvider2 = dotNetDebuggerEditorsProvider;
        DotNetDebuggerEditorsProvider dotNetDebuggerEditorsProvider3 = dotNetDebuggerEditorsProvider;
        Object object = $receiver$iv.getComponent(IconHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + IconHost.class + " not found in container " + $receiver$iv);
        }
        Object object2 = object;
        dotNetDebuggerEditorsProvider2((IconHost)object2);
        return dotNetDebuggerEditorsProvider3;
    }

    @NotNull
    public List<DotNetBreakpointVariant> computeVariants(@NotNull Project project2, @NotNull XSourcePosition sourcePosition) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
        throw (Throwable)new IllegalStateException("Should use async method");
    }

    @NotNull
    public AsyncPromise<List<XLineBreakpointType.XLineBreakpointVariant>> computeVariantsAsync(@NotNull Project project2, @NotNull XSourcePosition position) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        ComponentManager $receiver$iv = (ComponentManager)project2;
        Object object = $receiver$iv.getComponent(RiderBreakpointHost.class);
        if (object == null) {
            throw (Throwable)new IllegalStateException("Component " + RiderBreakpointHost.class + " not found in container " + $receiver$iv);
        }
        return ((RiderBreakpointHost)object).requestVariantsComputation(position, (Function1<? super BreakpointVariantList, ? extends List<? extends XLineBreakpointType.XLineBreakpointVariant>>)((Function1)new Function1<BreakpointVariantList, List<? extends DotNetBreakpointVariant>>(this, position){
            final /* synthetic */ DotNetLineBreakpointType this$0;
            final /* synthetic */ XSourcePosition $position;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<DotNetBreakpointVariant> invoke(@NotNull BreakpointVariantList it) {
                void $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable iterable = $receiver$iv = (Iterable)it.getItems();
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                for (T element$iv$iv$iv : $receiver$iv$iv$iv) {
                    DotNetBreakpointVariant dotNetBreakpointVariant;
                    DotNetBreakpointVariant dotNetBreakpointVariant2;
                    T element$iv$iv = element$iv$iv$iv;
                    BreakpointVariantModelBase it2 = (BreakpointVariantModelBase)element$iv$iv;
                    BreakpointVariantModelBase breakpointVariantModelBase = it2;
                    if (!(breakpointVariantModelBase instanceof BreakpointVariantModel)) {
                        breakpointVariantModelBase = null;
                    }
                    if ((BreakpointVariantModel)breakpointVariantModelBase == null) {
                        dotNetBreakpointVariant2 = null;
                    } else {
                        String string2 = ((BreakpointVariantModel)it2).getText();
                        TextRange textRange = new TextRange(((BreakpointVariantModel)it2).getStartOffset(), ((BreakpointVariantModel)it2).getEndOffset());
                        VirtualFile virtualFile = this.$position.getFile();
                        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"position.file");
                        dotNetBreakpointVariant2 = this.this$0.new DotNetBreakpointVariant(string2, textRange, virtualFile);
                    }
                    if (dotNetBreakpointVariant2 == null) continue;
                    DotNetBreakpointVariant it$iv$iv = dotNetBreakpointVariant = dotNetBreakpointVariant2;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
            {
                this.this$0 = dotNetLineBreakpointType;
                this.$position = xSourcePosition;
                super(1);
            }
        }));
    }

    @Nullable
    public TextRange getHighlightRange(@NotNull XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        Intrinsics.checkParameterIsNotNull(breakpoint, (String)"breakpoint");
        TextRange textRange = ((DotNetLineBreakpointProperties)breakpoint.getProperties()).getTextRange();
        if (Intrinsics.areEqual((Object)textRange, (Object)TextRange.EMPTY_RANGE) ^ true) {
            return textRange;
        }
        return null;
    }

    @Nullable
    public XBreakpointCustomPropertiesPanel<XLineBreakpoint<DotNetLineBreakpointProperties>> createCustomRightPropertiesPanel(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        return new DotNetBreakpointFiltersPanel();
    }

    public int getPriority() {
        return -1;
    }

    @NotNull
    public String getDisplayText(@Nullable XLineBreakpoint<DotNetLineBreakpointProperties> breakpoint) {
        if (breakpoint == null) {
            return "";
        }
        Object[] objectArray = new Object[2];
        objectArray[0] = breakpoint.getLine() + 1;
        String string2 = (String)CollectionsKt.lastOrNull((List)StringsKt.split$default((CharSequence)breakpoint.getPresentableFilePath(), (char[])new char[]{'/', '\\'}, (boolean)false, (int)0, (int)6, null));
        if (string2 == null) {
            string2 = "";
        }
        objectArray[1] = string2;
        String string3 = XDebuggerBundle.message((String)"xbreakpoint.default.display.text", (Object[])objectArray);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"XDebuggerBundle.message(\u2026 '\\\\').lastOrNull()?: \"\")");
        return string3;
    }

    public DotNetLineBreakpointType() {
        super(Companion.getId(), Companion.getTitle());
    }

    static {
        Id = Id;
        Title = Title;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0096\u0004\u0018\u00002\f0\u0001R\b\u0012\u0004\u0012\u00020\u00030\u0002B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0011\u001a\u00020\u0003H\u0016J\b\u0010\u0012\u001a\u00020\u0007H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointType$DotNetBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType$XLineBreakpointVariant;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointProperties;", "breakpointText", "", "textRange", "Lcom/intellij/openapi/util/TextRange;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointType;Ljava/lang/String;Lcom/intellij/openapi/util/TextRange;Lcom/intellij/openapi/vfs/VirtualFile;)V", "getBreakpointText", "()Ljava/lang/String;", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getTextRange", "()Lcom/intellij/openapi/util/TextRange;", "createProperties", "getHighlightRange", "getIcon", "Ljavax/swing/Icon;", "getText", "rider"})
    public class DotNetBreakpointVariant
    extends XLineBreakpointType.XLineBreakpointVariant {
        @NotNull
        private final String breakpointText;
        @NotNull
        private final TextRange textRange;
        @NotNull
        private final VirtualFile file;

        @Nullable
        public Icon getIcon() {
            return AllIcons.Debugger.Db_set_breakpoint;
        }

        @NotNull
        public TextRange getHighlightRange() {
            return this.textRange;
        }

        @NotNull
        public DotNetLineBreakpointProperties createProperties() {
            String string2 = this.file.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file.path");
            return new DotNetLineBreakpointProperties(string2, this.textRange.getStartOffset(), this.textRange.getEndOffset(), false, 0, null, 56, null);
        }

        @NotNull
        public String getText() {
            return this.breakpointText;
        }

        @NotNull
        public final String getBreakpointText() {
            return this.breakpointText;
        }

        @NotNull
        public final TextRange getTextRange() {
            return this.textRange;
        }

        @NotNull
        public final VirtualFile getFile() {
            return this.file;
        }

        public DotNetBreakpointVariant(@NotNull String breakpointText, @NotNull TextRange textRange, VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)breakpointText, (String)"breakpointText");
            Intrinsics.checkParameterIsNotNull((Object)textRange, (String)"textRange");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            super((XLineBreakpointType)DotNetLineBreakpointType.this);
            this.breakpointText = breakpointText;
            this.textRange = textRange;
            this.file = file2;
        }
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\t"}, d2={"Lcom/jetbrains/resharper/debugger/breakpoint/DotNetLineBreakpointType$Companion;", "", "()V", "Id", "", "getId", "()Ljava/lang/String;", "Title", "getTitle", "rider"})
    public static final class Companion {
        @NotNull
        public final String getId() {
            return Id;
        }

        @NotNull
        public final String getTitle() {
            return Title;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

