/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.impl.DispreferLiveTemplates;
import com.intellij.codeInsight.completion.impl.PreferStartMatching;
import com.intellij.codeInsight.completion.impl.RealPrefixMatchingWeigher;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.resharper.debugger.completion.ReSharperDebugLookupItem;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.protocol.RdDispatcherExKt;
import com.jetbrains.resharper.util.idea.DisposableExKt;
import com.jetbrains.resharper.util.idea.SyncEventWithInterrupt;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.framework.impl.IRdTask;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.CompletionItem;
import com.jetbrains.rider.model.CompletionList;
import com.jetbrains.rider.model.DebugCompletionParameters;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.List;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CharIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0018\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0019\u001a\u00020\u0016H\u0016J \u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u001a\u0010 \u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010!\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#H\u0002R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/jetbrains/resharper/debugger/completion/ReSharperDebugCompletionProvider;", "Lcom/intellij/util/TextFieldCompletionProvider;", "project", "Lcom/intellij/openapi/project/Project;", "sourcePosition", "Lcom/intellij/xdebugger/XSourcePosition;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/xdebugger/XSourcePosition;Lcom/jetbrains/resharper/icons/IconHost;)V", "getCompletions", "Lcom/jetbrains/rider/framework/impl/IRdCall;", "Lcom/jetbrains/rider/model/DebugCompletionParameters;", "Lcom/jetbrains/rider/model/CompletionList;", "getGetCompletions", "()Lcom/jetbrains/rider/framework/impl/IRdCall;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "waitForCompletionTimeout", "", "addCompletionVariants", "", "text", "", "offset", "", "prefix", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "applyPrefixMatcher", "fillCompletionVariants", "parameters", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "getPrefix", "waitFor", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "rider"})
public final class ReSharperDebugCompletionProvider
extends TextFieldCompletionProvider {
    private final Logger logger;
    private final long waitForCompletionTimeout = 15000L;
    @NotNull
    private final IRdCall<DebugCompletionParameters, CompletionList> getCompletions;
    private final Project project;
    private final XSourcePosition sourcePosition;
    private final IconHost iconHost;

    @NotNull
    public final IRdCall<DebugCompletionParameters, CompletionList> getGetCompletions() {
        return this.getCompletions;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void addCompletionVariants(@NotNull String text2, int offset, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        String string2;
        void $receiver$iv;
        DebugCompletionParameters debugCompletionParameters;
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Lifetime lifetime = DisposableExKt.makeLifetime((Disposable)this.project);
        boolean bl = this.sourcePosition != null;
        String string3 = prefix;
        DebugCompletionParameters debugCompletionParameters2 = debugCompletionParameters;
        DebugCompletionParameters debugCompletionParameters3 = debugCompletionParameters;
        IRdCall<DebugCompletionParameters, CompletionList> iRdCall = this.getCompletions;
        if ($receiver$iv != false) {
            XSourcePosition xSourcePosition = this.sourcePosition;
            if (xSourcePosition == null) {
                Intrinsics.throwNpe();
            }
            String string4 = xSourcePosition.getFile().getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"sourcePosition!!.file.path");
            string2 = string4;
        } else {
            string2 = "";
        }
        String string5 = string2;
        XSourcePosition xSourcePosition = this.sourcePosition;
        debugCompletionParameters2(string3, string5, xSourcePosition != null ? xSourcePosition.getOffset() : -1);
        IRdTask<CompletionList> task2 = iRdCall.start(debugCompletionParameters3, RdDispatcherExKt.getBackgroundScheduler(ApplicationProtocolKt.getProtocol(this.project).getScheduler()));
        task2.getResult().advise(lifetime, (Function1<RdTaskResult<CompletionList>, Unit>)((Function1)new Function1<RdTaskResult<? extends CompletionList>, Unit>(this, task2, result2){
            final /* synthetic */ ReSharperDebugCompletionProvider this$0;
            final /* synthetic */ IRdTask $task;
            final /* synthetic */ CompletionResultSet $result;

            public final void invoke(@NotNull RdTaskResult<CompletionList> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                Logger $receiver$iv = ReSharperDebugCompletionProvider.access$getLogger$p(this.this$0);
                try {
                    List<CompletionItem> items2 = ((CompletionList)this.$task.getResult().getValue().unwrap()).getItems();
                    for (CompletionItem completionItem : items2) {
                        this.$result.addElement((LookupElement)new ReSharperDebugLookupItem(completionItem, ReSharperDebugCompletionProvider.access$getProject$p(this.this$0), ReSharperDebugCompletionProvider.access$getIconHost$p(this.this$0)));
                    }
                }
                catch (ProcessCanceledException e$iv) {
                }
                catch (Throwable e$iv) {
                    $receiver$iv.error(e$iv);
                }
                this.$result.stopHere();
            }
            {
                this.this$0 = reSharperDebugCompletionProvider;
                this.$task = iRdTask;
                this.$result = completionResultSet;
                super(1);
            }
        }));
        this.waitFor(result2, lifetime);
    }

    private final void waitFor(CompletionResultSet result2, Lifetime lifetime) {
        SyncEventWithInterrupt syncLock = new SyncEventWithInterrupt();
        long millisecondsNow = System.currentTimeMillis();
        syncLock.waitFor(lifetime, (Function0<Unit>)((Function0)new Function0<Unit>(this, result2, syncLock, millisecondsNow){
            final /* synthetic */ ReSharperDebugCompletionProvider this$0;
            final /* synthetic */ CompletionResultSet $result;
            final /* synthetic */ SyncEventWithInterrupt $syncLock;
            final /* synthetic */ long $millisecondsNow;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void invoke() {
                ReSharperDebugCompletionProvider reSharperDebugCompletionProvider = this.this$0;
                synchronized (reSharperDebugCompletionProvider) {
                    if (this.$result.isStopped()) {
                        this.$syncLock.set();
                    }
                    Unit unit = Unit.INSTANCE;
                }
                if (System.currentTimeMillis() - this.$millisecondsNow > ReSharperDebugCompletionProvider.access$getWaitForCompletionTimeout$p(this.this$0)) {
                    throw (Throwable)new TimeoutException("[Debug Window Completion]Timeout in ReSharper contributor");
                }
                ProgressManager.checkCanceled();
            }
            {
                this.this$0 = reSharperDebugCompletionProvider;
                this.$result = completionResultSet;
                this.$syncLock = syncEventWithInterrupt;
                this.$millisecondsNow = l2;
                super(0);
            }
        }));
    }

    @Override
    @NotNull
    public CompletionResultSet applyPrefixMatcher(@NotNull CompletionResultSet result2, @NotNull String prefix) {
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        CompletionResultSet completionResultSet = result2.withPrefixMatcher(prefix).withRelevanceSorter(CompletionSorter.emptySorter().weigh((LookupElementWeigher)new DispreferLiveTemplates()).weigh((LookupElementWeigher)new PreferStartMatching()).weigh((LookupElementWeigher)new RealPrefixMatchingWeigher()).weigh(new LookupElementWeigher("priority"){

            @NotNull
            public Double weigh(@NotNull LookupElement element) {
                Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
                return element instanceof PrioritizedLookupElement ? -((PrioritizedLookupElement)element).getPriority() : 0.0;
            }
        }));
        Intrinsics.checkExpressionValueIsNotNull((Object)completionResultSet, (String)"result.withPrefixMatcher\u2026    }\n                }))");
        return completionResultSet;
    }

    @Override
    @Nullable
    public String getPrefix(@NotNull String text2, int offset) {
        String string2;
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        CharSequence $receiver$iv = text2;
        int count$iv = 0;
        CharIterator charIterator = StringsKt.iterator((CharSequence)$receiver$iv);
        while (charIterator.hasNext()) {
            char element$iv = charIterator.nextChar();
            char ch = element$iv;
            if (!(ch == '\"')) continue;
            ++count$iv;
        }
        if (count$iv % 2 == 1) {
            return null;
        }
        int currentIndex = offset;
        int parenthesesCount = 0;
        int bracketsCount = 0;
        boolean currentCharIsPartOfPrefix = true;
        while (currentIndex >= 1 && currentCharIsPartOfPrefix) {
            boolean bl;
            switch (text2.charAt(--currentIndex)) {
                case ')': {
                    ++parenthesesCount;
                    if (currentIndex < offset - 1 && text2.charAt(currentIndex + 1) == '.') {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case ']': {
                    ++bracketsCount;
                    if (currentIndex < offset - 1 && text2.charAt(currentIndex + 1) == '.') {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '(': {
                    if (--parenthesesCount >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '[': {
                    if (--bracketsCount >= 0) {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '.': {
                    bl = true;
                    break;
                }
                case '_': {
                    bl = true;
                    break;
                }
                default: {
                    char c2 = text2.charAt(currentIndex);
                    bl = Character.isLetterOrDigit(c2);
                }
            }
            currentCharIsPartOfPrefix = bl;
        }
        if (!currentCharIsPartOfPrefix) {
            ++currentIndex;
        }
        while (currentIndex < offset && text2.charAt(currentIndex) == '.') {
            ++currentIndex;
        }
        if (currentIndex < offset) {
            String string3;
            String string4 = string3 = text2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(currentIndex, offset);
            string2 = string5;
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        } else {
            string2 = null;
        }
        return string2;
    }

    @Override
    public void fillCompletionVariants(@NotNull CompletionParameters parameters, @NotNull String prefix, @NotNull CompletionResultSet result2) {
        Intrinsics.checkParameterIsNotNull((Object)parameters, (String)"parameters");
        Intrinsics.checkParameterIsNotNull((Object)prefix, (String)"prefix");
        Intrinsics.checkParameterIsNotNull((Object)result2, (String)"result");
        String string2 = parameters.getOriginalFile().getText();
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"parameters.originalFile.text");
        this.addCompletionVariants(string2, parameters.getOffset(), prefix, result2);
    }

    public ReSharperDebugCompletionProvider(@NotNull Project project2, @Nullable XSourcePosition sourcePosition, @NotNull IconHost iconHost) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        this.project = project2;
        this.sourcePosition = sourcePosition;
        this.iconHost = iconHost;
        ReSharperDebugCompletionProvider reSharperDebugCompletionProvider = this;
        Logger logger2 = Logger.getInstance(ReSharperDebugCompletionProvider.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        reSharperDebugCompletionProvider.logger = logger = logger2;
        this.waitForCompletionTimeout = 15000L;
        this.getCompletions = SolutionHostExtensionsKt.getSolution(this.project).getDebugCompletionProvider().getGetCompletions();
    }

    @NotNull
    public static final /* synthetic */ Logger access$getLogger$p(ReSharperDebugCompletionProvider $this) {
        return $this.logger;
    }

    @NotNull
    public static final /* synthetic */ Project access$getProject$p(ReSharperDebugCompletionProvider $this) {
        return $this.project;
    }

    @NotNull
    public static final /* synthetic */ IconHost access$getIconHost$p(ReSharperDebugCompletionProvider $this) {
        return $this.iconHost;
    }

    public static final /* synthetic */ long access$getWaitForCompletionTimeout$p(ReSharperDebugCompletionProvider $this) {
        return $this.waitForCompletionTimeout;
    }
}

