/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.completion;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.icons.IconHostKt;
import com.jetbrains.resharper.ui.RiderUIKt;
import com.jetbrains.rider.model.CompletionItem;
import com.jetbrains.rider.model.Icon;
import com.jetbrains.rider.model.ModelRichText;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0012\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/debugger/completion/ReSharperDebugLookupItem;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "completionItem", "Lcom/jetbrains/rider/model/CompletionItem;", "project", "Lcom/intellij/openapi/project/Project;", "iconHost", "Lcom/jetbrains/resharper/icons/IconHost;", "(Lcom/jetbrains/rider/model/CompletionItem;Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/icons/IconHost;)V", "getCompletionItem", "()Lcom/jetbrains/rider/model/CompletionItem;", "getIconHost", "()Lcom/jetbrains/resharper/icons/IconHost;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getLookupString", "", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "isWorthShowingInAutoPopup", "", "renderElement", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "rider"})
public final class ReSharperDebugLookupItem
extends LookupElement {
    @NotNull
    private final CompletionItem completionItem;
    @NotNull
    private final Project project;
    @NotNull
    private final IconHost iconHost;

    @NotNull
    public String getLookupString() {
        return this.completionItem.getShortText();
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        Intrinsics.checkParameterIsNotNull((Object)presentation, (String)"presentation");
        ModelRichText modelRichText = this.completionItem.getDisplayName();
        if (modelRichText == null) {
            Intrinsics.throwNpe();
        }
        presentation.setItemText(RiderUIKt.toSimpleText(modelRichText));
        Icon icon = this.completionItem.getIcon();
        if (icon != null) {
            presentation.setIcon(IconHostKt.toIdeaIcon(icon, this.iconHost));
        }
    }

    public boolean isWorthShowingInAutoPopup() {
        return true;
    }

    public void handleInsert(@Nullable InsertionContext context2) {
    }

    @NotNull
    public final CompletionItem getCompletionItem() {
        return this.completionItem;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final IconHost getIconHost() {
        return this.iconHost;
    }

    public ReSharperDebugLookupItem(@NotNull CompletionItem completionItem, @NotNull Project project2, @NotNull IconHost iconHost) {
        Intrinsics.checkParameterIsNotNull((Object)completionItem, (String)"completionItem");
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)iconHost, (String)"iconHost");
        this.completionItem = completionItem;
        this.project = project2;
        this.iconHost = iconHost;
    }
}

