/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.evaluation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.resharper.debugger.DotNetStackFrame;
import com.jetbrains.resharper.debugger.DotNetValue;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.RangeUtilKt;
import com.jetbrains.rider.framework.impl.IRdCall;
import com.jetbrains.rider.framework.impl.RdTaskResult;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.ResolveExpressionArgs;
import com.jetbrains.rider.model.ResolveExpressionResult;
import com.jetbrains.rider.model.debuggerWorker.EvalPair;
import com.jetbrains.rider.model.debuggerWorker.EvaluateArg;
import com.jetbrains.rider.model.debuggerWorker.EvaluateResult;
import com.jetbrains.rider.model.debuggerWorker.ExecutionContextProxy;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.threading.SynchronousScheduler;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 &2\u00020\u0001:\u0001&B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J.\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lcom/jetbrains/resharper/debugger/evaluation/DotNetEvaluator;", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "executionContext", "Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "frame", "Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "lifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "(Lcom/intellij/xdebugger/XDebugSession;Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;Lcom/jetbrains/resharper/debugger/DotNetStackFrame;Lcom/jetbrains/rider/util/lifetime/Lifetime;)V", "getExecutionContext", "()Lcom/jetbrains/rider/model/debuggerWorker/ExecutionContextProxy;", "getFrame", "()Lcom/jetbrains/resharper/debugger/DotNetStackFrame;", "getLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/xdebugger/XDebugSession;", "evaluate", "", "expression", "", "callback", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator$XEvaluationCallback;", "expressionPosition", "Lcom/intellij/xdebugger/XSourcePosition;", "getExpressionInfoAtOffsetAsync", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/xdebugger/evaluation/ExpressionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/Document;", "offset", "", "sideEffectsAllowed", "", "Companion", "rider"})
public final class DotNetEvaluator
extends XDebuggerEvaluator {
    @NotNull
    private final XDebugSession session;
    @NotNull
    private final ExecutionContextProxy executionContext;
    @NotNull
    private final DotNetStackFrame frame;
    @NotNull
    private final Lifetime lifetime;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public Promise<ExpressionInfo> getExpressionInfoAtOffsetAsync(@NotNull Project project2, @NotNull Document document, int offset, boolean sideEffectsAllowed) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        EditableEntityId editableEntityId = DocumentExKt.getFirstEditableEntityId(document, project2);
        if (editableEntityId == null) {
            Promise promise2 = Promise.resolve(null);
            Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(null)");
            return promise2;
        }
        EditableEntityId entityId = editableEntityId;
        AsyncPromise promise3 = new AsyncPromise();
        IRdCall.DefaultImpls.start$default(SolutionHostExtensionsKt.getSolution(this.session.getProject()).getPsiDebuggerHost().getResolveExpression(), new ResolveExpressionArgs(entityId, offset, sideEffectsAllowed), null, 2, null).getResult().advise(this.lifetime, (Function1)new Function1<RdTaskResult<? extends ResolveExpressionResult>, Unit>(promise3, document, offset){
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $offset;

            public final void invoke(@NotNull RdTaskResult<ResolveExpressionResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<ResolveExpressionResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    ResolveExpressionResult value2 = (ResolveExpressionResult)((RdTaskResult.Success)it).getValue();
                    if (value2 == null) {
                        this.$promise.setResult(null);
                        return;
                    }
                    this.$promise.setResult((Object)new ExpressionInfo(RangeUtilKt.toIdeaRange(value2.getTextRange()), value2.getExpression(), value2.getDisplayText()));
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    com.jetbrains.resharper.debugger.evaluation.DotNetEvaluator$Companion.access$getLogger$p(DotNetEvaluator.Companion).error("Error while resolving expression on document " + this.$document + " at offset " + this.$offset, ((RdTaskResult.Fault)it).getError());
                    this.$promise.setResult(null);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    com.jetbrains.resharper.debugger.evaluation.DotNetEvaluator$Companion.access$getLogger$p(DotNetEvaluator.Companion).trace("Cancelled");
                    this.$promise.setResult(null);
                }
            }
            {
                this.$promise = asyncPromise;
                this.$document = document;
                this.$offset = n2;
                super(1);
            }
        });
        return (Promise)promise3;
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        Intrinsics.checkParameterIsNotNull((Object)expression, (String)"expression");
        Intrinsics.checkParameterIsNotNull((Object)callback, (String)"callback");
        this.executionContext.getEvaluateExpressions().start(new EvaluateArg(this.frame.getFrameProxy().getId(), CollectionsKt.arrayListOf((Object[])new String[]{expression})), SynchronousScheduler.INSTANCE).getResult().advise(this.lifetime, (Function1<RdTaskResult<EvaluateResult>, Unit>)((Function1)new Function1<RdTaskResult<? extends EvaluateResult>, Unit>(this, expression, callback){
            final /* synthetic */ DotNetEvaluator this$0;
            final /* synthetic */ String $expression;
            final /* synthetic */ XDebuggerEvaluator.XEvaluationCallback $callback;

            public final void invoke(@NotNull RdTaskResult<EvaluateResult> it) {
                Intrinsics.checkParameterIsNotNull(it, (String)"it");
                RdTaskResult<EvaluateResult> rdTaskResult = it;
                if (rdTaskResult instanceof RdTaskResult.Success) {
                    EvaluateResult result2 = (EvaluateResult)((RdTaskResult.Success)it).getValue();
                    if (this.this$0.getFrame().getFrameProxy().getId() != result2.getFrameId()) {
                        return;
                    }
                    EvalPair evalPair = (EvalPair)CollectionsKt.first(result2.getExpressions());
                    boolean bl = Intrinsics.areEqual((Object)evalPair.getExpression(), (Object)this.$expression);
                    if (_Assertions.ENABLED && !bl) {
                        String string2 = "Expression mismatch";
                        throw (Throwable)((Object)new AssertionError((Object)string2));
                    }
                    this.$callback.evaluated((XValue)new DotNetValue(this.this$0.getFrame(), evalPair.getValue(), this.this$0.getLifetime()));
                } else if (rdTaskResult instanceof RdTaskResult.Fault) {
                    String string3 = ((RdTaskResult.Fault)it).getError().getMessage();
                    if (string3 == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$callback.errorOccurred(string3);
                } else if (rdTaskResult instanceof RdTaskResult.Cancelled) {
                    this.$callback.errorOccurred("Evaluation request was cancelled");
                }
            }
            {
                this.this$0 = dotNetEvaluator;
                this.$expression = string2;
                this.$callback = xEvaluationCallback;
                super(1);
            }
        }));
    }

    @NotNull
    public final XDebugSession getSession() {
        return this.session;
    }

    @NotNull
    public final ExecutionContextProxy getExecutionContext() {
        return this.executionContext;
    }

    @NotNull
    public final DotNetStackFrame getFrame() {
        return this.frame;
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    public DotNetEvaluator(@NotNull XDebugSession session2, @NotNull ExecutionContextProxy executionContext, @NotNull DotNetStackFrame frame, @NotNull Lifetime lifetime) {
        Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
        Intrinsics.checkParameterIsNotNull((Object)executionContext, (String)"executionContext");
        Intrinsics.checkParameterIsNotNull((Object)((Object)frame), (String)"frame");
        Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
        this.session = session2;
        this.executionContext = executionContext;
        this.frame = frame;
        this.lifetime = lifetime;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(DotNetEvaluator.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        DotNetEvaluator.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/debugger/evaluation/DotNetEvaluator$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ Logger access$getLogger$p(Companion $this) {
            return $this.getLogger();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

