/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.settings;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.resharper.debugger.settings.DotNetDebuggerSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import org.jetbrains.annotations.NotNull;

public class DotNetDebuggerGeneralConfigurableUi
implements ConfigurableUi<DotNetDebuggerSettings> {
    private JPanel rootPanel;
    private JCheckBox allowImplicitTargetInvoke;
    private JSpinner evaluationTimeout;
    private JCheckBox breakOnUserUnhandledCheckBox;

    public DotNetDebuggerGeneralConfigurableUi() {
        this.$$$setupUI$$$();
        this.evaluationTimeout.setModel(new SpinnerNumberModel(0, 0, 60000, 100));
        this.evaluationTimeout.setEditor(new JSpinner.NumberEditor(this.evaluationTimeout, "#"));
    }

    public void reset(@NotNull DotNetDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/resharper/debugger/settings/DotNetDebuggerGeneralConfigurableUi", "reset"));
        }
        this.allowImplicitTargetInvoke.setSelected(settings.getAllowImplicitTargetInvoke());
        this.evaluationTimeout.setValue(settings.getEvaluationTimeoutMs());
        this.breakOnUserUnhandledCheckBox.setSelected(settings.getBreakOnUserUnhandledExceptions());
    }

    public boolean isModified(@NotNull DotNetDebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/resharper/debugger/settings/DotNetDebuggerGeneralConfigurableUi", "isModified"));
        }
        return settings.getAllowImplicitTargetInvoke() != this.allowImplicitTargetInvoke.isSelected() || settings.getEvaluationTimeoutMs() != ((Integer)this.evaluationTimeout.getValue()).intValue() || settings.getBreakOnUserUnhandledExceptions() != this.breakOnUserUnhandledCheckBox.isSelected();
    }

    public void apply(@NotNull DotNetDebuggerSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/jetbrains/resharper/debugger/settings/DotNetDebuggerGeneralConfigurableUi", "apply"));
        }
        settings.setAllowImplicitTargetInvoke(this.allowImplicitTargetInvoke.isSelected());
        int value2 = (Integer)this.evaluationTimeout.getValue();
        if (value2 < 0) {
            throw new RuntimeConfigurationError("Timeout should be non-negative");
        }
        settings.setEvaluationTimeoutMs(value2);
        settings.setBreakOnUserUnhandledExceptions(this.breakOnUserUnhandledCheckBox.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.rootPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/resharper/debugger/settings/DotNetDebuggerGeneralConfigurableUi", "getComponent"));
        }
        return jPanel;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JSpinner jSpinner;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.allowImplicitTargetInvoke = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Allow property evaluations and other implicit function calls");
        jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(3, 0, 1, 2, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Evaluation timeout (ms)");
        jPanel2.add((Component)jLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.evaluationTimeout = jSpinner = new JSpinner();
        jPanel2.add((Component)jSpinner, new GridConstraints(1, 1, 1, 1, 8, 0, 6, 0, null, null, null));
        this.breakOnUserUnhandledCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setSelected(false);
        jCheckBox.setText("Break on user-unhandled exceptions (CorDebug)");
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jSpinner);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

