/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.debugger.xamarin.mac.runners;

import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.SearchScopeProvider;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.BaseOSProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessNotCreatedException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.debugger.DebuggerHelperHost;
import com.jetbrains.resharper.debugger.DebuggerWorkerProcessHandler;
import com.jetbrains.resharper.debugger.DotNetDebugProcess;
import com.jetbrains.resharper.debugger.DotNetDebugRunner;
import com.jetbrains.resharper.debugger.xamarin.mac.runners.XamarinMacDebugRunner;
import com.jetbrains.resharper.debugger.xamarin.mac.runners.XamarinMacRunner;
import com.jetbrains.resharper.icons.IconHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.protocol.RdDispatcher;
import com.jetbrains.resharper.run.configurations.xamarin.mac.XamarinMacConfiguration;
import com.jetbrains.resharper.run.xamarin.mac.XamarinMacDebugProfileState;
import com.jetbrains.resharper.util.concurrent.SyncEvent;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.utils.RiderProcessUtil;
import com.jetbrains.rider.framework.IProtocol;
import com.jetbrains.rider.framework.IWire;
import com.jetbrains.rider.framework.Identities;
import com.jetbrains.rider.framework.Protocol;
import com.jetbrains.rider.framework.Serializers;
import com.jetbrains.rider.framework.SocketWire;
import com.jetbrains.rider.framework.WireExKt;
import com.jetbrains.rider.model.debuggerWorker.DebuggerStartInfoBase;
import com.jetbrains.rider.model.debuggerWorker.DebuggerWorkerModel;
import com.jetbrains.rider.model.debuggerWorker.DotNetDebuggerSessionModel;
import com.jetbrains.rider.util.CollectionExKt;
import com.jetbrains.rider.util.PortPair;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J<\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u001cH\u0014\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/resharper/debugger/xamarin/mac/runners/XamarinMacDebugRunner;", "Lcom/jetbrains/resharper/debugger/xamarin/mac/runners/XamarinMacRunner;", "()V", "canRun", "", "executorId", "", "profile", "Lcom/intellij/execution/configurations/RunProfile;", "createAndStartSession", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/xdebugger/XDebugSession;", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "state", "Lcom/jetbrains/resharper/run/xamarin/mac/XamarinMacDebugProfileState;", "protocol", "Lcom/jetbrains/rider/framework/IProtocol;", "sessionLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "workerProcessHandler", "Lcom/jetbrains/resharper/debugger/DebuggerWorkerProcessHandler;", "sessionModel", "Lcom/jetbrains/rider/model/debuggerWorker/DotNetDebuggerSessionModel;", "prepare", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/RunProfileStarter;", "environment", "Lcom/intellij/execution/configurations/RunProfileState;", "Companion", "rider"})
public final class XamarinMacDebugRunner
extends XamarinMacRunner {
    private static final long workerInitTimeoutMs = 100000L;
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected Promise<RunProfileStarter> prepare(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state) {
        Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Promise promise2 = Promise.resolve((Object)new RunProfileStarter(this){
            final /* synthetic */ XamarinMacDebugRunner this$0;

            @Nullable
            public RunContentDescriptor execute(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                throw (Throwable)new UnsupportedOperationException("executeAsync must be called");
            }

            @NotNull
            public Promise<RunContentDescriptor> executeAsync(@NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                Intrinsics.checkParameterIsNotNull((Object)environment, (String)"environment");
                AsyncPromise asyncPromise = new AsyncPromise();
                try {
                    ComponentManager $receiver$iv = (ComponentManager)environment.getProject();
                    Object object = $receiver$iv.getComponent(DebuggerHelperHost.class);
                    if (object == null) {
                        throw (Throwable)new IllegalStateException("Component " + DebuggerHelperHost.class + " not found in container " + $receiver$iv);
                    }
                    DebuggerHelperHost helper = (DebuggerHelperHost)object;
                    RunProfileState runProfileState = state;
                    if (!(runProfileState instanceof XamarinMacDebugProfileState)) {
                        runProfileState = null;
                    }
                    XamarinMacDebugProfileState xamarinMacDebugProfileState = (XamarinMacDebugProfileState)runProfileState;
                    if (xamarinMacDebugProfileState == null) {
                        throw (Throwable)new CantRunException("This run profile is not supported: " + state.getClass());
                    }
                    XamarinMacDebugProfileState debugProfileState = xamarinMacDebugProfileState;
                    debugProfileState.checkBeforeExecution();
                    LifetimeDefinition processLifetimeDefinition = Lifetime.Companion.create(Lifetime.Companion.getEternal());
                    Protocol protocol2 = new Protocol(new Serializers(), new Identities(null, 1, null), new RdDispatcher(ApplicationKt.getApplication(), processLifetimeDefinition.getLifetime()), (Function1<? super Protocol, ? extends IWire>)((Function1)new Function1<Protocol, SocketWire.Server>(processLifetimeDefinition){
                        final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;

                        @NotNull
                        public final SocketWire.Server invoke(@NotNull Protocol it) {
                            Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                            return new SocketWire.Server(this.$processLifetimeDefinition.getLifetime(), it, null, "FrontendToDebugWorker");
                        }
                        {
                            this.$processLifetimeDefinition = lifetimeDefinition;
                            super(1);
                        }
                    }));
                    Promise<GeneralCommandLine> cmdPromise = debugProfileState.createWorkerRunCmd(processLifetimeDefinition.getLifetime(), helper, WireExKt.getServerPort(protocol2.getWire()));
                    cmdPromise.rejected((Consumer)new Consumer<Throwable>(asyncPromise){
                        final /* synthetic */ AsyncPromise $asyncPromise;

                        public final void consume(Throwable throwable) {
                            Throwable throwable2 = throwable;
                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable2, (String)"throwable");
                            this.$asyncPromise.setError(throwable2);
                        }
                        {
                            this.$asyncPromise = asyncPromise;
                        }
                    });
                    cmdPromise.done((Consumer)new Consumer<GeneralCommandLine>(this, debugProfileState, asyncPromise, processLifetimeDefinition, protocol2, environment){
                        final /* synthetic */ prepare.1 this$0;
                        final /* synthetic */ XamarinMacDebugProfileState $debugProfileState;
                        final /* synthetic */ AsyncPromise $asyncPromise;
                        final /* synthetic */ LifetimeDefinition $processLifetimeDefinition;
                        final /* synthetic */ Protocol $protocol;
                        final /* synthetic */ ExecutionEnvironment $environment;

                        /*
                         * WARNING - void declaration
                         */
                        public final void consume(GeneralCommandLine workerCmd) {
                            void receiverPortToHost;
                            void senderPortToHost;
                            if (!new File(this.$debugProfileState.getAppBundlePath()).exists()) {
                                this.$asyncPromise.setError((Throwable)new CantRunException("Failed to launch application: file '" + this.$debugProfileState.getAppBundlePath() + "' doesn't exist"));
                                return;
                            }
                            ProcessBuilder processBuilder = new ProcessBuilder(workerCmd.getCommandLineList(null));
                            File workerLogDir = new File(RiderEnvironment.INSTANCE.getLogDirectory(), "DebuggerWorker");
                            workerLogDir.mkdirs();
                            SimpleDateFormat format = new SimpleDateFormat("yyyy_M_dd_HH_mm_ss");
                            String currentTimeString = format.format(new Date());
                            processBuilder.redirectError(ProcessBuilder.Redirect.to(new File(workerLogDir, "DebuggerWorker_" + currentTimeString + ".err")));
                            processBuilder.redirectOutput(ProcessBuilder.Redirect.to(new File(workerLogDir, "DebuggerWorker_" + currentTimeString + ".out")));
                            PortPair portPair = PortPair.Companion.getFree(6672, 6675);
                            int n2 = portPair.component1();
                            int n3 = portPair.component2();
                            portPair = null;
                            processBuilder.environment().clear();
                            Map<String, String> map2 = processBuilder.environment();
                            Map map3 = EnvironmentUtil.getEnvironmentMap();
                            Intrinsics.checkExpressionValueIsNotNull((Object)map3, (String)"EnvironmentUtil.getEnvironmentMap()");
                            map2.putAll(map3);
                            processBuilder.environment().put("LOG_DIR", workerLogDir.getAbsolutePath());
                            processBuilder.environment().put("DEBUGGER_PARENT_PROCESS_PID", String.valueOf(RiderProcessUtil.INSTANCE.getCurrentPid()));
                            processBuilder.environment().put("SENDER_PORT_TO_HOST", String.valueOf((int)senderPortToHost));
                            processBuilder.environment().put("RECEIVER_PORT_TO_HOST", String.valueOf((int)receiverPortToHost));
                            DebuggerWorkerModel workerModel = DebuggerWorkerModel.Companion.create(this.$processLifetimeDefinition.getLifetime(), this.$protocol);
                            Process process2 = processBuilder.start();
                            Intrinsics.checkExpressionValueIsNotNull((Object)process2, (String)"processBuilder.start()");
                            String string2 = workerCmd.getCommandLineString();
                            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"workerCmd.commandLineString");
                            DebuggerWorkerProcessHandler workerProcessHandler = new DebuggerWorkerProcessHandler(process2, string2, workerModel, this.$debugProfileState.getAttached(), this.$protocol, this.$processLifetimeDefinition.getLifetime());
                            workerProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(this){
                                final /* synthetic */ prepare.executeAsync.2 this$0;

                                public void processTerminated(@NotNull ProcessEvent event) {
                                    Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                        final /* synthetic */ prepare.executeAsync.1 this$0;

                                        public final void invoke() {
                                            if (!this.this$0.this$0.$processLifetimeDefinition.isTerminated()) {
                                                this.this$0.this$0.$processLifetimeDefinition.terminate();
                                            }
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = $outer;
                                }
                            });
                            RiderEnvironment.INSTANCE.addRiderProcess((BaseOSProcessHandler)workerProcessHandler);
                            if (workerProcessHandler.isProcessTerminated()) {
                                this.$processLifetimeDefinition.terminate();
                                this.$asyncPromise.setError((Throwable)new ExecutionException("Debugger worker process has exited unexpectedly with exit code " + workerProcessHandler.getProcess().exitValue()));
                                return;
                            }
                            workerModel.getHostPort().advise(this.$processLifetimeDefinition.getLifetime(), (Function1<Integer, Unit>)((Function1)new Function1<Integer, Unit>(this){
                                final /* synthetic */ prepare.executeAsync.2 this$0;

                                public final void invoke(int it) {
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this, it){
                                        final /* synthetic */ prepare.executeAsync.2 this$0;
                                        final /* synthetic */ int $it;

                                        public final void invoke() {
                                            CollectionExKt.put(SolutionHostExtensionsKt.getSolution(this.this$0.this$0.$environment.getProject()).getDebuggerWorkerConnectionHelper().getPorts(), this.this$0.this$0.$processLifetimeDefinition.getLifetime(), this.this$0.this$0.$environment.getExecutionId(), this.$it);
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            this.$it = n2;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(1);
                                }
                            }));
                            SyncEvent event = new SyncEvent();
                            workerModel.getInitialized().advise(this.$processLifetimeDefinition.getLifetime(), (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(this, event){
                                final /* synthetic */ prepare.executeAsync.2 this$0;
                                final /* synthetic */ SyncEvent $event;

                                public final void invoke(boolean it) {
                                    this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                        final /* synthetic */ prepare.executeAsync.3 this$0;

                                        public final void invoke() {
                                            this.this$0.$event.set();
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    }));
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$event = syncEvent;
                                    super(1);
                                }
                            }));
                            ApplicationKt.getApplication().executeOnPooledThread(new Runnable(this, event, workerModel, workerProcessHandler, workerCmd){
                                final /* synthetic */ prepare.executeAsync.2 this$0;
                                final /* synthetic */ SyncEvent $event;
                                final /* synthetic */ DebuggerWorkerModel $workerModel;
                                final /* synthetic */ DebuggerWorkerProcessHandler $workerProcessHandler;
                                final /* synthetic */ GeneralCommandLine $workerCmd;

                                public final void run() {
                                    if (this.$event.wait(100000L)) {
                                        this.this$0.$protocol.getScheduler().invokeOrQueue((Function0<Unit>)((Function0)new Function0<Unit>(this){
                                            final /* synthetic */ prepare.executeAsync.4 this$0;

                                            public final void invoke() {
                                                try {
                                                    DebuggerStartInfoBase startInfoModel = this.this$0.this$0.$debugProfileState.createModelStartInfo();
                                                    DotNetDebuggerSessionModel sessionModel = new DotNetDebuggerSessionModel(startInfoModel);
                                                    PropertyExKt.set(this.this$0.$workerModel.getActiveSession(), sessionModel);
                                                    AsyncPromise<XDebugSession> xDebugSessionPromise = this.this$0.this$0.this$0.this$0.createAndStartSession(this.this$0.this$0.$environment, this.this$0.this$0.$debugProfileState, this.this$0.this$0.$protocol, this.this$0.this$0.$processLifetimeDefinition.getLifetime(), this.this$0.$workerProcessHandler, sessionModel);
                                                    xDebugSessionPromise.done((Consumer)new Consumer<XDebugSession>(this){
                                                        final /* synthetic */ prepare.executeAsync.1 this$0;

                                                        public final void consume(XDebugSession xDebugSession) {
                                                            this.this$0.this$0.this$0.$asyncPromise.setResult((Object)xDebugSession.getRunContentDescriptor());
                                                        }
                                                        {
                                                            this.this$0 = var1_1;
                                                        }
                                                    });
                                                    xDebugSessionPromise.rejected((Consumer)new Consumer<Throwable>(this){
                                                        final /* synthetic */ prepare.executeAsync.1 this$0;

                                                        public final void consume(Throwable e2) {
                                                            AsyncPromise asyncPromise = this.this$0.this$0.this$0.$asyncPromise;
                                                            Throwable throwable = e2;
                                                            Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"e");
                                                            asyncPromise.setError(throwable);
                                                        }
                                                        {
                                                            this.this$0 = var1_1;
                                                        }
                                                    });
                                                }
                                                catch (Throwable t2) {
                                                    this.this$0.this$0.$asyncPromise.setError(t2);
                                                }
                                            }
                                            {
                                                this.this$0 = var1_1;
                                                super(0);
                                            }
                                        }));
                                    } else {
                                        this.$workerProcessHandler.killProcess();
                                        this.this$0.$asyncPromise.setError((Throwable)new ProcessNotCreatedException("Debugger worker was not initialized within " + 100000L + " ms", this.$workerCmd));
                                    }
                                }
                                {
                                    this.this$0 = var1_1;
                                    this.$event = syncEvent;
                                    this.$workerModel = debuggerWorkerModel;
                                    this.$workerProcessHandler = debuggerWorkerProcessHandler;
                                    this.$workerCmd = generalCommandLine;
                                }
                            });
                        }
                        {
                            this.this$0 = var1_1;
                            this.$debugProfileState = xamarinMacDebugProfileState;
                            this.$asyncPromise = asyncPromise;
                            this.$processLifetimeDefinition = lifetimeDefinition;
                            this.$protocol = protocol2;
                            this.$environment = executionEnvironment;
                        }
                    });
                }
                catch (Throwable t2) {
                    return Promises.rejectedPromise((Throwable)t2);
                }
                return (Promise)asyncPromise;
            }
            {
                this.this$0 = $outer;
            }
        });
        Intrinsics.checkExpressionValueIsNotNull((Object)promise2, (String)"Promise.resolve(object :\u2026\n            }\n        })");
        return promise2;
    }

    @Override
    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile2) {
        Intrinsics.checkParameterIsNotNull((Object)executorId, (String)"executorId");
        Intrinsics.checkParameterIsNotNull((Object)profile2, (String)"profile");
        return Intrinsics.areEqual((Object)executorId, (Object)DefaultDebugExecutor.EXECUTOR_ID) && profile2 instanceof XamarinMacConfiguration && SystemInfo.isMac;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AsyncPromise<XDebugSession> createAndStartSession(@NotNull ExecutionEnvironment env, @NotNull XamarinMacDebugProfileState state, @NotNull IProtocol protocol2, @NotNull Lifetime sessionLifetime, @NotNull DebuggerWorkerProcessHandler workerProcessHandler, @NotNull DotNetDebuggerSessionModel sessionModel) {
        void newSession2;
        Intrinsics.checkParameterIsNotNull((Object)env, (String)"env");
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        Intrinsics.checkParameterIsNotNull((Object)protocol2, (String)"protocol");
        Intrinsics.checkParameterIsNotNull((Object)sessionLifetime, (String)"sessionLifetime");
        Intrinsics.checkParameterIsNotNull((Object)workerProcessHandler, (String)"workerProcessHandler");
        Intrinsics.checkParameterIsNotNull((Object)sessionModel, (String)"sessionModel");
        AsyncPromise promise2 = new AsyncPromise();
        XDebuggerManager debuggerManager = XDebuggerManager.getInstance((Project)env.getProject());
        GeneralCommandLine cmd = state.createXamarinMacCmd();
        Boolean bl = (Boolean)env.getUserData(DotNetDebugRunner.Companion.getFIRE_INITIALIZED_MANUALLY());
        if (bl == null) {
            bl = false;
        }
        Boolean fireInitializedManually = bl;
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        Project project2 = env.getProject();
        GlobalSearchScope searchScope = SearchScopeProvider.createSearchScope((Project)project2, (RunProfile)env.getRunProfile());
        ConsoleView console = TextConsoleBuilderFactory.getInstance().createBuilder(project2, searchScope).getConsole();
        sessionModel.getInitializedDebugConnection().advise(sessionLifetime, (Function1<Boolean, Unit>)((Function1)new Function1<Boolean, Unit>(cmd, console, workerProcessHandler, promise2, (Ref.ObjectRef)newSession2){
            final /* synthetic */ GeneralCommandLine $cmd;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ DebuggerWorkerProcessHandler $workerProcessHandler;
            final /* synthetic */ AsyncPromise $promise;
            final /* synthetic */ Ref.ObjectRef $newSession;

            public final void invoke(boolean initialized) {
                if (!initialized) {
                    return;
                }
                ColoredProcessHandler targetProcessHandler = new ColoredProcessHandler(this.$cmd);
                this.$console.attachToProcess((ProcessHandler)targetProcessHandler);
                targetProcessHandler.startNotify();
                this.$workerProcessHandler.attachTargetProcess((ProcessHandler)targetProcessHandler);
                XDebugSession xDebugSession = (XDebugSession)this.$newSession.element;
                if (xDebugSession == null) {
                    throw (Throwable)new IllegalStateException("Failed to initialize debug session");
                }
                this.$promise.setResult((Object)xDebugSession);
            }
            {
                this.$cmd = generalCommandLine;
                this.$console = consoleView;
                this.$workerProcessHandler = debuggerWorkerProcessHandler;
                this.$promise = asyncPromise;
                this.$newSession = objectRef;
                super(1);
            }
        }));
        newSession2.element = debuggerManager.startSession(env, new XDebugProcessStarter(env, sessionLifetime, workerProcessHandler, console, protocol2, sessionModel, fireInitializedManually){
            final /* synthetic */ ExecutionEnvironment $env;
            final /* synthetic */ Lifetime $sessionLifetime;
            final /* synthetic */ DebuggerWorkerProcessHandler $workerProcessHandler;
            final /* synthetic */ ConsoleView $console;
            final /* synthetic */ IProtocol $protocol;
            final /* synthetic */ DotNetDebuggerSessionModel $sessionModel;
            final /* synthetic */ Boolean $fireInitializedManually;

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session2) {
                Intrinsics.checkParameterIsNotNull((Object)session2, (String)"session");
                ComponentManager $receiver$iv = (ComponentManager)this.$env.getProject();
                Object object = $receiver$iv.getComponent(IconHost.class);
                if (object == null) {
                    throw (Throwable)new IllegalStateException("Component " + IconHost.class + " not found in container " + $receiver$iv);
                }
                IconHost iconHost = (IconHost)object;
                ProcessHandler processHandler2 = (ProcessHandler)this.$workerProcessHandler;
                ConsoleView consoleView = this.$console;
                Intrinsics.checkExpressionValueIsNotNull((Object)consoleView, (String)"console");
                ExecutionConsole executionConsole = (ExecutionConsole)consoleView;
                Boolean bl = this.$fireInitializedManually;
                Intrinsics.checkExpressionValueIsNotNull((Object)bl, (String)"fireInitializedManually");
                return new DotNetDebugProcess(this.$sessionLifetime, session2, processHandler2, executionConsole, this.$protocol, this.$sessionModel, bl, iconHost);
            }
            {
                this.$env = $captured_local_variable$0;
                this.$sessionLifetime = $captured_local_variable$1;
                this.$workerProcessHandler = $captured_local_variable$2;
                this.$console = $captured_local_variable$3;
                this.$protocol = $captured_local_variable$4;
                this.$sessionModel = $captured_local_variable$5;
                this.$fireInitializedManually = $captured_local_variable$6;
            }
        });
        ((XDebugSession)newSession2.element).setPauseActionSupported(true);
        return promise2;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/resharper/debugger/xamarin/mac/runners/XamarinMacDebugRunner$Companion;", "", "()V", "workerInitTimeoutMs", "", "rider"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

