/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.diagnostics;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.ui.UISettings;
import com.intellij.ide.ui.UISettingsListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.resharper.diagnostics.RiderMemoryUsageWidget;
import com.jetbrains.resharper.icons.ReSharperUnitTestingIcons;
import com.jetbrains.resharper.internal.RiderInternalConsoleWidget;
import com.jetbrains.resharper.internal.RiderInternalTools;
import com.jetbrains.resharper.internal.RiderInternalWidget;
import com.jetbrains.resharper.internal.StartMonitoringToolAction;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.AssertMode;
import com.jetbrains.rider.model.RdDiagnosticsHost;
import com.jetbrains.rider.model.RdMemoryUsageIndicator;
import com.jetbrains.rider.model.RdMemoryUsageState;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 %2\u00020\u00012\u00020\u0002:\u0001%B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0007J\u0010\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dH\u0002J\u000e\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!J\u0010\u0010\"\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$H\u0002R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/diagnostics/RiderDiagnosticsHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "assertsFromBackend", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "isAssertModeOn", "", "()Z", "isVisible", "memoryUsageIndicator", "Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;", "memoryUsageWidget", "Lcom/jetbrains/resharper/diagnostics/RiderMemoryUsageWidget;", "model", "Lcom/jetbrains/rider/model/RdDiagnosticsHost;", "getModel", "()Lcom/jetbrains/rider/model/RdDiagnosticsHost;", "assertForBackendExceptions", "", "getStatusBar", "Lcom/intellij/openapi/wm/StatusBar;", "kotlin.jvm.PlatformType", "setBackendAssertMode", "mode", "Lcom/jetbrains/rider/model/AssertMode;", "update", "source", "Lcom/intellij/ide/ui/UISettings;", "Companion", "rider"})
public final class RiderDiagnosticsHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    @NotNull
    private final RdDiagnosticsHost model;
    private final RdMemoryUsageIndicator memoryUsageIndicator;
    private final RiderMemoryUsageWidget memoryUsageWidget;
    private boolean isVisible;
    private final ArrayList<String> assertsFromBackend;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final RdDiagnosticsHost getModel() {
        return this.model;
    }

    private final StatusBar getStatusBar() {
        return WindowManager.getInstance().getStatusBar(this.myProject);
    }

    public final boolean isAssertModeOn() {
        return Intrinsics.areEqual((Object)((Object)this.model.getBackendAssertMode().getValue()), (Object)((Object)AssertMode.ThrowAssert));
    }

    public final void setBackendAssertMode(@NotNull AssertMode mode) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mode), (String)"mode");
        PropertyExKt.set(this.model.getBackendAssertMode(), mode);
    }

    public final void assertForBackendExceptions() {
        Collection collection = this.assertsFromBackend;
        if (!collection.isEmpty()) {
            Collection $receiver$iv;
            StringBuilder stringBuilder;
            StringBuilder $receiver = stringBuilder = new StringBuilder();
            int i2 = 1;
            Collection collection2 = $receiver$iv = (Collection)this.assertsFromBackend;
            if (collection2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.util.Collection<T>");
            }
            Collection thisCollection$iv = collection2;
            String[] stringArray = thisCollection$iv.toArray(new String[thisCollection$iv.size()]);
            if (stringArray == null) {
                throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            String[] copy = (String[])((Object[])stringArray);
            for (int i3 = 0; i3 < copy.length; ++i3) {
                String string2 = copy[i3];
                StringBuilder stringBuilder2 = $receiver;
                String string3 = "Backend assertion #" + i2;
                StringsKt.appendln((StringBuilder)stringBuilder2.append(string3));
                stringBuilder2 = $receiver;
                StringsKt.appendln((StringBuilder)stringBuilder2.append(string2));
                ++i2;
            }
            StringBuilder allExceptions = stringBuilder;
            this.assertsFromBackend.clear();
            throw (Throwable)((Object)new AssertionError((Object)allExceptions.toString()));
        }
    }

    private final void update(UISettings source) {
        boolean newIsVisible = source.getShowMemoryIndicator();
        if (newIsVisible != this.isVisible) {
            this.isVisible = newIsVisible;
            PropertyExKt.set(this.memoryUsageIndicator.isEnable(), newIsVisible);
            ToolWindowManager.getInstance((Project)this.myProject).invokeLater(new Runnable(this, newIsVisible){
                final /* synthetic */ RiderDiagnosticsHost this$0;
                final /* synthetic */ boolean $newIsVisible;

                public final void run() {
                    StatusBar statusBar = RiderDiagnosticsHost.access$getStatusBar(this.this$0);
                    if (this.$newIsVisible) {
                        if (statusBar.getWidget(RiderMemoryUsageWidget.Companion.getWIDGET_ID()) != null) {
                            statusBar.removeWidget(RiderMemoryUsageWidget.Companion.getWIDGET_ID());
                        }
                        statusBar.addWidget((StatusBarWidget)RiderDiagnosticsHost.access$getMemoryUsageWidget$p(this.this$0), "after Memory");
                    } else {
                        statusBar.removeWidget(RiderMemoryUsageWidget.Companion.getWIDGET_ID());
                    }
                }
                {
                    this.this$0 = riderDiagnosticsHost;
                    this.$newIsVisible = bl;
                }
            });
        }
    }

    public RiderDiagnosticsHost(final @NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.model = SolutionHostExtensionsKt.getSolution(project2).getDiagnosticsHost();
        this.memoryUsageIndicator = this.model.getMemoryUsageIndicator();
        this.memoryUsageWidget = new RiderMemoryUsageWidget(this.memoryUsageIndicator);
        RiderDiagnosticsHost riderDiagnosticsHost = this;
        ArrayList arrayList = new ArrayList();
        riderDiagnosticsHost.assertsFromBackend = arrayList;
        this.memoryUsageIndicator.getState().advise(ApplicationKt.attachLifetime((Disposable)project2), (Function1<RdMemoryUsageState, Unit>)((Function1)new Function1<RdMemoryUsageState, Unit>(){

            public final void invoke(@NotNull RdMemoryUsageState state) {
                Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
                memoryUsageWidget.update(state);
            }
        }));
        project2.getMessageBus().connect().subscribe(UISettingsListener.TOPIC, (Object)new UISettingsListener(){

            public final void uiSettingsChanged(UISettings it) {
                UISettings uISettings = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)uISettings, (String)"it");
                this.update(uISettings);
            }
        });
        UISettings uiSettings = UISettings.Companion.getInstanceOrNull();
        if (uiSettings != null) {
            this.update(uiSettings);
        } else {
            Companion.getLogger().error("UISettings isn't available for RiderDiagnosticsHost ");
        }
        RiderInternalTools tools = RiderInternalTools.Companion.getInstance(project2);
        String category = "Monitoring";
        tools.register(category, "Dispatcher Queue", ReSharperUnitTestingIcons.Companion.getTrackRun(), (Function1<? super Lifetime, ? extends RiderInternalWidget>)((Function1)new Function1<Lifetime, 1>(){

            @NotNull
            public final 1 invoke(final @NotNull Lifetime lifetime) {
                Intrinsics.checkParameterIsNotNull((Object)lifetime, (String)"lifetime");
                return new RiderInternalConsoleWidget(lifetime, project2){
                    {
                        super($super_call_param$2, $super_call_param$3);
                        RiderInternalConsoleWidget.log$default(this, "Connecting to ReSharper...", false, 2, null);
                        StartMonitoringToolAction.Companion.execute(project2, (Function1<? super String, Unit>)((Function1)new Function1<String, Unit>(){

                            public final void invoke(@NotNull String url) {
                                Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
                                CharSequence charSequence = url;
                                if (charSequence.length() > 0) {
                                    RiderInternalConsoleWidget.log$default(this, "Http Monitoring Server works on " + url, false, 2, null);
                                    RiderInternalConsoleWidget.log$default(this, "Starting browser...", false, 2, null);
                                    BrowserUtil.browse((String)url);
                                } else {
                                    RiderInternalConsoleWidget.log$default(this, "Http Monitoring Server wasn't run", false, 2, null);
                                }
                            }
                        }));
                    }
                };
            }
        }));
        ApplicationKt.getApplication().invokeLater(new Runnable(){

            @Override
            public final void run() {
                PropertyExKt.set(this.getModel().getBackendAssertMode(), AssertMode.Relaxed);
                this.getModel().getAssertFromBackend().advise(this.getComponentLifetime(), (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

                    public final void invoke(@NotNull String assertMessageFromBackend) {
                        Intrinsics.checkParameterIsNotNull((Object)assertMessageFromBackend, (String)"assertMessageFromBackend");
                        assertsFromBackend.add(assertMessageFromBackend);
                        if (!ApplicationKt.getApplication().isUnitTestMode()) {
                            Companion.getLogger().error(assertMessageFromBackend);
                        }
                    }
                }));
            }
        });
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderDiagnosticsHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderDiagnosticsHost.logger = logger;
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    public static final /* synthetic */ StatusBar access$getStatusBar(RiderDiagnosticsHost $this) {
        return $this.getStatusBar();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/diagnostics/RiderDiagnosticsHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

