/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.diagnostics;

import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.jetbrains.resharper.diagnostics.RiderMemoryUsageWidget$$special$;
import com.jetbrains.rider.model.RdMemoryUsageIndicator;
import com.jetbrains.rider.model.RdMemoryUsageState;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.LifetimeDefinition;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\u0018\u0000 %2\u00020\u0001:\u0001%B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\b\u0010\u0007\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0012H\u0002J\u000e\u0010\"\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u0012J\u0018\u0010#\u001a\u00020\u00162\u0006\u0010!\u001a\u00020\u00122\u0006\u0010$\u001a\u00020 H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/diagnostics/RiderMemoryUsageWidget;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "indicator", "Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;", "(Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;)V", "component", "Ljavax/swing/JLabel;", "getComponent", "()Ljavax/swing/JLabel;", "currentFrame", "Ljavax/swing/JFrame;", "getCurrentFrame", "()Ljavax/swing/JFrame;", "setCurrentFrame", "(Ljavax/swing/JFrame;)V", "getIndicator", "()Lcom/jetbrains/rider/model/RdMemoryUsageIndicator;", "lastState", "Lcom/jetbrains/rider/model/RdMemoryUsageState;", "ID", "", "dispose", "", "Ljavax/swing/JComponent;", "getPresentation", "", "type", "Lcom/intellij/openapi/wm/StatusBarWidget$PlatformType;", "install", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "recalculateTraffic", "", "state", "update", "updateComponent", "traffic", "Companion", "rider"})
public final class RiderMemoryUsageWidget
implements CustomStatusBarWidget {
    @Nullable
    private JFrame currentFrame;
    @NotNull
    private final JLabel component;
    private RdMemoryUsageState lastState;
    @NotNull
    private final RdMemoryUsageIndicator indicator;
    @NotNull
    private static final String WIDGET_ID = "RiderMemory";
    private static final Color LowTrafficColor;
    private static final Color MediumTrafficColor1;
    private static final Color MediumTrafficColor2;
    private static final Color HighTrafficColor;
    public static final Companion Companion;

    @Nullable
    public final JFrame getCurrentFrame() {
        return this.currentFrame;
    }

    public final void setCurrentFrame(@Nullable JFrame jFrame) {
        this.currentFrame = jFrame;
    }

    @NotNull
    public final JLabel getComponent() {
        return this.component;
    }

    public final void update(@NotNull RdMemoryUsageState state) {
        Intrinsics.checkParameterIsNotNull((Object)state, (String)"state");
        int traffic = this.recalculateTraffic(state);
        this.updateComponent(state, traffic);
    }

    private final void updateComponent(RdMemoryUsageState state, int traffic) {
        JLabel jLabel;
        JLabel $receiver = jLabel = this.component;
        $receiver.setBackground(RiderMemoryUsageWidget.Companion.getTrafficColor(traffic));
        $receiver.setText(RiderMemoryUsageWidget.Companion.getMainText(state));
        $receiver.setToolTipText(RiderMemoryUsageWidget.Companion.getToolTip(state, traffic));
        $receiver.updateUI();
    }

    private final int recalculateTraffic(RdMemoryUsageState state) {
        int traffic = 0;
        RdMemoryUsageState oldState = this.lastState;
        if (oldState != null) {
            Integer n2 = (Integer)CollectionsKt.lastOrNull(state.getCollectionCount());
            Integer n3 = (Integer)CollectionsKt.lastOrNull(oldState.getCollectionCount());
            traffic = (n2 != null ? n2 : 0) - (n3 != null ? n3 : 0);
        }
        this.lastState = state;
        return traffic;
    }

    @NotNull
    public JComponent getComponent() {
        return this.component;
    }

    @NotNull
    public String ID() {
        return Companion.getWIDGET_ID();
    }

    @Nullable
    public Void getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return null;
    }

    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkParameterIsNotNull((Object)statusBar, (String)"statusBar");
    }

    public void dispose() {
    }

    @NotNull
    public final RdMemoryUsageIndicator getIndicator() {
        return this.indicator;
    }

    public RiderMemoryUsageWidget(@NotNull RdMemoryUsageIndicator indicator) {
        JLabel jLabel;
        Intrinsics.checkParameterIsNotNull((Object)indicator, (String)"indicator");
        this.indicator = indicator;
        JLabel jLabel2 = new JLabel("");
        RiderMemoryUsageWidget riderMemoryUsageWidget = this;
        JLabel $receiver = jLabel2;
        $receiver.setOpaque(true);
        $receiver.setFont((Font)JBUI.Fonts.label((float)11.0f));
        $receiver.setBorder(BorderFactory.createEmptyBorder(-JBUI.scale((int)3), 0, 0, 0));
        $receiver.addMouseListener(new MouseAdapter(this){
            final /* synthetic */ RiderMemoryUsageWidget this$0;
            {
                this.this$0 = riderMemoryUsageWidget;
            }

            public void mouseClicked(MouseEvent e2) {
                if (SwingUtilities.isRightMouseButton(e2)) {
                    if (this.this$0.getCurrentFrame() == null) {
                        JFrame jFrame;
                        JFrame $receiver = jFrame = new JFrame("Memory Usage");
                        $receiver.setPreferredSize((Dimension)new JBDimension(300, 200));
                        JTextArea textArea = new JTextArea("Hello");
                        $receiver.getContentPane().add((Component)textArea, "Center");
                        $receiver.setAlwaysOnTop(true);
                        $receiver.pack();
                        LifetimeDefinition lifetimeDef = Lifetime.Companion.create(Lifetime.Companion.getEternal());
                        $receiver.addWindowListener(new WindowAdapter(lifetimeDef, this){
                            final /* synthetic */ LifetimeDefinition $lifetimeDef;
                            final /* synthetic */ $special$$inlined$apply$lambda$1 this$0;
                            {
                                this.$lifetimeDef = $captured_local_variable$1;
                                this.this$0 = var2_2;
                            }

                            public void windowClosing(WindowEvent e2) {
                                this.$lifetimeDef.terminate();
                                this.this$0.this$0.setCurrentFrame(null);
                            }
                        });
                        this.this$0.getIndicator().getState().advise(lifetimeDef.getLifetime(), (Function1<RdMemoryUsageState, Unit>)((Function1)new Function1<RdMemoryUsageState, Unit>(textArea){
                            final /* synthetic */ JTextArea $textArea;
                            {
                                this.$textArea = jTextArea;
                                super(1);
                            }

                            public final void invoke(RdMemoryUsageState state) {
                                this.$textArea.setText(com.jetbrains.resharper.diagnostics.RiderMemoryUsageWidget$Companion.access$getToolTip(RiderMemoryUsageWidget.Companion, state, null));
                            }
                        }));
                        JFrame frame = jFrame;
                        frame.setVisible(true);
                        this.this$0.setCurrentFrame(frame);
                    }
                } else {
                    this.this$0.getIndicator().getGcCollect().fire();
                }
            }
        });
        riderMemoryUsageWidget.component = jLabel = jLabel2;
    }

    static {
        Companion = new Companion(null);
        WIDGET_ID = WIDGET_ID;
        LowTrafficColor = new Color(0, 0, 0, 0);
        MediumTrafficColor1 = new Color(255, 255, 255, 20);
        MediumTrafficColor2 = new Color(255, 255, 255, 40);
        HighTrafficColor = new Color(255, 255, 255, 60);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001f\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0019\u001a\u00020\u000e2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/resharper/diagnostics/RiderMemoryUsageWidget$Companion;", "", "()V", "HighTrafficColor", "Ljava/awt/Color;", "getHighTrafficColor", "()Ljava/awt/Color;", "LowTrafficColor", "getLowTrafficColor", "MediumTrafficColor1", "getMediumTrafficColor1", "MediumTrafficColor2", "getMediumTrafficColor2", "WIDGET_ID", "", "getWIDGET_ID", "()Ljava/lang/String;", "getMainText", "state", "Lcom/jetbrains/rider/model/RdMemoryUsageState;", "getToolTip", "traffic", "", "(Lcom/jetbrains/rider/model/RdMemoryUsageState;Ljava/lang/Integer;)Ljava/lang/String;", "getTrafficColor", "memoryToStr", "memory", "", "rider"})
    public static final class Companion {
        @NotNull
        public final String getWIDGET_ID() {
            return WIDGET_ID;
        }

        private final Color getLowTrafficColor() {
            return LowTrafficColor;
        }

        private final Color getMediumTrafficColor1() {
            return MediumTrafficColor1;
        }

        private final Color getMediumTrafficColor2() {
            return MediumTrafficColor2;
        }

        private final Color getHighTrafficColor() {
            return HighTrafficColor;
        }

        private final Color getTrafficColor(int traffic) {
            Color color;
            switch (traffic) {
                case 0: {
                    color = this.getLowTrafficColor();
                    break;
                }
                case 1: {
                    color = this.getMediumTrafficColor1();
                    break;
                }
                case 2: {
                    color = this.getMediumTrafficColor2();
                    break;
                }
                default: {
                    color = this.getHighTrafficColor();
                }
            }
            return color;
        }

        private final String memoryToStr(long memory) {
            return String.valueOf(memory / (long)1024 / (long)1024) + "M";
        }

        private final String getMainText(RdMemoryUsageState state) {
            String allocatedManagedMemory = this.memoryToStr(state.getAllocatedManagedMemory());
            String workingSet = this.memoryToStr(state.getWorkingSet());
            return "[" + allocatedManagedMemory + " / " + workingSet + "]";
        }

        private final String getToolTip(RdMemoryUsageState state, Integer traffic) {
            StringBuffer stringBuffer;
            StringBuffer $receiver = stringBuffer = new StringBuffer();
            Appendable appendable2 = $receiver;
            Object object = "*** Backend Memory Usage ***";
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            appendable2 = $receiver;
            object = "Allocated managed memory : " + Companion.memoryToStr(state.getAllocatedManagedMemory());
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            appendable2 = $receiver;
            object = "Working set              : " + Companion.memoryToStr(state.getWorkingSet());
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            appendable2 = $receiver;
            object = "Private memory size      : " + Companion.memoryToStr(state.getPrivateMemorySize());
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            appendable2 = $receiver;
            object = "Virtual memory size      : " + Companion.memoryToStr(state.getVirtualMemorySize());
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            for (Appendable appendable2 : CollectionsKt.withIndex((Iterable)state.getCollectionCount())) {
                int index = appendable2.component1();
                int value2 = ((Number)appendable2.component2()).intValue();
                Appendable appendable3 = $receiver;
                CharSequence charSequence = "GC(" + index + ")   : " + value2;
                StringsKt.appendln((Appendable)appendable3.append(charSequence));
            }
            appendable2 = $receiver;
            object = "GC(LOH) : " + state.getLohCollectionCount();
            StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            if (traffic != null) {
                appendable2 = $receiver;
                object = "GcCollect(oldest)/sec: " + traffic;
                StringsKt.appendln((Appendable)appendable2.append((CharSequence)object));
            }
            return stringBuffer.toString();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

