/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.diagnostics;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.RiderEnvironment;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.rider.model.RdDiagnosticsHost;
import com.jetbrains.rider.model.RdSpecialPath;
import com.jetbrains.rider.model.RdSpecialPathKind;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\fJ\"\u0010\u000f\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\f2\b\b\u0002\u0010\u000e\u001a\u00020\fR\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/resharper/diagnostics/RiderSpecialPathsHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "rdHost", "Lcom/jetbrains/rider/model/RdDiagnosticsHost;", "getRdHost", "()Lcom/jetbrains/rider/model/RdDiagnosticsHost;", "addFile", "", "title", "", "path", "description", "addFolder", "rider"})
public final class RiderSpecialPathsHost
extends AbstractProjectComponent {
    private final RdDiagnosticsHost getRdHost() {
        return SolutionHostExtensionsKt.getSolution(this.myProject).getDiagnosticsHost();
    }

    public final void addFile(@NotNull String title, @NotNull String path, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        Map map2 = this.getRdHost().getSpecialPaths();
        RdSpecialPath rdSpecialPath = new RdSpecialPath(title, description, path, RdSpecialPathKind.File);
        map2.put(title, rdSpecialPath);
    }

    public static /* bridge */ /* synthetic */ void addFile$default(RiderSpecialPathsHost riderSpecialPathsHost, String string2, String string3, String string4, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string4 = "";
        }
        riderSpecialPathsHost.addFile(string2, string3, string4);
    }

    public final void addFolder(@NotNull String title, @Nullable String path, @NotNull String description) {
        Intrinsics.checkParameterIsNotNull((Object)title, (String)"title");
        Intrinsics.checkParameterIsNotNull((Object)description, (String)"description");
        if (path != null) {
            Map map2 = this.getRdHost().getSpecialPaths();
            RdSpecialPath rdSpecialPath = new RdSpecialPath(title, description, path, RdSpecialPathKind.Folder);
            map2.put(title, rdSpecialPath);
        }
    }

    public static /* bridge */ /* synthetic */ void addFolder$default(RiderSpecialPathsHost riderSpecialPathsHost, String string2, String string3, String string4, int n2, Object object) {
        if ((n2 & 4) != 0) {
            string4 = "";
        }
        riderSpecialPathsHost.addFolder(string2, string3, string4);
    }

    public RiderSpecialPathsHost(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.addFolder("HomePath", PathManager.getHomePath(), "Installation home directory");
        this.addFolder("SystemPath", PathManager.getSystemPath(), "System directory");
        this.addFolder("ConfigPath", PathManager.getConfigPath(), "Config directory");
        this.addFolder("BinPath", PathManager.getBinPath(), "Bin directory");
        this.addFolder("LibPath", PathManager.getLibPath(), "Lib directory");
        this.addFolder("OptionsPath", PathManager.getOptionsPath(), "Options directory");
        this.addFolder("PluginsPath", PathManager.getPluginsPath(), "PLUGINS Main directory");
        this.addFolder("PluginTempPath", PathManager.getPluginTempPath(), "PLUGINS Temp directory");
        this.addFolder("PreInstalledPluginsPath", PathManager.getPreInstalledPluginsPath(), "PLUGINS PreInstalled directory");
        this.addFolder("ScratchPath", PathManager.getScratchPath(), "MISC Scratch directory");
        this.addFolder("TempPath", PathManager.getTempPath(), "MISC Temp directory");
        this.addFolder("LOGS folder", PathManager.getLogPath(), "LOGS folder");
        RiderSpecialPathsHost.addFile$default(this, "LOGS frontend.log", PathManager.getLogPath() + "/frontend.log", null, 4, null);
        RiderSpecialPathsHost.addFile$default(this, "LOGS backend.log", PathManager.getLogPath() + "/backend.log", null, 4, null);
        RiderSpecialPathsHost.addFile$default(this, "LOG CONF frontend", RiderEnvironment.INSTANCE.getLogFrontendConf(), null, 4, null);
        RiderSpecialPathsHost.addFile$default(this, "LOG CONF backend", RiderEnvironment.INSTANCE.getLogBackendConf(), null, 4, null);
        RiderSpecialPathsHost.addFolder$default(this, "PROJECT BasePath", project2.getBasePath(), null, 4, null);
        RiderSpecialPathsHost.addFolder$default(this, "PROJECT StorePath", new File(project2.getBasePath(), ".idea").getPath(), null, 4, null);
    }
}

