/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.diagnostics;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.resharper.diagnostics.RiderProfilingActionsKt;
import com.jetbrains.resharper.diagnostics.StartProfilingAction;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.protocol.ProtocolComponent;
import com.jetbrains.resharper.protocol.components.ShellHost;
import com.jetbrains.rider.model.ProfilingSession;
import com.jetbrains.rider.model.ProfilingSessionStatus;
import com.jetbrains.rider.model.RdShellModel;
import com.jetbrains.rider.model.SnapshotKind;
import com.jetbrains.rider.util.lifetime.Lifetime;
import com.jetbrains.rider.util.lifetime.SequentialLifetimes;
import com.jetbrains.rider.util.reactive.IReadonlyProperty;
import com.jetbrains.rider.util.reactive.ISink;
import com.jetbrains.rider.util.reactive.PropertyExKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000 \u00112\u00020\u00012\u00020\u0002:\u0001\u0011B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/resharper/diagnostics/StartProfilingAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/project/DumbAware;", "kind", "Lcom/jetbrains/rider/model/SnapshotKind;", "text", "", "(Lcom/jetbrains/rider/model/SnapshotKind;Ljava/lang/String;)V", "getKind", "()Lcom/jetbrains/rider/model/SnapshotKind;", "getText", "()Ljava/lang/String;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "rider"})
public abstract class StartProfilingAction
extends AnAction
implements DumbAware {
    @NotNull
    private final SnapshotKind kind;
    @NotNull
    private final String text;
    private static final NotificationGroup GROUP;
    @NotNull
    private static final Logger logger;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public void actionPerformed(@NotNull AnActionEvent e2) {
        void $receiver$iv$iv$iv;
        Iterable $receiver$iv$iv;
        Object protocolHost;
        Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
        Object object = e2.getProject();
        if (object == null || (object = ApplicationProtocolKt.getProtocolHost((Project)object)) == null) {
            return;
        }
        Object $receiver$iv = protocolHost = object;
        Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv.getComponents();
        Collection destination$iv$iv$iv = new ArrayList();
        for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
            if (!(element$iv$iv$iv instanceof ShellHost)) continue;
            destination$iv$iv$iv.add(element$iv$iv$iv);
        }
        RdShellModel shell = ((ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)))).getModel();
        if (PropertyExKt.getValueOrNull((IReadonlyProperty)shell.getProfilingSession()) != null) {
            return;
        }
        Companion.getLogger().info("Starting backend profiling: " + (Object)((Object)this.kind));
        ProfilingSession session2 = new ProfilingSession(this.kind);
        shell.getProfilingSession().setValue(session2);
        SequentialLifetimes progressLt = new SequentialLifetimes(Lifetime.Companion.getEternal());
        Project project2 = e2.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project!!");
        RiderProfilingActionsKt.showBackgroundProgress$default(project2, "Attaching to profiler", progressLt.next(), null, 8, null);
        session2.getStop().adviseOn(Lifetime.Companion.getEternal(), protocolHost.getProtocol().getScheduler(), (Function0<Unit>)((Function0)new Function0<Unit>(e2, progressLt){
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ SequentialLifetimes $progressLt;

            public final void invoke() {
                Project project2 = this.$e.getProject();
                if (project2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project!!");
                RiderProfilingActionsKt.showBackgroundProgress$default(project2, "Dumping performance snapshot", this.$progressLt.next(), null, 8, null);
            }
            {
                this.$e = anActionEvent;
                this.$progressLt = sequentialLifetimes;
                super(0);
            }
        }));
        PropertyExKt.adviseEternal((ISink)session2.getStatus(), (Function1)new Function1<ProfilingSessionStatus, Unit>(progressLt, session2, e2, shell){
            final /* synthetic */ SequentialLifetimes $progressLt;
            final /* synthetic */ ProfilingSession $session;
            final /* synthetic */ AnActionEvent $e;
            final /* synthetic */ RdShellModel $shell;

            public final void invoke(@NotNull ProfilingSessionStatus status) {
                block7: {
                    block9: {
                        block8: {
                            block6: {
                                Intrinsics.checkParameterIsNotNull((Object)((Object)status), (String)"status");
                                StartProfilingAction.Companion.getLogger().debug("Status change: " + (Object)((Object)status));
                                if (!Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ProfilingSessionStatus.Started))) break block6;
                                this.$progressLt.terminateCurrent();
                                if (Intrinsics.areEqual((Object)((Object)this.$session.getSnapshotKind()), (Object)((Object)SnapshotKind.Memory))) {
                                    Project project2 = this.$e.getProject();
                                    if (project2 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"e.project!!");
                                    RiderProfilingActionsKt.showBackgroundProgress$default(project2, "Dumping memory snapshot", this.$progressLt.next(), null, 8, null);
                                } else {
                                    Project project3 = this.$e.getProject();
                                    if (project3 == null) {
                                        Intrinsics.throwNpe();
                                    }
                                    Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"e.project!!");
                                    RiderProfilingActionsKt.access$showBackgroundProgress(project3, "Profiling in progress: stop it manually", this.$progressLt.next(), (Function0)new Function0<Unit>(this){
                                        final /* synthetic */ actionPerformed.2 this$0;

                                        public final void invoke() {
                                            this.this$0.$session.getStop().fire();
                                        }
                                        {
                                            this.this$0 = var1_1;
                                            super(0);
                                        }
                                    });
                                }
                                break block7;
                            }
                            if (!Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ProfilingSessionStatus.Detached))) break block8;
                            this.$progressLt.terminateCurrent();
                            PropertyExKt.set(this.$shell.getProfilingSession(), null);
                            break block7;
                        }
                        if (!Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ProfilingSessionStatus.Failed))) break block9;
                        this.$progressLt.terminateCurrent();
                        String text2 = CommonBundle.message((String)"profiling.capture.snapshot.error", (Object[])new Object[]{PropertyExKt.getValueOrNull((IReadonlyProperty)this.$session.getResult())});
                        NotificationGroup notificationGroup = com.jetbrains.resharper.diagnostics.StartProfilingAction$Companion.access$getGROUP$p(StartProfilingAction.Companion);
                        if (notificationGroup == null || (notificationGroup = notificationGroup.createNotification(text2, NotificationType.ERROR)) == null) break block7;
                        notificationGroup.notify(this.$e.getProject());
                        break block7;
                    }
                    if (!Intrinsics.areEqual((Object)((Object)status), (Object)((Object)ProfilingSessionStatus.Stopped))) break block7;
                    Project project4 = this.$e.getProject();
                    if (project4 == null) {
                        Intrinsics.throwNpe();
                    }
                    Intrinsics.checkExpressionValueIsNotNull((Object)project4, (String)"e.project!!");
                    RiderProfilingActionsKt.showBackgroundProgress$default(project4, "Detaching from profiler", this.$progressLt.next(), null, 8, null);
                    File snapshot = new File(this.$session.getResult().getValue());
                    String url = "file://" + snapshot.getAbsolutePath();
                    String text3 = CommonBundle.message((String)"profiling.capture.snapshot.success", (Object[])new Object[]{snapshot.getName(), url, ShowFilePathAction.getFileManagerName()});
                    NotificationGroup notificationGroup = com.jetbrains.resharper.diagnostics.StartProfilingAction$Companion.access$getGROUP$p(StartProfilingAction.Companion);
                    if (notificationGroup != null && (notificationGroup = notificationGroup.createNotification("", text3, NotificationType.INFORMATION, ShowFilePathAction.FILE_SELECTING_LISTENER)) != null) {
                        notificationGroup.notify(this.$e.getProject());
                    }
                }
            }
            {
                this.$progressLt = sequentialLifetimes;
                this.$session = profilingSession;
                this.$e = anActionEvent;
                this.$shell = rdShellModel;
                super(1);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public void update(@NotNull AnActionEvent e2) {
        Object object;
        Presentation presentation;
        block7: {
            block6: {
                void $receiver$iv$iv$iv;
                Iterable $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                presentation = e2.getPresentation();
                presentation.setVisible(false);
                presentation.setEnabled(false);
                presentation.setText(this.text);
                if (!SystemInfo.isWindows) {
                    return;
                }
                object = e2.getProject();
                if (object == null || (object = ApplicationProtocolKt.getProtocolHost((Project)object)) == null) break block6;
                Object $receiver$iv = object;
                Iterable iterable = $receiver$iv$iv = (Iterable)$receiver$iv.getComponents();
                Collection destination$iv$iv$iv = new ArrayList();
                for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                    if (!(element$iv$iv$iv instanceof ShellHost)) continue;
                    destination$iv$iv$iv.add(element$iv$iv$iv);
                }
                object = (ShellHost)((ProtocolComponent)CollectionsKt.single((List)((List)destination$iv$iv$iv)));
                if (object != null && (object = ((ShellHost)object).getModel()) != null) break block7;
            }
            return;
        }
        Object shell = object;
        if (PropertyExKt.getValueOrNull((IReadonlyProperty)((RdShellModel)shell).getProfilingSession()) != null) {
            return;
        }
        presentation.setVisible(true);
        presentation.setEnabled(true);
    }

    @NotNull
    public final SnapshotKind getKind() {
        return this.kind;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public StartProfilingAction(@NotNull SnapshotKind kind, @NotNull String text2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)kind), (String)"kind");
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        this.kind = kind;
        this.text = text2;
    }

    static {
        Companion = new Companion(null);
        GROUP = new NotificationGroup("Profiling", NotificationDisplayType.BALLOON, false);
        logger = Logger.getInstance((String)"com.jetbrains.resharper.diagnostics");
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u00070\b\u00a2\u0006\u0002\b\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/resharper/diagnostics/StartProfilingAction$Companion;", "", "()V", "GROUP", "Lcom/intellij/notification/NotificationGroup;", "getGROUP", "()Lcom/intellij/notification/NotificationGroup;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final NotificationGroup getGROUP() {
            return GROUP;
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        @NotNull
        public static final /* synthetic */ NotificationGroup access$getGROUP$p(Companion $this) {
            return $this.getGROUP();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

