/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.dialog;

import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.ColorPicker;
import com.jetbrains.resharper.dialog.DialogFileType;
import com.jetbrains.resharper.dialog.EditTextDialogDialog;
import com.jetbrains.resharper.protocol.ApplicationProtocolKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.RgbaColor;
import com.jetbrains.rider.model.dialog.ChooseFileType;
import com.jetbrains.rider.model.dialog.DialogModel;
import com.jetbrains.rider.model.dialog.EditTextRequest;
import com.jetbrains.rider.model.dialog.FileDialogParams;
import com.jetbrains.rider.model.dialog.RdFileSystemPath;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.awt.Color;
import java.awt.Component;
import java.awt.Window;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\u0004\u0018\u00010\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fJ\u0016\u0010\u0011\u001a\u0004\u0018\u00010\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u000fJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00120\u000f2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u0012\u0010\u0006\u001a\u00020\u0007X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/resharper/dialog/RiderDialogHost;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getFilter", "Lcom/intellij/openapi/fileTypes/FileType;", "fileTypes", "", "Lcom/jetbrains/rider/model/dialog/ChooseFileType;", "getPathDialogResult", "Lcom/jetbrains/rider/model/dialog/RdFileSystemPath;", "paths", "getPathForSaveDialog", "wrapper", "Lcom/intellij/openapi/vfs/VirtualFileWrapper;", "getPaths", "files", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "rider"})
public final class RiderDialogHost
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final Logger logger;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @Nullable
    public final FileType getFilter(@NotNull List<ChooseFileType> fileTypes) {
        Intrinsics.checkParameterIsNotNull(fileTypes, (String)"fileTypes");
        if (fileTypes.isEmpty()) {
            return null;
        }
        if (fileTypes.size() > 1) {
            String string2 = "Can use only one file filter";
            throw (Throwable)new IllegalStateException(string2.toString());
        }
        ChooseFileType fileType = fileTypes.get(0);
        return new DialogFileType(fileType);
    }

    @NotNull
    public final List<RdFileSystemPath> getPaths(@NotNull Iterable<? extends VirtualFile> files2) {
        Intrinsics.checkParameterIsNotNull(files2, (String)"files");
        List res2 = new ArrayList();
        Iterable<? extends VirtualFile> $receiver$iv = files2;
        for (VirtualFile virtualFile : $receiver$iv) {
            VirtualFile it = virtualFile;
            String canonicalPath = it.getCanonicalPath();
            if (canonicalPath != null) {
                res2.add(new RdFileSystemPath(canonicalPath));
                continue;
            }
            this.logger.trace("canonicalPath is null");
        }
        return res2;
    }

    @Nullable
    public final RdFileSystemPath getPathForSaveDialog(@Nullable VirtualFileWrapper wrapper) {
        if (wrapper == null) {
            return null;
        }
        File virtualFile = wrapper.getFile();
        String string2 = virtualFile.getCanonicalPath();
        if (string2 == null) {
            return null;
        }
        String path = string2;
        return new RdFileSystemPath(path);
    }

    @Nullable
    public final RdFileSystemPath getPathDialogResult(@NotNull List<RdFileSystemPath> paths) {
        Intrinsics.checkParameterIsNotNull(paths, (String)"paths");
        int size = paths.size();
        switch (size) {
            case 0: {
                return null;
            }
            case 1: {
                return paths.get(0);
            }
        }
        return null;
    }

    public RiderDialogHost(final @NotNull Project project2) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        RiderDialogHost riderDialogHost = this;
        Logger logger2 = Logger.getInstance(RiderDialogHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        riderDialogHost.logger = logger = logger2;
        StartupManager.getInstance((Project)project2).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public final void run() {
                final DialogModel dialogModel = DialogModel.Companion.create(this.getComponentLifetime(), ApplicationProtocolKt.getProtocol(project2));
                dialogModel.getShowColorPickerDialog().set((Function1<RgbaColor, RgbaColor>)((Function1)new Function1<RgbaColor, RgbaColor>(){

                    @Nullable
                    public final RgbaColor invoke(@Nullable RgbaColor it) {
                        RgbaColor rgbaColor;
                        Color color;
                        Color color2;
                        Object $receiver;
                        Component component;
                        String string2;
                        Object object;
                        Window window = WindowManager.getInstance().suggestParentWindow(project2);
                        if (window == null) {
                            Intrinsics.throwNpe();
                        }
                        Component component2 = window;
                        String string3 = "Choose Color";
                        RgbaColor rgbaColor2 = it;
                        if (rgbaColor2 != null) {
                            object = rgbaColor2;
                            string2 = string3;
                            component = component2;
                            $receiver = object;
                            color2 = new Color(((RgbaColor)$receiver).getRed(), ((RgbaColor)$receiver).getGreen(), ((RgbaColor)$receiver).getBlue(), ((RgbaColor)$receiver).getAlpha());
                            component2 = component;
                            string3 = string2;
                            color = color2;
                        } else {
                            color = null;
                        }
                        boolean bl = true;
                        color2 = color;
                        string2 = string3;
                        component = component2;
                        List list2 = CollectionsKt.emptyList();
                        Color color3 = ColorPicker.showDialog(component, string2, color2, bl, list2, false);
                        if (color3 != null) {
                            object = color3;
                            $receiver = (Color)object;
                            rgbaColor = new RgbaColor(((Color)$receiver).getRed(), ((Color)$receiver).getGreen(), ((Color)$receiver).getBlue(), ((Color)$receiver).getAlpha());
                        } else {
                            rgbaColor = null;
                        }
                        return rgbaColor;
                    }
                }));
                dialogModel.getBrowseForOpenFile().set((Function1<FileDialogParams, RdFileSystemPath>)((Function1)new Function1<FileDialogParams, RdFileSystemPath>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final RdFileSystemPath invoke(@NotNull FileDialogParams it) {
                        void res2;
                        FileDialogParams fileDialogParams;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FileType filter2 = this.getFilter(it.getFileTypes());
                        FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileDescriptor();
                        FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(descriptor2, null, null);
                        VirtualFile[] files2 = chooser.choose(null, new VirtualFile[0]);
                        List<RdFileSystemPath> paths = this.getPaths(ArraysKt.asIterable((Object[])files2));
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = this.getPathDialogResult(paths);
                        FileDialogParams $receiver = fileDialogParams = it;
                        objectRef = null;
                        return (RdFileSystemPath)res2.element;
                    }
                }));
                dialogModel.getBrowseForOpenMultipleFiles().set((Function1<FileDialogParams, List<RdFileSystemPath>>)((Function1)3.INSTANCE));
                dialogModel.getBrowseForSaveFile().set((Function1<FileDialogParams, RdFileSystemPath>)((Function1)new Function1<FileDialogParams, RdFileSystemPath>(){

                    /*
                     * WARNING - void declaration
                     */
                    @Nullable
                    public final RdFileSystemPath invoke(@NotNull FileDialogParams it) {
                        void res2;
                        FileDialogParams fileDialogParams;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        FileType filter2 = this.getFilter(it.getFileTypes());
                        Object object = filter2;
                        if (object == null || (object = object.getDefaultExtension()) == null) {
                            object = "";
                        }
                        Object extension = object;
                        FileSaverDescriptor descriptor2 = new FileSaverDescriptor(it.getWindowTitle(), "", new String[]{extension});
                        FileSaverDialog chooser = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project2);
                        VirtualFileWrapper wrapper = chooser.save(null, null);
                        Ref.ObjectRef objectRef = new Ref.ObjectRef();
                        objectRef.element = this.getPathForSaveDialog(wrapper);
                        FileDialogParams $receiver = fileDialogParams = it;
                        objectRef = null;
                        return (RdFileSystemPath)res2.element;
                    }
                }));
                dialogModel.getEditText().set((Function1<EditTextRequest, String>)((Function1)new Function1<EditTextRequest, String>(){

                    @Nullable
                    public final String invoke(@NotNull EditTextRequest it) {
                        String string2;
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        EditTextDialogDialog dialog2 = new EditTextDialogDialog(it, dialogModel.getValidateCurrentText());
                        dialog2.show();
                        if (dialog2.getExitCode() == 0) {
                            EditTextRequest editTextRequest;
                            EditTextRequest $receiver = editTextRequest = it;
                            string2 = dialog2.getCurrentValue();
                        } else {
                            EditTextRequest editTextRequest;
                            EditTextRequest $receiver = editTextRequest = it;
                            string2 = null;
                        }
                        return string2;
                    }
                }));
            }
        });
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }
}

