/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.document;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.undo.ForceUndo;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.document.DocumentHost;
import com.jetbrains.resharper.document.DocumentHostHelper;
import com.jetbrains.resharper.editors.TextEditingGateway;
import com.jetbrains.resharper.editors.TextEditingGatewayKt;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ComponentContainerUtilKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.framework.impl.RdTask;
import com.jetbrains.rider.model.EditableEntityCollection;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.HashSet;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\"0&H\u0002R\u0012\u0010\n\u001a\u00020\u000bX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u00120\u0011j\b\u0012\u0004\u0012\u00020\u0012`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0016\u0010\u001e\u001a\n  *\u0004\u0018\u00010\u001f0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/resharper/document/DocumentHostHelper;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "project", "Lcom/intellij/openapi/project/Project;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "documentHost", "Lcom/jetbrains/resharper/document/DocumentHost;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileDocumentManager;Lcom/jetbrains/resharper/document/DocumentHost;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getDocumentHost", "()Lcom/jetbrains/resharper/document/DocumentHost;", "documentsToRecover", "Ljava/util/HashSet;", "Lcom/jetbrains/rider/model/EditableEntityId;", "Lkotlin/collections/HashSet;", "editableEntityCollection", "Lcom/jetbrains/rider/model/EditableEntityCollection;", "getEditableEntityCollection", "()Lcom/jetbrains/rider/model/EditableEntityCollection;", "getFileDocumentManager", "()Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "recoveringQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "makeSureEditorOpened", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "block", "Lkotlin/Function0;", "rider"})
public final class DocumentHostHelper
extends AbstractProjectComponent
implements ILifetimedComponent {
    private final MergingUpdateQueue recoveringQueue;
    private final HashSet<EditableEntityId> documentsToRecover;
    private final Logger logger;
    @NotNull
    private final Project project;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    @NotNull
    private final DocumentHost documentHost;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    private final EditableEntityCollection getEditableEntityCollection() {
        return SolutionHostExtensionsKt.getSolution(this.project).getEditors();
    }

    private final void makeSureEditorOpened(Editor editor, Function0<Unit> block) {
        ApplicationKt.getApplication().invokeLater(new Runnable(editor, block){
            final /* synthetic */ Editor $editor;
            final /* synthetic */ Function0 $block;

            public final void run() {
                AsyncEditorLoader.performWhenLoaded(this.$editor, new Runnable(this){
                    final /* synthetic */ makeSureEditorOpened.1 this$0;

                    public final void run() {
                        IdeFocusManager.findInstance().doWhenFocusSettlesDown(new Runnable(this){
                            final /* synthetic */ makeSureEditorOpened.1 this$0;

                            public final void run() {
                                this.this$0.this$0.$block.invoke();
                            }
                            {
                                this.this$0 = var1_1;
                            }
                        }, ModalityState.current());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.$editor = editor;
                this.$block = function0;
            }
        });
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final FileDocumentManager getFileDocumentManager() {
        return this.fileDocumentManager;
    }

    @NotNull
    public final DocumentHost getDocumentHost() {
        return this.documentHost;
    }

    public DocumentHostHelper(@NotNull Project project2, @NotNull FileDocumentManager fileDocumentManager, @NotNull DocumentHost documentHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        Intrinsics.checkParameterIsNotNull((Object)documentHost, (String)"documentHost");
        super(project2);
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.fileDocumentManager = fileDocumentManager;
        this.documentHost = documentHost;
        this.recoveringQueue = new MergingUpdateQueue("recoverQueue", 500, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.project, null, true).setRestartTimerOnAdd(true);
        DocumentHostHelper documentHostHelper = this;
        Logger logger = new HashSet();
        documentHostHelper.documentsToRecover = logger;
        documentHostHelper = this;
        Logger logger2 = Logger.getInstance(DocumentHostHelper.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        documentHostHelper.logger = logger = logger2;
        this.getEditableEntityCollection().getDoNotStripFiles().view(this.getComponentLifetime(), (Function3<Lifetime, Integer, String, Unit>)((Function3)1.INSTANCE));
        this.getEditableEntityCollection().getNeedRecover().advise(this.getComponentLifetime(), (Function1<EditableEntityId, Unit>)((Function1)new Function1<EditableEntityId, Unit>(){

            public final void invoke(final @NotNull EditableEntityId editableEntityId) {
                Intrinsics.checkParameterIsNotNull((Object)editableEntityId, (String)"editableEntityId");
                ApplicationKt.getApplication().assertIsDispatchThread();
                Logger $receiver$iv = logger;
                if ($receiver$iv.isTraceEnabled()) {
                    Logger logger = $receiver$iv;
                    String string2 = "Received needRecover command for " + editableEntityId.getFilePath() + " document...";
                    logger.trace(string2);
                }
                documentsToRecover.add(editableEntityId);
                recoveringQueue.queue(new Update("queue recover " + editableEntityId.getFilePath()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        try {
                            ApplicationKt.getApplication().assertIsDispatchThread();
                            Iterable $receiver$iv = documentsToRecover;
                            for (Object element$iv : $receiver$iv) {
                                EditableEntityId entity = (EditableEntityId)element$iv;
                                this.getDocumentHost().doRecover$rider(entity);
                            }
                        }
                        catch (Throwable t2) {
                            logger.warn("Exception while recovering document:\n", t2);
                        }
                        finally {
                            documentsToRecover.clear();
                        }
                    }
                });
            }
        }));
        this.getEditableEntityCollection().getSaveAllEditors().set((Function2<Lifetime, Boolean, RdTask<Boolean>>)((Function2)new Function2<Lifetime, Boolean, RdTask<Boolean>>(){

            @NotNull
            public final RdTask<Boolean> invoke(@NotNull Lifetime input, boolean lifetime) {
                boolean bl;
                Intrinsics.checkParameterIsNotNull((Object)input, (String)"input");
                boolean bl2 = bl = CommandProcessor.getInstance().getCurrentCommand() == null;
                if (!bl) {
                    String string2 = "Cannot call 'save all files' inside " + CommandProcessor.getInstance().getCurrentCommandName() + " command. " + "This can potentially break the undo stack.";
                    throw (Throwable)new IllegalArgumentException(string2.toString());
                }
                final RdTask<Boolean> task2 = new RdTask<Boolean>();
                TextEditingGatewayKt.onSyncFromBackendFinished(TextEditingGateway.Companion.getInstance(this.getProject()), this.getComponentLifetime(), (Function0<Unit>)((Function0)new Function0<Unit>(){

                    public final void invoke() {
                        this.getFileDocumentManager().saveAllDocuments();
                        task2.set(true);
                    }
                }));
                return task2;
            }
        }));
        this.getEditableEntityCollection().getSaveFile().set((Function1<String, Boolean>)((Function1)new Function1<String, Boolean>(){

            public final boolean invoke(final @NotNull String filePath) {
                Intrinsics.checkParameterIsNotNull((Object)filePath, (String)"filePath");
                try {
                    Logger $receiver$iv = logger;
                    if ($receiver$iv.isTraceEnabled()) {
                        Logger logger = $receiver$iv;
                        String string2 = "Got saveFile command for the file " + filePath + "...";
                        logger.trace(string2);
                    }
                    VirtualFile virtualFile = ComponentContainerUtilKt.toVirtualFile(filePath);
                    if (virtualFile == null) {
                        return false;
                    }
                    VirtualFile virtualFile2 = virtualFile;
                    Document document = this.getFileDocumentManager().getDocument(virtualFile2);
                    if (document == null) {
                        return false;
                    }
                    final Document document2 = document;
                    TextEditingGatewayKt.onSyncFromBackendFinished(TextEditingGateway.Companion.getInstance(this.getProject()), this.getComponentLifetime(), (Function0<Unit>)((Function0)new Function0<Unit>(){

                        public final void invoke() {
                            Editor editor = DocumentExKt.getFirstEditor(document2, this.getProject());
                            if (editor != null) {
                                this.makeSureEditorOpened(editor, (Function0<Unit>)((Function0)new Function0<Unit>(){

                                    public final void invoke() {
                                        Logger $receiver$iv = logger;
                                        if ($receiver$iv.isTraceEnabled()) {
                                            Logger logger = $receiver$iv;
                                            String string2 = "Syncing from backend is finished, editor is loaded -> do save file " + filePath + ".";
                                            logger.trace(string2);
                                        }
                                        ForceUndo.ignoreVirtualFileContentChanges((Runnable)new Runnable(){

                                            @Override
                                            public final void run() {
                                                this.getFileDocumentManager().saveDocumentAsIs(document2);
                                            }
                                        });
                                    }
                                }));
                            } else {
                                Logger $receiver$iv = logger;
                                if ($receiver$iv.isTraceEnabled()) {
                                    Logger logger = $receiver$iv;
                                    String string2 = "Syncing from backend is finished, no editors found for this document -> do save file " + filePath + ".";
                                    logger.trace(string2);
                                }
                                ForceUndo.ignoreVirtualFileContentChanges((Runnable)new Runnable(){

                                    @Override
                                    public final void run() {
                                        this.getFileDocumentManager().saveDocumentAsIs(document2);
                                    }
                                });
                            }
                        }
                    }));
                    return true;
                }
                catch (Throwable t2) {
                    logger.error(t2);
                    return false;
                }
            }
        }));
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }
}

