/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.document;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.jetbrains.resharper.document.DocumentExKt;
import com.jetbrains.resharper.document.DocumentHost;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.editors.TextControlUtilsKt;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.rider.model.FrontendTextControl;
import com.jetbrains.rider.model.ScrollingInfo;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.model.TextControlSnapshot;
import com.jetbrains.rider.util.IDisposable;
import com.jetbrains.rider.util.reactive.ISignal;
import com.jetbrains.rider.util.reactive.Signal;
import java.io.File;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001aH\u0014J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001c\u001a\u00020\u00172\b\u0010\u001d\u001a\u0004\u0018\u00010\u001aH\u0002J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 H\u0016R#\u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lcom/jetbrains/resharper/document/HeadlessTextControlHost;", "Lcom/jetbrains/resharper/editors/TextControlHost;", "project", "Lcom/intellij/openapi/project/Project;", "fileEditorManager", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "editorFactory", "Lcom/intellij/openapi/editor/EditorFactory;", "documentHost", "Lcom/jetbrains/resharper/document/DocumentHost;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "virtualFileIndex", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileEditorManager;Lcom/intellij/openapi/editor/EditorFactory;Lcom/jetbrains/resharper/document/DocumentHost;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;)V", "scrolling", "Lcom/jetbrains/rider/util/reactive/ISignal;", "Lkotlin/Pair;", "Lcom/jetbrains/rider/model/ScrollingInfo;", "Ljava/io/File;", "getScrolling", "()Lcom/jetbrains/rider/util/reactive/ISignal;", "applyScrollingFromBackend", "", "backendScrolling", "editor", "Lcom/intellij/openapi/editor/Editor;", "checkTextControlInternalState", "focusModelEditor", "rawEditor", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "Companion", "rider"})
public final class HeadlessTextControlHost
extends TextControlHost {
    @NotNull
    private final ISignal<Pair<ScrollingInfo, File>> scrolling;
    private static final Logger logger;
    public static final Companion Companion;

    @NotNull
    public final ISignal<Pair<ScrollingInfo, File>> getScrolling() {
        return this.scrolling;
    }

    @Override
    protected void applyScrollingFromBackend(@NotNull ScrollingInfo backendScrolling, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)backendScrolling, (String)"backendScrolling");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        super.applyScrollingFromBackend(backendScrolling, editor);
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            Intrinsics.throwNpe();
        }
        this.scrolling.fire((Pair<ScrollingInfo, File>)new Pair((Object)backendScrolling, (Object)new File(textControlId.getDocumentId().getFilePath())));
    }

    @Override
    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        FileEditor fileEditor = event.getNewEditor();
        if (!(fileEditor instanceof TextEditor)) {
            fileEditor = null;
        }
        TextEditor textEditor = (TextEditor)fileEditor;
        Editor rawEditor = textEditor != null ? textEditor.getEditor() : null;
        this.focusModelEditor(rawEditor);
        super.selectionChanged(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void focusModelEditor(Editor rawEditor) {
        if (rawEditor == null) {
            this.getFocusedTextControl().clear();
            return;
        }
        TextControlId textControlId = DocumentExKt.getTextControlId(rawEditor);
        if (textControlId == null) {
            return;
        }
        TextControlId textControlId2 = textControlId;
        HeadlessTextControlHost.Companion.getLogger().debug("selectionChanged callback. Sending focusedTCValue to " + textControlId2.getDocumentId().getFilePath());
        IDisposable disposable$iv = new TextControlHost.ListeningFrontendFocusCookie(this);
        try {
            this.getFocusedTextControl().getProperty().timesAssign(textControlId2);
        }
        finally {
            disposable$iv.dispose();
        }
    }

    public final void checkTextControlInternalState(@NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        TextControlId textControlId = DocumentExKt.getTextControlId(editor);
        if (textControlId == null) {
            String string2 = "cannot get modelID from idea editor";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        TextControlId id = textControlId;
        SelectionModel selectionModel = editor.getSelectionModel();
        TextControlSnapshot frontendState = new TextControlSnapshot(TextControlUtilsKt.toModel(selectionModel));
        this.getEditableEntities().getCheckInternalState().fire(new FrontendTextControl(id, frontendState));
    }

    public HeadlessTextControlHost(@NotNull Project project2, @NotNull FileEditorManager fileEditorManager, @NotNull EditorFactory editorFactory, @NotNull DocumentHost documentHost, @NotNull ProjectModelViewHost projectModelViewHost, @NotNull VirtualFileIndex virtualFileIndex) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileEditorManager, (String)"fileEditorManager");
        Intrinsics.checkParameterIsNotNull((Object)editorFactory, (String)"editorFactory");
        Intrinsics.checkParameterIsNotNull((Object)documentHost, (String)"documentHost");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        Intrinsics.checkParameterIsNotNull((Object)((Object)virtualFileIndex), (String)"virtualFileIndex");
        super(project2, fileEditorManager, editorFactory, documentHost, projectModelViewHost, virtualFileIndex);
        this.scrolling = new Signal();
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(HeadlessTextControlHost.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        HeadlessTextControlHost.logger = logger;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/resharper/document/HeadlessTextControlHost$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        private final Logger getLogger() {
            return logger;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

