/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.document;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileDocumentSynchronizationVetoer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.resharper.editors.TextEditingGateway;
import com.jetbrains.rider.model.GatewayState;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\t\u001a\u00020\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\bH\u0016J\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/document/SyncFromBackendVetoer;", "Lcom/intellij/openapi/fileEditor/FileDocumentSynchronizationVetoer;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "(Lcom/intellij/openapi/fileEditor/FileDocumentManager;)V", "getFileDocumentManager", "()Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "checkGateway", "", "mayReloadFileContent", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "document", "Lcom/intellij/openapi/editor/Document;", "maySaveDocument", "isSaveExplicit", "wasExternallyChanged", "rider"})
public final class SyncFromBackendVetoer
extends FileDocumentSynchronizationVetoer {
    @NotNull
    private final FileDocumentManager fileDocumentManager;

    public boolean maySaveDocument(@NotNull Document document, boolean isSaveExplicit) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (ApplicationManager.getApplication().isDisposed() || isSaveExplicit) {
            return true;
        }
        return this.checkGateway();
    }

    public boolean mayReloadFileContent(@Nullable VirtualFile file2, @NotNull Document document) {
        Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
        if (ApplicationManager.getApplication().isDisposed()) {
            return true;
        }
        return this.checkGateway();
    }

    private final boolean wasExternallyChanged(VirtualFile file2) {
        Document doc = this.fileDocumentManager.getCachedDocument(file2);
        return doc != null && doc.getModificationStamp() != file2.getModificationStamp();
    }

    private final boolean checkGateway() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        for (int i2 = 0; i2 < projectArray.length; ++i2) {
            Project project2 = projectArray[i2];
            if (!project2.isInitialized() || project2.isDisposed()) continue;
            Project project3 = project2;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            if (!Intrinsics.areEqual((Object)((Object)TextEditingGateway.Companion.getInstance(project3).getGatewayState().getValue()), (Object)((Object)GatewayState.SyncFromBackend))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final FileDocumentManager getFileDocumentManager() {
        return this.fileDocumentManager;
    }

    public SyncFromBackendVetoer(@NotNull FileDocumentManager fileDocumentManager) {
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        this.fileDocumentManager = fileDocumentManager;
    }
}

