/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editorActions;

import com.intellij.codeInsight.editorActions.BackspaceHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.jetbrains.resharper.completion.UtilsKt;
import com.jetbrains.resharper.editorActions.RiderTypedHandler;
import com.jetbrains.resharper.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.resharper.editorActions.RiderTypingEditorActionHandler;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/resharper/editorActions/RiderBackspaceHandler;", "Lcom/jetbrains/resharper/editorActions/RiderTypingEditorActionHandler;", "overriddenHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;", "(Lcom/intellij/openapi/editor/actionSystem/EditorWriteActionHandler;)V", "originalHandler", "Lcom/intellij/codeInsight/editorActions/BackspaceHandler;", "backendIsEnabledForCaret", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "caret", "Lcom/intellij/openapi/editor/Caret;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getFrontendHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "rider"})
public final class RiderBackspaceHandler
extends RiderTypingEditorActionHandler {
    private final BackspaceHandler originalHandler;

    @Override
    public boolean backendIsEnabledForCaret(@NotNull Editor editor, @Nullable Caret caret, @Nullable DataContext dataContext) {
        char c2;
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        RiderTypedHandler riderTypedHandler = RiderTypedHandlersSupport.Companion.getTypeHandler$default(RiderTypedHandlersSupport.Companion, editor, 0, 2, null);
        if (riderTypedHandler == null) {
            return false;
        }
        RiderTypedHandler typeHandler = riderTypedHandler;
        boolean $receiver$iv = typeHandler.getSyncBackspace();
        if (!$receiver$iv) {
            return false;
        }
        if (editor.getSelectionModel().hasSelection()) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        Character c3 = UtilsKt.getTypedChar(editor, offset - 1, offset);
        if (c3 == null) {
            return false;
        }
        char c4 = c2 = c3.charValue();
        if (Character.isLetterOrDigit(c4) || CharsKt.isWhitespace((char)c2) || c2 == '.') {
            return false;
        }
        return super.backendIsEnabledForCaret(editor, caret, dataContext);
    }

    @Override
    @NotNull
    public EditorActionHandler getFrontendHandler() {
        return (EditorActionHandler)this.originalHandler;
    }

    public RiderBackspaceHandler(@NotNull EditorWriteActionHandler overriddenHandler) {
        Intrinsics.checkParameterIsNotNull((Object)overriddenHandler, (String)"overriddenHandler");
        super("TextControl.Backspace", (EditorActionHandler)overriddenHandler);
        this.originalHandler = new BackspaceHandler(this.getBaseHandler());
    }
}

