/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editorActions;

import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.Topic;
import com.jetbrains.resharper.editorActions.IRiderTypingListener;
import com.jetbrains.resharper.editorActions.RiderTypedHandler;
import com.jetbrains.resharper.editorActions.RiderTypedHandlersSupport;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.internal.flags.IRiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlag;
import com.jetbrains.resharper.internal.flags.RiderInternalFlags;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.SolutionLifecycleHost;
import com.jetbrains.resharper.util.idea.EditorUtilKt;
import com.jetbrains.resharper.util.idea.ExtensionsKt;
import com.jetbrains.resharper.util.idea.RiderDocumnetUtilKt;
import com.jetbrains.rider.model.RdTypingAssistHost;
import com.jetbrains.rider.model.TypeData;
import java.awt.Color;
import java.util.concurrent.atomic.AtomicInteger;
import javax.naming.OperationNotSupportedException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 %2\u00020\u0001:\u0001%B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/resharper/editorActions/RiderTypeHandlerManager;", "Lcom/intellij/openapi/components/AbstractProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "solutionLifecycleHost", "Lcom/jetbrains/resharper/projectView/SolutionLifecycleHost;", "internalFlags", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/editors/TextControlHost;Lcom/jetbrains/resharper/projectView/SolutionLifecycleHost;Lcom/jetbrains/resharper/internal/flags/RiderInternalFlags;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "syncAllSymbolsFlag", "Lcom/jetbrains/resharper/internal/flags/RiderInternalFlag;", "", "getSyncAllSymbolsFlag$rider", "()Lcom/jetbrains/resharper/internal/flags/RiderInternalFlag;", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "timestamp", "Ljava/util/concurrent/atomic/AtomicInteger;", "typingAssist", "Lcom/jetbrains/rider/model/RdTypingAssistHost;", "beforeCharTyped", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "c", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "fireReadonlyTypingAssist", "", "data", "Lcom/jetbrains/rider/model/TypeData;", "syncWritableTypingAssist", "Companion", "rider"})
public final class RiderTypeHandlerManager
extends AbstractProjectComponent {
    @NotNull
    private final RiderInternalFlag<Boolean> syncAllSymbolsFlag;
    private final RdTypingAssistHost typingAssist;
    private AtomicInteger timestamp;
    @NotNull
    private final Project project;
    @NotNull
    private final TextControlHost textControlHost;
    private final SolutionLifecycleHost solutionLifecycleHost;
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Topic<IRiderTypingListener> BEFORE_TYPING_SENT;
    public static final Companion Companion;

    @NotNull
    public final RiderInternalFlag<Boolean> getSyncAllSymbolsFlag$rider() {
        return this.syncAllSymbolsFlag;
    }

    @Nullable
    public final TypedHandlerDelegate.Result beforeCharTyped(char c2, @Nullable Editor editor, @Nullable PsiFile file2) {
        if (!this.solutionLifecycleHost.isBackendReadyForTypingActions()) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (editor == null || file2 == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        int offset = editor.getCaretModel().getOffset();
        RiderTypedHandler typeHandler = RiderTypedHandlersSupport.Companion.getTypeHandler(file2, offset);
        if (typeHandler == null) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (!RiderDocumnetUtilKt.isRealDocument(editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (EditorUtilKt.hasMultipleEditPoints(editor)) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        RiderTypedHandler riderTypedHandler = typeHandler;
        boolean isCompletionTerminator = riderTypedHandler != null ? Boolean.valueOf(riderTypedHandler.isCompletionTerminator(editor, c2)) : null;
        TypeData data = new TypeData(c2, isCompletionTerminator, this.timestamp.incrementAndGet());
        ((IRiderTypingListener)this.project.getMessageBus().syncPublisher(Companion.getBEFORE_TYPING_SENT())).beforeSendType(data, editor);
        if (typeHandler.isWritableTypingAssist(editor, c2) || this.syncAllSymbolsFlag.getValue().booleanValue()) {
            this.syncWritableTypingAssist(data);
            return TypedHandlerDelegate.Result.STOP;
        }
        this.fireReadonlyTypingAssist(data);
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final void fireReadonlyTypingAssist(TypeData data) {
        Logger $receiver$iv = Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Backend typing assist. Send readonly " + data;
            logger.trace(string2);
        }
        this.typingAssist.getReadonlyType().fire(data);
    }

    private final void syncWritableTypingAssist(TypeData data) {
        this.textControlHost.syncFocusedEditor$rider();
        Logger $receiver$iv = Companion.getLogger();
        if ($receiver$iv.isTraceEnabled()) {
            Logger logger = $receiver$iv;
            String string2 = "Backend typing assist. Send writable " + data;
            logger.trace(string2);
        }
        long startTime = System.nanoTime();
        ExtensionsKt.syncFromBackend$default(this.typingAssist.getEmulateType(), data, this.project, null, 4, null);
        long endTime = System.nanoTime();
        Companion.getLogger().debug("emulateType('" + data + "'): " + (endTime - startTime) / (long)1000000 + "ms");
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    /*
     * WARNING - void declaration
     */
    public RiderTypeHandlerManager(@NotNull Project project2, @NotNull TextControlHost textControlHost, @NotNull SolutionLifecycleHost solutionLifecycleHost, @NotNull RiderInternalFlags internalFlags) {
        RiderInternalFlag riderInternalFlag;
        RiderInternalFlag<void> riderInternalFlag2;
        void key$iv;
        void defaultValue$iv;
        void this_$iv;
        boolean isRestartRequired$iv;
        String desc$iv;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)solutionLifecycleHost, (String)"solutionLifecycleHost");
        Intrinsics.checkParameterIsNotNull((Object)internalFlags, (String)"internalFlags");
        super(project2);
        this.project = project2;
        this.textControlHost = textControlHost;
        this.solutionLifecycleHost = solutionLifecycleHost;
        RiderInternalFlags riderInternalFlags = internalFlags;
        String string2 = "typing.syncAllSymbols";
        Boolean bl = false;
        String string3 = "Synchronous TypeAssist will be applied for each symbol";
        boolean bl2 = false;
        int n2 = 8;
        RiderInternalFlag.Companion companion = null;
        RiderTypeHandlerManager riderTypeHandlerManager = this;
        if ((n2 & 4) != 0) {
            desc$iv = "";
        }
        if ((n2 & 8) != 0) {
            isRestartRequired$iv = false;
        }
        companion = RiderInternalFlag.Companion;
        void var12_13 = this_$iv;
        void var13_14 = defaultValue$iv;
        if (var13_14 instanceof Boolean) {
            riderInternalFlag2 = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Boolean);
        } else if (var13_14 instanceof String) {
            riderInternalFlag2 = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.String);
        } else if (var13_14 instanceof Integer) {
            riderInternalFlag2 = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Int);
        } else if (var13_14 instanceof Color) {
            riderInternalFlag2 = new RiderInternalFlag<void>((String)key$iv, defaultValue$iv, desc$iv, isRestartRequired$iv, RiderInternalFlag.FlagType.Color);
        } else {
            throw (Throwable)new OperationNotSupportedException("Error in RiderInternalFlag registration (" + (String)key$iv + ")");
        }
        RiderInternalFlag<void> riderInternalFlag3 = riderInternalFlag2;
        riderTypeHandlerManager.syncAllSymbolsFlag = riderInternalFlag = (RiderInternalFlag)var12_13.register((IRiderInternalFlag)riderInternalFlag3);
        this.typingAssist = SolutionHostExtensionsKt.getSolution(this.project).getTypingAssistHost();
        this.timestamp = new AtomicInteger(0);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(RiderTypeHandlerManager.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(T::class.java)");
        RiderTypeHandlerManager.logger = logger;
        BEFORE_TYPING_SENT = new Topic("Before the typing signals are sent to backend", IRiderTypingListener.class);
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001f\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/editorActions/RiderTypeHandlerManager$Companion;", "", "()V", "BEFORE_TYPING_SENT", "Lcom/intellij/util/messages/Topic;", "Lcom/jetbrains/resharper/editorActions/IRiderTypingListener;", "kotlin.jvm.PlatformType", "getBEFORE_TYPING_SENT", "()Lcom/intellij/util/messages/Topic;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "rider"})
    public static final class Companion {
        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @NotNull
        public final Topic<IRiderTypingListener> getBEFORE_TYPING_SENT() {
            return BEFORE_TYPING_SENT;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

