/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.resharper.editors.EditorContextWidgetAction;
import com.jetbrains.resharper.editors.ITextControlHost;
import com.jetbrains.resharper.editors.ProjectContextWidget;
import com.jetbrains.resharper.editors.TextControlHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/resharper/editors/ChangeToSpecificProjectContextAction;", "Lcom/jetbrains/resharper/editors/EditorContextWidgetAction;", "text", "", "pmId", "", "widget", "Lcom/jetbrains/resharper/editors/ProjectContextWidget;", "currentId", "(Ljava/lang/String;ILcom/jetbrains/resharper/editors/ProjectContextWidget;I)V", "getCurrentId", "()I", "isEnabled", "", "()Z", "getPmId", "getText", "()Ljava/lang/String;", "getWidget", "()Lcom/jetbrains/resharper/editors/ProjectContextWidget;", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "rider"})
public final class ChangeToSpecificProjectContextAction
extends EditorContextWidgetAction {
    @NotNull
    private final String text;
    private final int pmId;
    @NotNull
    private final ProjectContextWidget widget;
    private final int currentId;

    @Override
    public boolean isEnabled() {
        return this.currentId != this.pmId;
    }

    @Override
    public void execute(@NotNull Project project2, @NotNull Editor editor) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        ITextControlHost textControlHost = TextControlHost.Companion.getInstance(project2);
        textControlHost.ensureIdForEditor(editor, this.pmId);
        this.widget.update();
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
        statusBar.updateWidget(ProjectContextWidget.Companion.getID());
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getPmId() {
        return this.pmId;
    }

    @NotNull
    public final ProjectContextWidget getWidget() {
        return this.widget;
    }

    public final int getCurrentId() {
        return this.currentId;
    }

    public ChangeToSpecificProjectContextAction(@NotNull String text2, int pmId, @NotNull ProjectContextWidget widget, int currentId) {
        Intrinsics.checkParameterIsNotNull((Object)text2, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)widget, (String)"widget");
        super(text2);
        this.text = text2;
        this.pmId = pmId;
        this.widget = widget;
        this.currentId = currentId;
    }
}

