/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.AppTopics;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManagerAdapter;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.impl.status.EditorBasedWidget;
import com.intellij.openapi.wm.impl.status.TextPanel;
import com.intellij.ui.ClickListener;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.resharper.editors.EditorContextWidgetAction;
import com.jetbrains.resharper.editors.ProjectContextWidget;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u001d\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0018\u0010!\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H$J \u0010(\u001a\u0012\u0012\u0004\u0012\u00020*0)j\b\u0012\u0004\u0012\u00020*`+2\u0006\u0010,\u001a\u00020%H$J\b\u0010-\u001a\u00020.H\u0016J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020%H\u0004J\b\u00102\u001a\u00020'H$J\b\u00103\u001a\u00020'H$J\u0012\u00104\u001a\u0004\u0018\u0001052\u0006\u00106\u001a\u000207H\u0016J\b\u00108\u001a\u00020'H&J\u0010\u00109\u001a\u00020\u001c2\u0006\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u000eH$J\b\u0010=\u001a\u00020\u001cH\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u00020\u000eX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u0014X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006>"}, d2={"Lcom/jetbrains/resharper/editors/EditorContextWidget;", "Lcom/intellij/openapi/wm/impl/status/EditorBasedWidget;", "Lcom/intellij/openapi/wm/StatusBarWidget$Multiframe;", "Lcom/intellij/openapi/wm/CustomStatusBarWidget;", "project", "Lcom/intellij/openapi/project/Project;", "fileIndex", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;)V", "getFileIndex", "()Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "myActionEnabled", "", "getMyActionEnabled", "()Z", "setMyActionEnabled", "(Z)V", "myComponent", "Lcom/intellij/openapi/wm/impl/status/TextPanel;", "getMyComponent", "()Lcom/intellij/openapi/wm/impl/status/TextPanel;", "getProjectModelViewHost", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "copy", "Lcom/intellij/openapi/wm/StatusBarWidget;", "execute", "", "e", "Ljava/awt/event/MouseEvent;", "clickCount", "", "fileOpened", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActionGroupName", "", "getActions", "Ljava/util/ArrayList;", "Lcom/jetbrains/resharper/editors/EditorContextWidgetAction;", "Lkotlin/collections/ArrayList;", "selectedFileLocal", "getComponent", "Ljavax/swing/JComponent;", "getContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "virtualFile", "getFacadeText", "getPopupTitle", "getPresentation", "Lcom/intellij/openapi/wm/StatusBarWidget$WidgetPresentation;", "type", "Lcom/intellij/openapi/wm/StatusBarWidget$PlatformType;", "getToolTipHeader", "install", "statusBar", "Lcom/intellij/openapi/wm/StatusBar;", "isEnabled", "update", "rider"})
public abstract class EditorContextWidget
extends EditorBasedWidget
implements StatusBarWidget.Multiframe,
CustomStatusBarWidget {
    @NotNull
    private final TextPanel myComponent;
    private boolean myActionEnabled;
    @NotNull
    private final VirtualFileIndex fileIndex;
    @NotNull
    private final ProjectModelViewHost projectModelViewHost;

    @NotNull
    protected final TextPanel getMyComponent() {
        return this.myComponent;
    }

    protected final boolean getMyActionEnabled() {
        return this.myActionEnabled;
    }

    protected final void setMyActionEnabled(boolean bl) {
        this.myActionEnabled = bl;
    }

    @Override
    public void install(@NotNull StatusBar statusBar) {
        Intrinsics.checkParameterIsNotNull((Object)statusBar, (String)"statusBar");
        super.install(statusBar);
        MessageBusConnection connection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        connection.subscribe(AppTopics.FILE_DOCUMENT_SYNC, (Object)new FileDocumentManagerAdapter(this){
            final /* synthetic */ EditorContextWidget this$0;

            public void fileContentReloaded(@NotNull VirtualFile file2, @NotNull Document document) {
                Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                Intrinsics.checkParameterIsNotNull((Object)document, (String)"document");
                this.this$0.update();
            }
            {
                this.this$0 = $outer;
            }
        });
    }

    protected abstract boolean isEnabled();

    public void update() {
        String toDoComment;
        Object[] objectArray;
        Object object;
        this.myActionEnabled = false;
        String toolTipText = null;
        String panelText = null;
        if (this.getEditor() != null) {
            this.myActionEnabled = this.isEnabled();
            String context2 = this.getFacadeText();
            String format = this.getToolTipHeader();
            object = StringCompanionObject.INSTANCE;
            objectArray = new Object[]{StringUtil.escapeLineBreak((String)context2)};
            String string2 = String.format(format, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"java.lang.String.format(format, *args)");
            toolTipText = string2;
            panelText = context2 + " ";
        }
        this.myComponent.resetColor();
        if (this.myActionEnabled) {
            toDoComment = "Click to change";
            this.myComponent.setForeground(UIUtil.getActiveTextColor());
            this.myComponent.setTextAlignment(0.0f);
        } else {
            toDoComment = "";
            this.myComponent.setForeground(UIUtil.getInactiveTextColor());
            this.myComponent.setTextAlignment(0.5f);
        }
        StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
        object = "%s%n%s";
        objectArray = new Object[]{toolTipText, toDoComment};
        TextPanel textPanel = this.myComponent;
        String string3 = String.format((String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"java.lang.String.format(format, *args)");
        String string4 = string3;
        textPanel.setToolTipText(string4);
        this.myComponent.setText(panelText);
        if (this.myStatusBar != null) {
            this.myStatusBar.updateWidget(this.ID());
        }
    }

    @NotNull
    protected abstract String getFacadeText();

    @NotNull
    public abstract String getToolTipHeader();

    private final void execute(MouseEvent e2, int clickCount) {
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile == null) {
            return;
        }
        VirtualFile selectedFileLocal = virtualFile;
        if (!this.myActionEnabled || this.getEditor() == null || this.getProject() == null) {
            return;
        }
        VirtualFile virtualFile2 = selectedFileLocal;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"selectedFileLocal");
        ArrayList<EditorContextWidgetAction> actions2 = this.getActions(virtualFile2);
        if (actions2.size() < 2) {
            return;
        }
        if (clickCount > 1) {
            int anchor;
            block12: {
                int n2;
                List $receiver$iv = actions2;
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    EditorContextWidgetAction it = (EditorContextWidgetAction)((Object)item$iv);
                    if (!it.isEnabled()) {
                        n2 = index$iv;
                        break block12;
                    }
                    ++index$iv;
                }
                n2 = anchor = -1;
            }
            if (anchor > -1) {
                int index = anchor + 1;
                int n3 = index;
                Collection index$iv = actions2;
                int n4 = index$iv.size();
                if (n3 > n4 - 1) {
                    index = 0;
                }
                Project project2 = this.getProject();
                if (project2 == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project!!");
                Editor editor = this.getEditor();
                if (editor == null) {
                    Intrinsics.throwNpe();
                }
                Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor!!");
                actions2.get(index).execute(project2, editor);
                return;
            }
        }
        AnAction anAction = ActionManager.getInstance().getAction(this.getActionGroupName());
        if (anAction == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.actionSystem.DefaultActionGroup");
        }
        DefaultActionGroup group = (DefaultActionGroup)anAction;
        group.removeAll();
        for (EditorContextWidgetAction action2 : actions2) {
            group.add((AnAction)action2);
        }
        VirtualFile virtualFile3 = selectedFileLocal;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile3, (String)"selectedFileLocal");
        DataContext dataContext = this.getContext(virtualFile3);
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(this.getPopupTitle(), (ActionGroup)group, dataContext, JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true);
        Dimension dimension = popup2.getContent().getPreferredSize();
        Point at = new Point(0, -dimension.height);
        popup2.show(new RelativePoint(e2.getComponent(), at));
        Disposer.register((Disposable)((Disposable)this), (Disposable)((Disposable)popup2));
    }

    @NotNull
    protected abstract String getPopupTitle();

    @NotNull
    protected abstract String getActionGroupName();

    @NotNull
    protected abstract ArrayList<EditorContextWidgetAction> getActions(@NotNull VirtualFile var1);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final DataContext getContext(@NotNull VirtualFile virtualFile) {
        void elements$iv;
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        Editor editor = this.getEditor();
        StatusBar statusBar = this.myStatusBar;
        if (statusBar == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Component");
        }
        DataContext parent = DataManager.getInstance().getDataContext((Component)statusBar);
        VirtualFile[] virtualFileArray = new VirtualFile[]{virtualFile};
        String string2 = CommonDataKeys.VIRTUAL_FILE_ARRAY.getName();
        Object[] objectArray = (Object[])elements$iv;
        Editor editor2 = editor;
        DataContext dataContext = SimpleDataContext.getSimpleContext(string2, objectArray, SimpleDataContext.getSimpleContext(CommonDataKeys.PROJECT.getName(), this.getProject(), SimpleDataContext.getSimpleContext(PlatformDataKeys.CONTEXT_COMPONENT.getName(), editor2 != null ? editor2.getComponent() : null, parent)));
        Intrinsics.checkExpressionValueIsNotNull((Object)dataContext, (String)"SimpleDataContext.getSim\u2026tor?.component, parent)))");
        return dataContext;
    }

    @NotNull
    public JComponent getComponent() {
        return this.myComponent;
    }

    @Nullable
    public StatusBarWidget.WidgetPresentation getPresentation(@NotNull StatusBarWidget.PlatformType type) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        return null;
    }

    @NotNull
    public StatusBarWidget copy() {
        Project project2 = this.getProject();
        if (project2 == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project!!");
        return new ProjectContextWidget(project2, this.fileIndex, this.projectModelViewHost);
    }

    public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
        this.update();
    }

    @NotNull
    public final VirtualFileIndex getFileIndex() {
        return this.fileIndex;
    }

    @NotNull
    public final ProjectModelViewHost getProjectModelViewHost() {
        return this.projectModelViewHost;
    }

    public EditorContextWidget(@NotNull Project project2, @NotNull VirtualFileIndex fileIndex, @NotNull ProjectModelViewHost projectModelViewHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileIndex), (String)"fileIndex");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        super(project2);
        this.fileIndex = fileIndex;
        this.projectModelViewHost = projectModelViewHost;
        this.myComponent = new TextPanel.ExtraSize(this){
            final /* synthetic */ EditorContextWidget this$0;

            protected void paintComponent(@NotNull Graphics g2) {
                Intrinsics.checkParameterIsNotNull((Object)g2, (String)"g");
                super.paintComponent(g2);
                if (this.this$0.getMyActionEnabled() && this.getText() != null) {
                    Rectangle r2 = this.getBounds();
                    Insets insets = this.getInsets();
                    Icon arrows = AllIcons.Ide.Statusbar_arrows;
                    arrows.paintIcon(this, g2, r2.width - insets.right - arrows.getIconWidth() - 2, r2.height / 2 - arrows.getIconHeight() / 2);
                }
            }
            {
                this.this$0 = $outer;
            }
        };
        new ClickListener(){

            public boolean onClick(@NotNull MouseEvent e2, int clickCount) {
                Intrinsics.checkParameterIsNotNull((Object)e2, (String)"e");
                this.update();
                this.execute(e2, clickCount);
                return true;
            }
        }.installOn((Component)this.myComponent);
        this.myComponent.setBorder(StatusBarWidget.WidgetBorder.WIDE);
    }
}

