/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.WindowManagerListener;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.resharper.editors.ProjectContextWidget;
import com.jetbrains.resharper.editors.TargetFrameworkIdWidget;
import com.jetbrains.resharper.editors.TextControlHost;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.resharper.util.idea.ILifetimedComponent;
import com.jetbrains.resharper.util.idea.LifetimedComponent;
import com.jetbrains.rider.model.EditableEntityId;
import com.jetbrains.rider.model.RdProjectTargetFramework;
import com.jetbrains.rider.model.TextControlId;
import com.jetbrains.rider.util.lifetime.Lifetime;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003:\u0001-B%\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010%\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010&\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002J\b\u0010'\u001a\u00020\"H\u0002J\u0010\u0010(\u001a\u00020\"2\u0006\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020\"H\u0002J\u0010\u0010,\u001a\u00020\"2\u0006\u0010#\u001a\u00020$H\u0002R\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0016\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006."}, d2={"Lcom/jetbrains/resharper/editors/EditorsSynchronizer;", "Lcom/jetbrains/resharper/util/idea/ILifetimedComponent;", "Lcom/intellij/openapi/wm/WindowManagerListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "textControlHost", "Lcom/jetbrains/resharper/editors/TextControlHost;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "fileDocumentManager", "Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/editors/TextControlHost;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;Lcom/intellij/openapi/fileEditor/FileDocumentManager;)V", "componentLifetime", "Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getComponentLifetime", "()Lcom/jetbrains/rider/util/lifetime/Lifetime;", "getFileDocumentManager", "()Lcom/intellij/openapi/fileEditor/FileDocumentManager;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "getProjectModelViewHost", "()Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "syncTargetFrameworkModelQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "kotlin.jvm.PlatformType", "syncWithProjectModelQueue", "getTextControlHost", "()Lcom/jetbrains/resharper/editors/TextControlHost;", "beforeFrameReleased", "", "frame", "Lcom/intellij/openapi/wm/IdeFrame;", "frameCreated", "installWidgets", "queueUpdateTargetFrameworkWidget", "selectionChanged", "event", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "syncWithProjectModel", "uninstallWidget", "MyVirtualFileListener", "rider"})
public final class EditorsSynchronizer
implements ILifetimedComponent,
WindowManagerListener,
FileEditorManagerListener {
    @NotNull
    private final Logger logger;
    private final MergingUpdateQueue syncWithProjectModelQueue;
    private final MergingUpdateQueue syncTargetFrameworkModelQueue;
    @NotNull
    private final Project project;
    @NotNull
    private final TextControlHost textControlHost;
    @NotNull
    private final ProjectModelViewHost projectModelViewHost;
    @NotNull
    private final FileDocumentManager fileDocumentManager;
    private final /* synthetic */ LifetimedComponent $$delegate_0;

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    private final void queueUpdateTargetFrameworkWidget() {
        this.syncTargetFrameworkModelQueue.queue(new Update(this, "QueueSyncEditors"){
            final /* synthetic */ EditorsSynchronizer this$0;

            public void run() {
                TargetFrameworkIdWidget.Companion.updateSelf(this.this$0.getProject());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        this.syncWithProjectModelQueue.queue(new Update(this, "QueueSyncWidgets"){
            final /* synthetic */ EditorsSynchronizer this$0;

            public void run() {
                ProjectContextWidget.Companion.updateSelf(this.this$0.getProject());
                TargetFrameworkIdWidget.Companion.updateSelf(this.this$0.getProject());
            }
            {
                this.this$0 = $outer;
                super($super_call_param$1);
            }
        });
    }

    private final void syncWithProjectModel() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        VirtualFileIndex index = VirtualFileIndex.Companion.getInstance(this.project);
        List openedEditorsCopy = MapsKt.toList((Map)this.textControlHost.getOpenedEditors());
        for (Pair pair : openedEditorsCopy) {
            Integer projectModelId;
            VirtualFileIndexEntry projectModelEntry;
            VirtualFile virtualFile;
            EditableEntityId editableEntityId = ((TextControlId)pair.getFirst()).getDocumentId();
            Editor ideaEditor = (Editor)pair.getSecond();
            if (this.fileDocumentManager.getFile(ideaEditor.getDocument()) == null) {
                continue;
            }
            VirtualFile virtualFile2 = virtualFile;
            Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"virtualFile");
            if (index.get(virtualFile2) == null) {
                continue;
            }
            int oldProjectModelId = editableEntityId.getProjectModelElementId();
            HashSet<Integer> upToDateIds = projectModelEntry.getProjectModelIds();
            if (upToDateIds.contains(oldProjectModelId)) continue;
            Integer n2 = projectModelId = (Integer)CollectionsKt.firstOrNull((Iterable)upToDateIds);
            this.textControlHost.ensureIdForEditor(ideaEditor, n2 != null ? n2 : 0);
        }
        this.textControlHost.syncFocusedEditor$rider();
        ProjectContextWidget.Companion.updateSelf(this.project);
        TargetFrameworkIdWidget.Companion.updateSelf(this.project);
    }

    public void frameCreated(@Nullable IdeFrame frame) {
        IdeFrame ideFrame = frame;
        if (ideFrame == null) {
            Intrinsics.throwNpe();
        }
        this.installWidgets(ideFrame);
    }

    public void beforeFrameReleased(@Nullable IdeFrame frame) {
        IdeFrame ideFrame = frame;
        if (ideFrame == null) {
            Intrinsics.throwNpe();
        }
        this.uninstallWidget(ideFrame);
    }

    private final void installWidgets(IdeFrame frame) {
        StatusBar statusBar = frame.getStatusBar();
        if (statusBar == null) {
            return;
        }
        StatusBar statusBar2 = statusBar;
        statusBar2.addWidget((StatusBarWidget)new ProjectContextWidget(this.project, VirtualFileIndex.Companion.getInstance(this.project), this.projectModelViewHost), "before Position");
        statusBar2.addWidget((StatusBarWidget)new TargetFrameworkIdWidget(this.project, VirtualFileIndex.Companion.getInstance(this.project), this.projectModelViewHost), "before " + ProjectContextWidget.Companion.getID());
    }

    private final void uninstallWidget(IdeFrame frame) {
        StatusBar statusBar = frame.getStatusBar();
        if (statusBar == null) {
            return;
        }
        StatusBar statusBar2 = statusBar;
        statusBar2.removeWidget(ProjectContextWidget.Companion.getID());
        statusBar2.removeWidget(TargetFrameworkIdWidget.Companion.getID());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final TextControlHost getTextControlHost() {
        return this.textControlHost;
    }

    @NotNull
    public final ProjectModelViewHost getProjectModelViewHost() {
        return this.projectModelViewHost;
    }

    @NotNull
    public final FileDocumentManager getFileDocumentManager() {
        return this.fileDocumentManager;
    }

    public EditorsSynchronizer(@NotNull Project project2, @NotNull TextControlHost textControlHost, @NotNull ProjectModelViewHost projectModelViewHost, @NotNull FileDocumentManager fileDocumentManager) {
        Logger logger;
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)textControlHost, (String)"textControlHost");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        Intrinsics.checkParameterIsNotNull((Object)fileDocumentManager, (String)"fileDocumentManager");
        this.$$delegate_0 = new LifetimedComponent(project2);
        this.project = project2;
        this.textControlHost = textControlHost;
        this.projectModelViewHost = projectModelViewHost;
        this.fileDocumentManager = fileDocumentManager;
        EditorsSynchronizer editorsSynchronizer = this;
        Logger logger2 = Logger.getInstance(EditorsSynchronizer.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger2, (String)"Logger.getInstance(T::class.java)");
        editorsSynchronizer.logger = logger = logger2;
        this.syncWithProjectModelQueue = new MergingUpdateQueue("syncEditorsQueue", 1000, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.project, null, true).setRestartTimerOnAdd(false);
        this.syncTargetFrameworkModelQueue = new MergingUpdateQueue("syncEditorsQueue", 200, true, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this.project, null, true).setRestartTimerOnAdd(true);
        ApplicationKt.getApplication().getMessageBus().connect((Disposable)this.project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)this);
        this.syncWithProjectModelQueue.setPassThrough(false);
        this.syncTargetFrameworkModelQueue.setPassThrough(false);
        final MyVirtualFileListener myVirtualFileListener = new MyVirtualFileListener(this);
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)myVirtualFileListener, (Disposable)this.project);
        WindowManager.getInstance().addListener((WindowManagerListener)this);
        this.getComponentLifetime().add((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                VirtualFileManager.getInstance().removeVirtualFileListener((VirtualFileListener)myVirtualFileListener);
                WindowManager.getInstance().removeListener((WindowManagerListener)this);
            }
        }));
        this.projectModelViewHost.getAddSignal().advise(this.getComponentLifetime(), (Function1<ProjectModelNode, Unit>)((Function1)new Function1<ProjectModelNode, Unit>(){

            public final void invoke(@NotNull ProjectModelNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                syncWithProjectModelQueue.queue(new Update("QueueSyncEditors"){

                    public void run() {
                        this.syncWithProjectModel();
                    }
                });
            }
        }));
        this.projectModelViewHost.getRemoveSignal().advise(this.getComponentLifetime(), (Function1<ProjectModelNode, Unit>)((Function1)new Function1<ProjectModelNode, Unit>(){

            public final void invoke(@NotNull ProjectModelNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                syncWithProjectModelQueue.queue(new Update("QueueSyncEditors"){

                    public void run() {
                        this.syncWithProjectModel();
                    }
                });
            }
        }));
        this.projectModelViewHost.getUpdateSignal().advise(this.getComponentLifetime(), (Function1<ProjectModelNode, Unit>)((Function1)new Function1<ProjectModelNode, Unit>(){

            public final void invoke(@NotNull ProjectModelNode it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                syncWithProjectModelQueue.queue(new Update("QueueSyncEditors"){

                    public void run() {
                        this.syncWithProjectModel();
                    }
                });
            }
        }));
        SolutionHostExtensionsKt.getSolution(this.project).getProjectModelTasks().getTargetFrameworks().view(this.getComponentLifetime(), (Function3<Lifetime, Integer, RdProjectTargetFramework, Unit>)((Function3)new Function3<Lifetime, Integer, RdProjectTargetFramework, Unit>(){

            public final void invoke(@NotNull Lifetime projectLifetime, int projectId, @NotNull RdProjectTargetFramework properties) {
                Intrinsics.checkParameterIsNotNull((Object)projectLifetime, (String)"projectLifetime");
                Intrinsics.checkParameterIsNotNull((Object)properties, (String)"properties");
                this.queueUpdateTargetFrameworkWidget();
                properties.getCurrentTargetFrameworkId().advise(projectLifetime, (Function1<String, Unit>)((Function1)new Function1<String, Unit>(){

                    public final void invoke(@NotNull String it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        this.queueUpdateTargetFrameworkWidget();
                    }
                }));
            }
        }));
    }

    @Override
    @NotNull
    public Lifetime getComponentLifetime() {
        return this.$$delegate_0.getComponentLifetime();
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lcom/jetbrains/resharper/editors/EditorsSynchronizer$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileAdapter;", "owner", "Lcom/jetbrains/resharper/editors/EditorsSynchronizer;", "(Lcom/jetbrains/resharper/editors/EditorsSynchronizer;)V", "getOwner", "()Lcom/jetbrains/resharper/editors/EditorsSynchronizer;", "fileMoved", "", "event", "Lcom/intellij/openapi/vfs/VirtualFileMoveEvent;", "propertyChanged", "Lcom/intellij/openapi/vfs/VirtualFilePropertyEvent;", "rider"})
    private static final class MyVirtualFileListener
    extends VirtualFileAdapter {
        @NotNull
        private final EditorsSynchronizer owner;

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            this.owner.syncWithProjectModelQueue.queue(new Update(this, "QueueSyncEditors"){
                final /* synthetic */ MyVirtualFileListener this$0;

                public void run() {
                    EditorsSynchronizer.access$syncWithProjectModel(this.this$0.getOwner());
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            });
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            this.owner.syncWithProjectModelQueue.queue(new Update(this, "QueueSyncEditors"){
                final /* synthetic */ MyVirtualFileListener this$0;

                public void run() {
                    EditorsSynchronizer.access$syncWithProjectModel(this.this$0.getOwner());
                }
                {
                    this.this$0 = $outer;
                    super($super_call_param$1);
                }
            });
        }

        @NotNull
        public final EditorsSynchronizer getOwner() {
            return this.owner;
        }

        public MyVirtualFileListener(@NotNull EditorsSynchronizer owner) {
            Intrinsics.checkParameterIsNotNull((Object)owner, (String)"owner");
            this.owner = owner;
        }
    }
}

