/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.resharper.editors.ChangeToSpecificProjectContextAction;
import com.jetbrains.resharper.editors.EditorContextWidget;
import com.jetbrains.resharper.editors.EditorContextWidgetAction;
import com.jetbrains.resharper.editors.TextControlUtilsKt;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.index.VirtualFileIndexEntry;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0014J \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\u0016H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/resharper/editors/ProjectContextWidget;", "Lcom/jetbrains/resharper/editors/EditorContextWidget;", "project", "Lcom/intellij/openapi/project/Project;", "fileIndex", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;)V", "ID", "", "getActionGroupName", "getActions", "Ljava/util/ArrayList;", "Lcom/jetbrains/resharper/editors/EditorContextWidgetAction;", "Lkotlin/collections/ArrayList;", "selectedFileLocal", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFacadeText", "getPopupTitle", "getToolTipHeader", "isEnabled", "", "Companion", "rider"})
public class ProjectContextWidget
extends EditorContextWidget {
    @NotNull
    private static final String ID = "ProjectContext";
    public static final Companion Companion = new Companion(null);

    @Override
    protected boolean isEnabled() {
        Collection collection;
        VirtualFile virtualFile = this.getSelectedFile();
        if (virtualFile == null) {
            return false;
        }
        VirtualFile file2 = virtualFile;
        VirtualFileIndex virtualFileIndex = this.getFileIndex();
        VirtualFile virtualFile2 = file2;
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"file");
        VirtualFileIndexEntry fileEntry = virtualFileIndex.get(virtualFile2);
        return fileEntry != null ? (collection = (Collection)fileEntry.getProjectModelIds()).size() > 1 : false;
    }

    @Override
    @NotNull
    public String getToolTipHeader() {
        return "Project Context: %s";
    }

    @NotNull
    public String ID() {
        return Companion.getID();
    }

    @Override
    @NotNull
    protected String getFacadeText() {
        Editor editor = this.getEditor();
        if (editor == null) {
            Intrinsics.throwNpe();
        }
        String context2 = TextControlUtilsKt.getProjectName(editor, this.getProjectModelViewHost());
        return context2;
    }

    @Override
    @NotNull
    protected String getPopupTitle() {
        return "Project context";
    }

    @Override
    @NotNull
    protected String getActionGroupName() {
        return "ChangeProjectContext";
    }

    @Override
    @NotNull
    protected ArrayList<EditorContextWidgetAction> getActions(@NotNull VirtualFile selectedFileLocal) {
        Intrinsics.checkParameterIsNotNull((Object)selectedFileLocal, (String)"selectedFileLocal");
        ArrayList<EditorContextWidgetAction> result2 = new ArrayList<EditorContextWidgetAction>();
        VirtualFileIndexEntry entry = this.getFileIndex().get(selectedFileLocal);
        if (entry != null) {
            for (Integer projectModelId : entry.getProjectModelIds()) {
                ProjectModelNode containingProjectNode;
                Collection collection;
                ProjectModelNode projectModelNode;
                ProjectModelViewHost projectModelViewHost = this.getProjectModelViewHost();
                Integer n2 = projectModelId;
                Intrinsics.checkExpressionValueIsNotNull((Object)n2, (String)"projectModelId");
                if (projectModelViewHost.getItemById(n2) == null) {
                    return new ArrayList<EditorContextWidgetAction>();
                }
                if (ProjectModelNodeExtensionKt.containingProject(projectModelNode) == null) {
                    return new ArrayList<EditorContextWidgetAction>();
                }
                ProjectModelViewHost projectModelViewHost2 = this.getProjectModelViewHost();
                Integer n3 = projectModelId;
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"projectModelId");
                if (ProjectModelNodeExtensionKt.isFromSharedProject(projectModelViewHost2, n3) && (collection = (Collection)entry.getProjectModelIds()).size() > 1) continue;
                String string2 = containingProjectNode.getName();
                Integer n4 = projectModelId;
                Intrinsics.checkExpressionValueIsNotNull((Object)n4, (String)"projectModelId");
                int n5 = n4;
                Editor editor = this.getEditor();
                if (editor == null) {
                    Intrinsics.throwNpe();
                }
                ChangeToSpecificProjectContextAction action2 = new ChangeToSpecificProjectContextAction(string2, n5, this, TextControlUtilsKt.getProjectModelId(editor));
                result2.add(action2);
            }
        }
        return result2;
    }

    public ProjectContextWidget(@NotNull Project project2, @NotNull VirtualFileIndex fileIndex, @NotNull ProjectModelViewHost projectModelViewHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileIndex), (String)"fileIndex");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        super(project2, fileIndex, projectModelViewHost);
    }

    static {
        ID = ID;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/editors/ProjectContextWidget$Companion;", "", "()V", "ID", "", "getID", "()Ljava/lang/String;", "updateSelf", "", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        @NotNull
        public final String getID() {
            return ID;
        }

        public final void updateSelf(@NotNull Project project2) {
            block1: {
                ProjectContextWidget projectContextWidget;
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
                StatusBarWidget statusBarWidget = statusBar != null ? statusBar.getWidget(Companion.getID()) : null;
                if (!(statusBarWidget instanceof ProjectContextWidget)) {
                    statusBarWidget = null;
                }
                ProjectContextWidget projectContextWidget2 = projectContextWidget = (ProjectContextWidget)statusBarWidget;
                if (projectContextWidget2 == null) break block1;
                projectContextWidget2.update();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

