/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.resharper.editors;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.WindowManager;
import com.jetbrains.resharper.editors.ChangeToSpecificTargetFrameworkAction;
import com.jetbrains.resharper.editors.EditorContextWidget;
import com.jetbrains.resharper.editors.EditorContextWidgetAction;
import com.jetbrains.resharper.editors.TextControlUtilsKt;
import com.jetbrains.resharper.projectView.ProjectModelViewHost;
import com.jetbrains.resharper.projectView.SolutionHostExtensionsKt;
import com.jetbrains.resharper.projectView.index.VirtualFileIndex;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNode;
import com.jetbrains.resharper.projectView.nodes.ProjectModelNodeExtensionKt;
import com.jetbrains.resharper.util.idea.ApplicationKt;
import com.jetbrains.rider.model.RdProjectTargetFramework;
import java.util.ArrayList;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0014J \u0010\f\u001a\u0012\u0012\u0004\u0012\u00020\u000e0\rj\b\u0012\u0004\u0012\u00020\u000e`\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\nH\u0014J\b\u0010\u0013\u001a\u00020\nH\u0014J\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\b\u0010\u0016\u001a\u00020\nH\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\b\u0010\u0019\u001a\u00020\u001aH\u0016\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/resharper/editors/TargetFrameworkIdWidget;", "Lcom/jetbrains/resharper/editors/EditorContextWidget;", "project", "Lcom/intellij/openapi/project/Project;", "fileIndex", "Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;", "projectModelViewHost", "Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/resharper/projectView/index/VirtualFileIndex;Lcom/jetbrains/resharper/projectView/ProjectModelViewHost;)V", "ID", "", "getActionGroupName", "getActions", "Ljava/util/ArrayList;", "Lcom/jetbrains/resharper/editors/EditorContextWidgetAction;", "Lkotlin/collections/ArrayList;", "selectedFileLocal", "Lcom/intellij/openapi/vfs/VirtualFile;", "getFacadeText", "getPopupTitle", "getProperties", "Lcom/jetbrains/rider/model/RdProjectTargetFramework;", "getToolTipHeader", "isEnabled", "", "update", "", "Companion", "rider"})
public final class TargetFrameworkIdWidget
extends EditorContextWidget {
    @NotNull
    private static final String ID = "TargetFrameworkId";
    public static final Companion Companion = new Companion(null);

    @Override
    @NotNull
    public String getToolTipHeader() {
        return "Target framework: %s";
    }

    @NotNull
    public String ID() {
        return Companion.getID();
    }

    @Override
    protected boolean isEnabled() {
        Collection collection;
        RdProjectTargetFramework properties = this.getProperties();
        return properties != null && (collection = (Collection)properties.getTargetFrameworkIds().getValue()).size() > 1;
    }

    @Override
    public void update() {
        if (!this.isEnabled()) {
            this.getMyComponent().setVisible(false);
            return;
        }
        this.getMyComponent().setVisible(true);
        super.update();
    }

    @Override
    @NotNull
    protected String getFacadeText() {
        RdProjectTargetFramework rdProjectTargetFramework = this.getProperties();
        if (rdProjectTargetFramework == null) {
            Intrinsics.throwNpe();
        }
        return rdProjectTargetFramework.getCurrentTargetFrameworkId().getValue();
    }

    @Nullable
    public final RdProjectTargetFramework getProperties() {
        ApplicationKt.getApplication().assertIsDispatchThread();
        Editor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        Editor editorCopy = editor;
        Project project2 = this.getProject();
        if (project2 == null) {
            return null;
        }
        Project projectCopy = project2;
        ProjectModelNode projectModelNode = this.getProjectModelViewHost().getItemById(TextControlUtilsKt.getProjectModelId(editorCopy));
        if (projectModelNode == null) {
            return null;
        }
        ProjectModelNode projectModelNode2 = projectModelNode;
        ProjectModelNode projectModelNode3 = ProjectModelNodeExtensionKt.containingProject(projectModelNode2);
        if (projectModelNode3 == null) {
            return null;
        }
        ProjectModelNode containingProjectNode = projectModelNode3;
        return (RdProjectTargetFramework)SolutionHostExtensionsKt.getSolution(projectCopy).getProjectModelTasks().getTargetFrameworks().get(containingProjectNode.getId());
    }

    @Override
    @NotNull
    protected String getPopupTitle() {
        return "Target framework";
    }

    @Override
    @NotNull
    protected String getActionGroupName() {
        return "ChangeTargetFramework";
    }

    @Override
    @NotNull
    protected ArrayList<EditorContextWidgetAction> getActions(@NotNull VirtualFile selectedFileLocal) {
        Intrinsics.checkParameterIsNotNull((Object)selectedFileLocal, (String)"selectedFileLocal");
        ArrayList<EditorContextWidgetAction> result2 = new ArrayList<EditorContextWidgetAction>();
        ProjectModelViewHost projectModelViewHost = this.getProjectModelViewHost();
        Editor editor = this.getEditor();
        if (editor == null) {
            Intrinsics.throwNpe();
        }
        ProjectModelNode projectModelNode = projectModelViewHost.getItemById(TextControlUtilsKt.getProjectModelId(editor));
        if (projectModelNode == null) {
            Intrinsics.throwNpe();
        }
        ProjectModelNode projectModelNode2 = projectModelNode;
        ProjectModelNode projectModelNode3 = ProjectModelNodeExtensionKt.containingProject(projectModelNode2);
        if (projectModelNode3 == null) {
            Intrinsics.throwNpe();
        }
        ProjectModelNode containingProjectNode = projectModelNode3;
        RdProjectTargetFramework rdProjectTargetFramework = this.getProperties();
        if (rdProjectTargetFramework == null) {
            return new ArrayList<EditorContextWidgetAction>();
        }
        RdProjectTargetFramework properties = rdProjectTargetFramework;
        String currentTargetFrameworkId = properties.getCurrentTargetFrameworkId().getValue();
        for (String id : properties.getTargetFrameworkIds().getValue()) {
            ChangeToSpecificTargetFrameworkAction frameworkAction = new ChangeToSpecificTargetFrameworkAction(id, containingProjectNode.getId(), this, currentTargetFrameworkId);
            result2.add(frameworkAction);
        }
        return result2;
    }

    public TargetFrameworkIdWidget(@NotNull Project project2, @NotNull VirtualFileIndex fileIndex, @NotNull ProjectModelViewHost projectModelViewHost) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fileIndex), (String)"fileIndex");
        Intrinsics.checkParameterIsNotNull((Object)projectModelViewHost, (String)"projectModelViewHost");
        super(project2, fileIndex, projectModelViewHost);
    }

    static {
        ID = ID;
    }

    @Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/resharper/editors/TargetFrameworkIdWidget$Companion;", "", "()V", "ID", "", "getID", "()Ljava/lang/String;", "updateSelf", "", "project", "Lcom/intellij/openapi/project/Project;", "rider"})
    public static final class Companion {
        @NotNull
        public final String getID() {
            return ID;
        }

        public final void updateSelf(@NotNull Project project2) {
            block1: {
                TargetFrameworkIdWidget me;
                Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
                StatusBar statusBar = WindowManager.getInstance().getStatusBar(project2);
                StatusBarWidget statusBarWidget = statusBar != null ? statusBar.getWidget(Companion.getID()) : null;
                if (!(statusBarWidget instanceof TargetFrameworkIdWidget)) {
                    statusBarWidget = null;
                }
                TargetFrameworkIdWidget targetFrameworkIdWidget = me = (TargetFrameworkIdWidget)statusBarWidget;
                if (targetFrameworkIdWidget == null) break block1;
                targetFrameworkIdWidget.update();
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

